/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.actions.patterns.dataAccess;

import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.facet.ui.libraries.LibraryInfo;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.spring.model.actions.patterns.dataAccess.JpaEntityManagerBeanGenerateProvider;
import com.intellij.spring.model.actions.patterns.frameworks.AbstractFrameworkIntegrationAction;
import com.intellij.spring.model.actions.patterns.frameworks.ui.LibrariesInfo;
import com.intellij.spring.model.actions.patterns.frameworks.ui.TemplateInfo;
import com.intellij.spring.model.actions.patterns.frameworks.util.LibrariesConfigurationManager;
import icons.SpringPersistenceIntegrationIcons;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class JpaPatternAction
extends AbstractFrameworkIntegrationAction {
    @NonNls
    private static final String JPA_STRING_ID = "jpa";
    @NonNls
    private static final String JPA_FACET_NAME = "Jpa";

    protected String[] getBeansClassNames() {
        return new String[]{"org.springframework.orm.jpa.LocalEntityManagerFactoryBean"};
    }

    public LibrariesInfo getLibrariesInfo(Module module) {
        LibraryInfo[] libraryInfos = LibrariesConfigurationManager.getInstance((Project)module.getProject()).getLibraryInfos(JPA_STRING_ID);
        return new LibrariesInfo(libraryInfos, module, JPA_STRING_ID);
    }

    public List<TemplateInfo> getTemplateInfos(Module module) {
        LinkedList<TemplateInfo> infos = new LinkedList<TemplateInfo>();
        TemplateSettings settings = TemplateSettings.getInstance();
        TemplateImpl template = (TemplateImpl)JpaEntityManagerBeanGenerateProvider.getTemplate(module.getProject());
        template.setId("jpa-entity-manager-factory");
        TemplateInfo emf = new TemplateInfo(module, (Template)template, "JPA Entity Manager Factory Bean", null);
        TemplateInfo cemf = new TemplateInfo(module, settings.getTemplateById("jpa-container-entity-manager-factory"), "JPA Container Entity Manager Factory Bean", null, false);
        TemplateInfo pum = new TemplateInfo(module, settings.getTemplateById("jpa-persistent-unit-manager"), "JPA Persistence Unit Manager", null, false);
        TemplateInfo tm = new TemplateInfo(module, settings.getTemplateById("jpa-transaction-manager"), "Transaction Manager", null);
        TemplateInfo anno = new TemplateInfo(module, settings.getTemplateById("jpa-anno-post-processor"), "JPA Annotation Bean Post Processor", null, false);
        TemplateInfo ex = new TemplateInfo(module, settings.getTemplateById("jpa-ex-translation-post-processor"), "JPA Exception Translation Post Processor", null, false);
        infos.add(emf);
        infos.add(cemf);
        infos.add(pum);
        infos.add(tm);
        infos.add(anno);
        infos.add(ex);
        return infos;
    }

    @Nullable
    protected String getFacetId() {
        return JPA_STRING_ID;
    }

    public String getDescription() {
        return "JPA";
    }

    @Nullable
    protected Icon getIcon() {
        return SpringPersistenceIntegrationIcons.Jpa;
    }
}

