/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.websocket.utils;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.jam.JamService;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedElementsSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.websocket.constants.WebSocketAnnoConstants;
import com.intellij.websocket.jam.WebSocketClientEndpoint;
import com.intellij.websocket.jam.WebSocketEndpoint;
import com.intellij.websocket.jam.WebSocketPathParam;
import com.intellij.websocket.jam.WebSocketServerEndpoint;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebSocketCommonUtils {
    private WebSocketCommonUtils() {
    }

    public static boolean isWebSocketInstalled(@Nullable Module module) {
        if (module == null || module.isDisposed()) {
            return false;
        }
        return JavaPsiFacade.getInstance((Project)module.getProject()).findClass("javax.websocket.server.ServerEndpoint", GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module)) != null;
    }

    @Nullable
    public static WebSocketEndpoint getWebsocketEndpoint(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            WebSocketCommonUtils.$$$reportNull$$$0(0);
        }
        return (WebSocketEndpoint)JamService.getJamService((Project)psiClass.getProject()).getJamElement(WebSocketEndpoint.WEB_SOCKET_JAM_KEY, (PsiElement)psiClass);
    }

    @NotNull
    public static List<WebSocketPathParam> getPathParams(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            WebSocketCommonUtils.$$$reportNull$$$0(1);
        }
        ArrayList<WebSocketPathParam> params = new ArrayList<WebSocketPathParam>();
        JamService service = JamService.getJamService((Project)psiClass.getProject());
        PsiFile file = psiClass.getContainingFile().getOriginalFile();
        PsiClass annoClass = JavaPsiFacade.getInstance((Project)psiClass.getProject()).findClass("javax.websocket.server.PathParam", GlobalSearchScope.allScope((Project)psiClass.getProject()));
        if (annoClass != null) {
            for (PsiParameter parameter : AnnotatedElementsSearch.searchPsiParameters((PsiClass)annoClass, (SearchScope)GlobalSearchScope.fileScope((PsiFile)file.getOriginalFile())).findAll()) {
                WebSocketPathParam param = (WebSocketPathParam)service.getJamElement((PsiElement)parameter, new JamMemberMeta[]{WebSocketPathParam.META});
                if (param == null) continue;
                params.add(param);
            }
        }
        ArrayList<WebSocketPathParam> arrayList = params;
        if (arrayList == null) {
            WebSocketCommonUtils.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @Nullable
    public static WebSocketServerEndpoint getServerEndpoint(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            WebSocketCommonUtils.$$$reportNull$$$0(3);
        }
        return (WebSocketServerEndpoint)JamService.getJamService((Project)psiClass.getProject()).getJamElement((PsiElement)psiClass, new JamMemberMeta[]{WebSocketServerEndpoint.META});
    }

    @Nullable
    public static WebSocketClientEndpoint getClientEndpoint(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            WebSocketCommonUtils.$$$reportNull$$$0(4);
        }
        return (WebSocketClientEndpoint)JamService.getJamService((Project)psiClass.getProject()).getJamElement((PsiElement)psiClass, new JamMemberMeta[]{WebSocketClientEndpoint.META});
    }

    public static boolean isTextMessageProcessingMethod(@NotNull PsiMethod psiMethod, @NotNull Set<? extends PsiClass> decoders) {
        if (psiMethod == null) {
            WebSocketCommonUtils.$$$reportNull$$$0(5);
        }
        if (decoders == null) {
            WebSocketCommonUtils.$$$reportNull$$$0(6);
        }
        for (PsiParameter parameter : psiMethod.getParameterList().getParameters()) {
            if (WebSocketCommonUtils.isOptionalParameter(parameter) || !WebSocketCommonUtils.isTextMessageParameterType(parameter.getType(), psiMethod.getProject(), decoders)) continue;
            return true;
        }
        return false;
    }

    public static boolean isOptionalParameter(PsiParameter parameter) {
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)parameter, (String)"javax.websocket.server.PathParam", (int)0) || InheritanceUtil.isInheritor((PsiType)parameter.getType(), (String)"javax.websocket.Session");
    }

    public static boolean isBinaryMessageProcessingMethod(@NotNull PsiMethod method, @NotNull Set<? extends PsiClass> decoders) {
        if (method == null) {
            WebSocketCommonUtils.$$$reportNull$$$0(7);
        }
        if (decoders == null) {
            WebSocketCommonUtils.$$$reportNull$$$0(8);
        }
        for (PsiParameter parameter : method.getParameterList().getParameters()) {
            if (WebSocketCommonUtils.isOptionalParameter(parameter) || !WebSocketCommonUtils.isBinaryMessageParameterType(parameter.getType(), method.getProject(), decoders)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPongMessageProcessingMethod(@NotNull PsiMethod method) {
        if (method == null) {
            WebSocketCommonUtils.$$$reportNull$$$0(9);
        }
        for (PsiParameter parameter : method.getParameterList().getParameters()) {
            if (WebSocketCommonUtils.isOptionalParameter(parameter) || !WebSocketCommonUtils.isPongMessageParameterType(parameter.getType())) continue;
            return true;
        }
        return false;
    }

    public static boolean isPongMessageParameterType(PsiType type) {
        return InheritanceUtil.isInheritor((PsiType)type, (String)"javax.websocket.PongMessage");
    }

    public static boolean isBinaryMessageParameterType(@NotNull PsiType type, @NotNull Project project, @NotNull Set<? extends PsiClass> decoders) {
        if (type == null) {
            WebSocketCommonUtils.$$$reportNull$$$0(10);
        }
        if (project == null) {
            WebSocketCommonUtils.$$$reportNull$$$0(11);
        }
        if (decoders == null) {
            WebSocketCommonUtils.$$$reportNull$$$0(12);
        }
        if (InheritanceUtil.isInheritor((PsiType)type, (String)"java.io.InputStream")) {
            return true;
        }
        if (InheritanceUtil.isInheritor((PsiType)type, (String)"java.nio.ByteBuffer")) {
            return true;
        }
        if (type instanceof PsiArrayType && ((PsiArrayType)type).getComponentType().equals(PsiType.BYTE)) {
            return true;
        }
        return WebSocketCommonUtils.hasBinaryDecoderForType(type, decoders, project);
    }

    public static boolean isTextMessageParameterType(@NotNull PsiType type, @NotNull Project project, @NotNull Set<? extends PsiClass> decoders) {
        if (type == null) {
            WebSocketCommonUtils.$$$reportNull$$$0(13);
        }
        if (project == null) {
            WebSocketCommonUtils.$$$reportNull$$$0(14);
        }
        if (decoders == null) {
            WebSocketCommonUtils.$$$reportNull$$$0(15);
        }
        if (type instanceof PsiPrimitiveType || PsiPrimitiveType.getUnboxedType((PsiType)type) != null) {
            return true;
        }
        if ("java.lang.String".equals(type.getCanonicalText())) {
            return true;
        }
        if (InheritanceUtil.isInheritor((PsiType)type, (String)"java.io.Reader")) {
            return true;
        }
        return WebSocketCommonUtils.hasTextDecoderForType(type, decoders, project);
    }

    public static boolean hasTextDecoderForType(@NotNull PsiType type, @NotNull Set<? extends PsiClass> decoders, @NotNull Project project) {
        if (type == null) {
            WebSocketCommonUtils.$$$reportNull$$$0(16);
        }
        if (decoders == null) {
            WebSocketCommonUtils.$$$reportNull$$$0(17);
        }
        if (project == null) {
            WebSocketCommonUtils.$$$reportNull$$$0(18);
        }
        return WebSocketCommonUtils.hasDecoderForType(type, decoders, project, WebSocketAnnoConstants.TEXT_DECODERS);
    }

    private static boolean hasBinaryDecoderForType(@NotNull PsiType type, @NotNull Set<? extends PsiClass> decoders, @NotNull Project project) {
        if (type == null) {
            WebSocketCommonUtils.$$$reportNull$$$0(19);
        }
        if (decoders == null) {
            WebSocketCommonUtils.$$$reportNull$$$0(20);
        }
        if (project == null) {
            WebSocketCommonUtils.$$$reportNull$$$0(21);
        }
        return WebSocketCommonUtils.hasDecoderForType(type, decoders, project, WebSocketAnnoConstants.BINARY_DECODERS);
    }

    private static boolean hasDecoderForType(@NotNull PsiType type, @NotNull Set<? extends PsiClass> decoders, @NotNull Project project, @NotNull String[] decodersBaseClasses) {
        if (type == null) {
            WebSocketCommonUtils.$$$reportNull$$$0(22);
        }
        if (decoders == null) {
            WebSocketCommonUtils.$$$reportNull$$$0(23);
        }
        if (project == null) {
            WebSocketCommonUtils.$$$reportNull$$$0(24);
        }
        if (decodersBaseClasses == null) {
            WebSocketCommonUtils.$$$reportNull$$$0(25);
        }
        for (PsiClass psiClass : decoders) {
            PsiClassType psiClassType = JavaPsiFacade.getInstance((Project)project).getElementFactory().createType(psiClass);
            for (String decoderBaseClass : decodersBaseClasses) {
                PsiType psiType = PsiUtil.substituteTypeParameter((PsiType)psiClassType, (String)decoderBaseClass, (int)0, (boolean)false);
                if (psiType == null || !type.isAssignableFrom(psiType)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasEncoderForType(@NotNull PsiType type, @NotNull Set<? extends PsiClass> encoders, Project project) {
        if (type == null) {
            WebSocketCommonUtils.$$$reportNull$$$0(26);
        }
        if (encoders == null) {
            WebSocketCommonUtils.$$$reportNull$$$0(27);
        }
        for (PsiClass psiClass : encoders) {
            PsiClassType psiClassType = JavaPsiFacade.getInstance((Project)project).getElementFactory().createType(psiClass);
            for (String encoderBaseClass : WebSocketAnnoConstants.ENCODERS) {
                PsiType psiType = PsiUtil.substituteTypeParameter((PsiType)psiClassType, (String)encoderBaseClass, (int)0, (boolean)false);
                if (psiType == null || !type.isAssignableFrom(psiType)) continue;
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/websocket/utils/WebSocketCommonUtils";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
            case 6: 
            case 8: 
            case 12: 
            case 15: 
            case 17: 
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decoders";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 10: 
            case 13: 
            case 16: 
            case 19: 
            case 22: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 11: 
            case 14: 
            case 18: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decodersBaseClasses";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "encoders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/websocket/utils/WebSocketCommonUtils";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathParams";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getWebsocketEndpoint";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getPathParams";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getServerEndpoint";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getClientEndpoint";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isTextMessageProcessingMethod";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isBinaryMessageProcessingMethod";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isPongMessageProcessingMethod";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isBinaryMessageParameterType";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isTextMessageParameterType";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "hasTextDecoderForType";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "hasBinaryDecoderForType";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "hasDecoderForType";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "hasEncoderForType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

