/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ee.websocket.highlighting;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.ee.websocket.highlighting.WebSocketBaseInspection;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.hash.HashSet;
import com.intellij.websocket.jam.WebSocketEndpoint;
import com.intellij.websocket.resources.WebSocketInspectionBundle;
import com.intellij.websocket.utils.WebSocketCommonUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ServerEndpointInconsistencyInspection
extends WebSocketBaseInspection {
    private static final String[] METHOD_ANNOTATIONS = new String[]{"javax.websocket.OnOpen", "javax.websocket.OnClose", "javax.websocket.OnError"};

    @Override
    protected void checkClass(PsiClass aClass, ProblemsHolder holder, @NotNull Module module) {
        WebSocketEndpoint endpoint;
        if (module == null) {
            ServerEndpointInconsistencyInspection.$$$reportNull$$$0(0);
        }
        boolean isAnnotatedEndpoint = (endpoint = WebSocketCommonUtils.getWebsocketEndpoint(aClass)) != null;
        boolean isEndpointInheritor = InheritanceUtil.isInheritor((PsiClass)aClass, (String)"javax.websocket.Endpoint");
        if (!isAnnotatedEndpoint && !isEndpointInheritor) {
            return;
        }
        Set<Object> decoders = endpoint == null ? Collections.emptySet() : endpoint.getDecoders();
        MultiMap methods = new MultiMap();
        HashSet onTextMessages = new HashSet();
        HashSet onBinaryMessages = new HashSet();
        HashSet onPongMessages = new HashSet();
        for (PsiMethod method : aClass.getMethods()) {
            for (String s : METHOD_ANNOTATIONS) {
                if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)s, (int)1)) continue;
                methods.putValue((Object)s, (Object)method);
                break;
            }
            if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)"javax.websocket.OnMessage", (int)1)) continue;
            if (WebSocketCommonUtils.isTextMessageProcessingMethod(method, decoders)) {
                onTextMessages.add(method);
                continue;
            }
            if (WebSocketCommonUtils.isBinaryMessageProcessingMethod(method, decoders)) {
                onBinaryMessages.add(method);
                continue;
            }
            if (!WebSocketCommonUtils.isPongMessageProcessingMethod(method)) continue;
            onPongMessages.add(method);
        }
        ServerEndpointInconsistencyInspection.checkOnMessageMultipleMethods(holder, (Set<PsiMethod>)onTextMessages, "text");
        ServerEndpointInconsistencyInspection.checkOnMessageMultipleMethods(holder, (Set<PsiMethod>)onBinaryMessages, "binary");
        ServerEndpointInconsistencyInspection.checkOnMessageMultipleMethods(holder, (Set<PsiMethod>)onPongMessages, "pong");
        ServerEndpointInconsistencyInspection.checkLifecycleMethods(holder, isEndpointInheritor, (MultiMap<String, PsiMethod>)methods);
    }

    private static void checkLifecycleMethods(@NotNull ProblemsHolder holder, boolean isEndpointInheritor, @NotNull MultiMap<String, PsiMethod> methods) {
        if (holder == null) {
            ServerEndpointInconsistencyInspection.$$$reportNull$$$0(1);
        }
        if (methods == null) {
            ServerEndpointInconsistencyInspection.$$$reportNull$$$0(2);
        }
        for (Map.Entry entry : methods.entrySet()) {
            PsiIdentifier identifier;
            Collection psiMethods = (Collection)entry.getValue();
            String shortName = "@" + StringUtil.getShortName((String)((String)entry.getKey()));
            if (isEndpointInheritor) {
                if (psiMethods.size() <= 0) continue;
                for (PsiMethod method : psiMethods) {
                    identifier = method.getNameIdentifier();
                    if (identifier == null) continue;
                    holder.registerProblem((PsiElement)identifier, WebSocketInspectionBundle.message("ServerEndpointInconsistencyInspection.methods.are.not.allowed", shortName, "javax.websocket.Endpoint"), new LocalQuickFix[0]);
                }
                continue;
            }
            if (psiMethods.size() <= 1) continue;
            for (PsiMethod method : psiMethods) {
                identifier = method.getNameIdentifier();
                if (identifier == null) continue;
                holder.registerProblem((PsiElement)identifier, WebSocketInspectionBundle.message("ServerEndpointInconsistencyInspection.multiple.method.declarations", shortName), new LocalQuickFix[0]);
            }
        }
    }

    private static void checkOnMessageMultipleMethods(@NotNull ProblemsHolder holder, @NotNull Set<PsiMethod> psiMethods, @NotNull String text) {
        if (holder == null) {
            ServerEndpointInconsistencyInspection.$$$reportNull$$$0(3);
        }
        if (psiMethods == null) {
            ServerEndpointInconsistencyInspection.$$$reportNull$$$0(4);
        }
        if (text == null) {
            ServerEndpointInconsistencyInspection.$$$reportNull$$$0(5);
        }
        if (psiMethods.size() > 1) {
            for (PsiMethod psiMethod : psiMethods) {
                PsiIdentifier identifier = psiMethod.getNameIdentifier();
                if (identifier == null) continue;
                holder.registerProblem((PsiElement)identifier, WebSocketInspectionBundle.message("ServerEndpointInconsistencyInspection.multiple.on.message.method.declarations", text), new LocalQuickFix[0]);
            }
        }
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = WebSocketInspectionBundle.message("inspection.name.server.endpoint.inconsistency.errors", new Object[0]);
        if (string == null) {
            ServerEndpointInconsistencyInspection.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("ServerEndpointInconsistencyInspection" == null) {
            ServerEndpointInconsistencyInspection.$$$reportNull$$$0(7);
        }
        return "ServerEndpointInconsistencyInspection";
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            ServerEndpointInconsistencyInspection.$$$reportNull$$$0(8);
        }
        return highlightDisplayLevel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methods";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethods";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ee/websocket/highlighting/ServerEndpointInconsistencyInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ee/websocket/highlighting/ServerEndpointInconsistencyInspection";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkClass";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkLifecycleMethods";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkOnMessageMultipleMethods";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

