/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.ext.uml.actions;

import com.intellij.diagram.DiagramAction;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.Utils;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.ui.components.JBList;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.NanoXmlUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JList;
import net.n3.nanoxml.IXMLBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.dom.model.MavenDomDependency;
import org.jetbrains.idea.maven.dom.model.MavenDomExclusion;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.ext.uml.MavenElement;
import org.jetbrains.idea.maven.model.MavenArtifactNode;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.statistics.MavenActionsUsagesCollector;

public class MavenExcludeDependency
extends DiagramAction {
    public void perform(@NotNull AnActionEvent e) {
        if (e == null) {
            MavenExcludeDependency.$$$reportNull$$$0(0);
        }
        MavenActionsUsagesCollector.trigger((Project)e.getProject(), (AnAction)this, (AnActionEvent)e, (String[])new String[0]);
        DiagramNode selectedNode = (DiagramNode)MavenExcludeDependency.getSelectedNodesExceptNotes((AnActionEvent)e).get(0);
        MavenElement element = (MavenElement)selectedNode.getIdentifyingElement();
        MavenId id = element.getMavenId();
        DiagramBuilder builder = MavenExcludeDependency.getBuilder((AnActionEvent)e);
        if (builder == null) {
            return;
        }
        Runnable update = () -> {
            builder.getDataModel().refreshDataModel();
            builder.update(true, true);
        };
        Project project = e.getProject();
        MavenId current = element.getMavenId();
        HashMap<MavenProject, MavenId> projects = new HashMap<MavenProject, MavenId>();
        MavenProjectsManager manager = MavenProjectsManager.getInstance((Project)project);
        MavenProject p = null;
        for (MavenElement me = (parent = element.getParent()) == null ? null : (parent.isProject() ? parent.getParent() : parent); me != null; me = me.getParent()) {
            MavenArtifactNode artifact = me.getArtifact();
            if (artifact != null && (p = manager.findProject(artifact.getArtifact())) != null) {
                projects.put(p, current);
            } else if (me.isProject()) {
                p = me.getMavenProject();
                projects.put(p, current);
            }
            current = me.getMavenId();
        }
        while (p != null && p.getParentId() != null) {
            if ((p = manager.findProject(p.getParentId())) == null) continue;
            projects.put(p, current);
            current = p.getMavenId();
        }
        MavenExcludeDependency.removeProjectsWithoutDependencies(projects);
        if (projects.size() > 1) {
            HashMap<String, MavenProject> name2project = new HashMap<String, MavenProject>(projects.size());
            ArrayList<String> names = new ArrayList<String>(projects.size());
            for (MavenProject mp : projects.keySet()) {
                String key = mp.getMavenId().getArtifactId();
                names.add(key);
                name2project.put(key, mp);
            }
            JBList data = new JBList(names.toArray());
            JBPopup popup = JBPopupFactory.getInstance().createListPopupBuilder((JList)data).setTitle("Add exclude definition to").setItemChoosenCallback(() -> MavenExcludeDependency.lambda$perform$1((JList)data, name2project, names, project, id, projects, update)).createPopup();
            Utils.showPopupBeneathNode((JBPopup)popup, (Node)builder.getNode(selectedNode), (Graph2DView)builder.getView());
        } else if (projects.size() == 1) {
            MavenProject mp = (MavenProject)projects.keySet().iterator().next();
            MavenExcludeDependency.exclude(project, id, mp, (MavenId)projects.get(mp));
            ApplicationManager.getApplication().invokeLater(update);
        }
    }

    private static void removeProjectsWithoutDependencies(final Map<MavenProject, MavenId> projects) {
        ArrayList<MavenProject> toRemove = new ArrayList<MavenProject>();
        for (final MavenProject mp : projects.keySet()) {
            final boolean[] remove = new boolean[]{true};
            try {
                NanoXmlUtil.parse((InputStream)mp.getFile().getInputStream(), (IXMLBuilder)new NanoXmlUtil.IXMLBuilderAdapter(){
                    boolean inDependencies = false;
                    boolean inDependency = false;
                    boolean inArtifactId = false;
                    String artifactId = ((MavenId)projects.get(mp)).getArtifactId();

                    public void startElement(String name, String nsPrefix, String nsURI, String systemID, int lineNr) throws Exception {
                        this.setFlags(name, true);
                    }

                    public void addPCData(Reader reader, String systemID, int lineNr) throws Exception {
                        if (this.inDependencies && this.inDependencies && this.inArtifactId && new String(FileUtil.adaptiveLoadText((Reader)reader)).equals(this.artifactId)) {
                            remove[0] = false;
                        }
                    }

                    public void endElement(String name, String nsPrefix, String nsURI) throws Exception {
                        this.setFlags(name, false);
                    }

                    void setFlags(String name, boolean flag) {
                        if (name.equals("dependencies")) {
                            this.inDependencies = flag;
                        } else if (name.equals("dependency")) {
                            this.inDependency = flag;
                        } else if (name.equals("artifactId")) {
                            this.inArtifactId = flag;
                        }
                    }
                });
                if (!remove[0]) continue;
                toRemove.add(mp);
            }
            catch (IOException e) {
                toRemove.add(mp);
            }
        }
        for (MavenProject mavenProject : toRemove) {
            projects.remove(mavenProject);
        }
    }

    public static void exclude(Project project, MavenId id, MavenProject where, MavenId artifact) {
        CommandProcessor.getInstance().executeCommand(project, () -> ApplicationManager.getApplication().runWriteAction(() -> {
            DomFileElement p;
            VirtualFile file = where.getFile();
            if (ReadonlyStatusHandler.getInstance((Project)project).ensureFilesWritable(new VirtualFile[]{file}).hasReadonlyFiles()) {
                return;
            }
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
            if (psiFile instanceof XmlFile && (p = DomManager.getDomManager((Project)project).getFileElement((XmlFile)psiFile, MavenDomProjectModel.class)) != null) {
                for (MavenDomDependency d : ((MavenDomProjectModel)p.getRootElement()).getDependencies().getDependencies()) {
                    GenericDomValue artifactID = d.getArtifactId();
                    if (artifactID == null || !artifact.getArtifactId().equals(artifactID.getValue())) continue;
                    MavenDomExclusion exclusion = d.getExclusions().addExclusion();
                    exclusion.getArtifactId().setValue((Object)id.getArtifactId());
                    exclusion.getGroupId().setValue((Object)id.getGroupId());
                }
            }
        }), id.getArtifactId(), null);
    }

    public boolean isEnabled(@NotNull AnActionEvent e, DiagramBuilder builder) {
        if (e == null) {
            MavenExcludeDependency.$$$reportNull$$$0(1);
        }
        return MavenExcludeDependency.getSelectedNodesExceptNotes((AnActionEvent)e).size() == 1;
    }

    public String getActionName() {
        return "Exclude Maven Dependency";
    }

    private static /* synthetic */ void lambda$perform$1(JList data, Map name2project, List names, Project project, MavenId id, Map projects, Runnable update) {
        int index = data.getSelectedIndex();
        if (index > -1) {
            MavenProject mavenProject = (MavenProject)name2project.get(names.get(index));
            MavenExcludeDependency.exclude(project, id, mavenProject, (MavenId)projects.get(mavenProject));
            ApplicationManager.getApplication().invokeLater(update);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "org/jetbrains/idea/maven/ext/uml/actions/MavenExcludeDependency";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "perform";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabled";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

