/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.ext.jee;

import com.intellij.facet.ModifiableFacetModel;
import com.intellij.javaee.appServerIntegrations.AppServerDescriptorsMetaDataProvider;
import com.intellij.javaee.appServerIntegrations.AppServerIntegration;
import com.intellij.javaee.artifact.JavaeeArtifactUtil;
import com.intellij.javaee.facet.DescriptorMetaDataRegistry;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.facet.JavaeeFacetConfiguration;
import com.intellij.javaee.facet.JavaeeFacetType;
import com.intellij.javaee.openapi.ex.AppServerIntegrationsManager;
import com.intellij.openapi.externalSystem.service.project.ArtifactExternalDependenciesImporter;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactProperties;
import com.intellij.packaging.artifacts.ArtifactPropertiesProvider;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.artifacts.ModifiableArtifact;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementFactory;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.elements.ArchivePackagingElement;
import com.intellij.packaging.impl.elements.ManifestFileUtil;
import com.intellij.packaging.ui.ManifestFileConfiguration;
import com.intellij.util.PathUtil;
import com.intellij.util.SmartList;
import com.intellij.util.descriptors.ConfigFileMetaData;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.ext.jee.JavaeeArtifactProperties;
import org.jetbrains.idea.maven.ext.jee.JavaeeArtifactPropertiesProvider;
import org.jetbrains.idea.maven.importing.FacetImporter;
import org.jetbrains.idea.maven.importing.MavenRootModelAdapter;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenProjectsProcessorTask;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.project.SupportedRequestType;
import org.jetbrains.idea.maven.utils.MavenJDOMUtil;
import org.jetbrains.idea.maven.utils.MavenUtil;

public abstract class JavaeeFacetImporter<FACET_TYPE extends JavaeeFacet, FACET_CONFIG_TYPE extends JavaeeFacetConfiguration, FACET_TYPE_TYPE extends JavaeeFacetType<FACET_TYPE, FACET_CONFIG_TYPE>>
extends FacetImporter<FACET_TYPE, FACET_CONFIG_TYPE, FACET_TYPE_TYPE> {
    protected final String myPackaging;

    protected JavaeeFacetImporter(String pluginGroupID, String pluginArtifactID, String packaging, FACET_TYPE_TYPE facetType) {
        this(pluginGroupID, pluginArtifactID, packaging, facetType, facetType.getDefaultFacetName());
    }

    protected JavaeeFacetImporter(String pluginGroupID, String pluginArtifactID, String packaging, FACET_TYPE_TYPE facetType, String defaultFacetName) {
        super(pluginGroupID, pluginArtifactID, facetType, defaultFacetName);
        this.myPackaging = packaging;
    }

    public boolean isApplicable(MavenProject project) {
        return this.myPackaging.equalsIgnoreCase(project.getPackaging());
    }

    public void getSupportedPackagings(Collection<String> result) {
        result.add(this.myPackaging);
    }

    public void getSupportedDependencyTypes(Collection<String> result, SupportedRequestType type) {
        Collections.addAll(result, "ejb", "ejb-client", "war", "ear", "sar");
    }

    protected void setupFacet(FACET_TYPE f, MavenProject p) {
        this.setupJavaeeFacet(f, p);
    }

    public void preProcess(Module module, MavenProject mavenProject, MavenProjectChanges changes, IdeModifiableModelsProvider modifiableModelsProvider) {
        super.preProcess(module, mavenProject, changes, modifiableModelsProvider);
        this.ensureArtifactExists(mavenProject, modifiableModelsProvider, module, false);
        this.ensureArtifactExists(mavenProject, modifiableModelsProvider, module, true);
    }

    protected String getExplodedPath(MavenProject p) {
        return this.getTargetFilePath(p, "");
    }

    private String doGetExplodedPath(MavenProject p) {
        String archiveFileName;
        String archiveOutputPath;
        String explodedPath = this.getExplodedPath(p);
        boolean filesEqual = FileUtil.filesEqual((File)new File(explodedPath), (File)new File(archiveOutputPath = this.getArchiveOutputPath(p), archiveFileName = this.getTargetFileName(p)));
        return filesEqual ? explodedPath + '.' + this.getTargetExtension(p) : explodedPath;
    }

    protected String getArchiveOutputPath(MavenProject p) {
        return this.makePath(p, new String[]{p.getBuildDirectory()});
    }

    protected abstract void setupJavaeeFacet(FACET_TYPE var1, MavenProject var2);

    @NotNull
    protected static ModifiableArtifact addArtifact(String artifactName, ArtifactType type, ModifiableArtifactModel artifactModel) {
        ModifiableArtifact modifiableArtifact = artifactModel.addArtifact(artifactName, type, type.createRootElement(artifactName), MavenRootModelAdapter.getMavenExternalSource());
        if (modifiableArtifact == null) {
            JavaeeFacetImporter.$$$reportNull$$$0(0);
        }
        return modifiableArtifact;
    }

    protected void reimportFacet(IdeModifiableModelsProvider modelsProvider, Module module, MavenRootModelAdapter rootModel, FACET_TYPE facet, MavenProjectsTree mavenTree, MavenProject mavenProject, MavenProjectChanges changes, Map<MavenProject, String> mavenProjectToModuleName, List<MavenProjectsProcessorTask> postTasks) {
        boolean useMavenOutput = MavenProjectsManager.getInstance((Project)module.getProject()).getImportingSettings().isUseMavenOutput();
        ModifiableArtifact artifact = this.findArtifact(modelsProvider, module, true);
        if (useMavenOutput) {
            this.configureArtifactPaths(mavenProject, artifact, true);
        }
        artifact.setProperties((ArtifactPropertiesProvider)JavaeeArtifactPropertiesProvider.getInstance(), (ArtifactProperties)this.createProperties(module, true, artifact));
        ModifiableArtifact archiveArtifact = this.findArtifact(modelsProvider, module, false);
        if (useMavenOutput) {
            this.configureArtifactPaths(mavenProject, archiveArtifact, false);
        }
        archiveArtifact.getRootElement().removeAllChildren();
        PackagingElement artifactElement = PackagingElementFactory.getInstance().createArtifactElement((Artifact)artifact, module.getProject());
        archiveArtifact.getRootElement().addOrFindChild(artifactElement);
        archiveArtifact.setProperties((ArtifactPropertiesProvider)JavaeeArtifactPropertiesProvider.getInstance(), (ArtifactProperties)this.createProperties(module, false, archiveArtifact));
        this.reimportDependenciesPackaging(facet, artifact, module, rootModel, mavenProject, mavenTree, modelsProvider, mavenProjectToModuleName, postTasks);
        this.reimportSourceRoots(facet, rootModel);
        this.reimportAppServerDescriptors(facet, mavenProject);
    }

    private JavaeeArtifactProperties createProperties(Module module, boolean exploded, ModifiableArtifact artifact) {
        JavaeeArtifactProperties properties = new JavaeeArtifactProperties();
        properties.setPackaging(this.myPackaging);
        properties.setModuleName(module.getName());
        properties.setExploded(exploded);
        JavaeeArtifactProperties existingArtifactProperties = JavaeeFacetImporter.getProperties(artifact);
        if (existingArtifactProperties != null) {
            properties.setUnpackNestedArchives(existingArtifactProperties.getUnpackNestedArchives());
        }
        return properties;
    }

    @Nullable
    protected static JavaeeArtifactProperties getProperties(ModifiableArtifact artifact) {
        ArtifactProperties existingProperties = artifact.getProperties((ArtifactPropertiesProvider)JavaeeArtifactPropertiesProvider.getInstance());
        if (existingProperties instanceof JavaeeArtifactProperties) {
            return (JavaeeArtifactProperties)existingProperties;
        }
        return null;
    }

    protected void reimportAppServerDescriptors(FACET_TYPE facet, MavenProject mavenProject) {
        AppServerDescriptorsMetaDataProvider provider = DescriptorMetaDataRegistry.getInstance().getProvider(((JavaeeFacetType)this.myFacetType).getId());
        for (AppServerIntegration integration : AppServerIntegrationsManager.getInstance().getAllIntegrations()) {
            Collection data = provider.getMetaData(integration);
            for (ConfigFileMetaData metaData : data) {
                String path = this.makePath(mavenProject, new String[]{this.getDescriptorsDirectoryPath(mavenProject), metaData.getDirectoryPath(), metaData.getFileName()});
                this.setDescriptor(facet, metaData, path);
            }
        }
    }

    @NotNull
    protected String getDescriptorsDirectoryPath(MavenProject mavenProject) {
        if ("src/main/resources" == null) {
            JavaeeFacetImporter.$$$reportNull$$$0(1);
        }
        return "src/main/resources";
    }

    private void configureArtifactPaths(MavenProject p, ModifiableArtifact artifact, boolean exploded) {
        if (exploded) {
            artifact.setOutputPath(this.doGetExplodedPath(p));
        } else {
            artifact.setOutputPath(this.getArchiveOutputPath(p));
            CompositePackagingElement root = artifact.getRootElement();
            if (root instanceof ArchivePackagingElement) {
                ((ArchivePackagingElement)root).setArchiveFileName(this.getTargetFileName(p));
            }
        }
    }

    protected ModifiableArtifact findArtifact(IdeModifiableModelsProvider modelsProvider, Module module, boolean exploded) {
        ModifiableArtifactModel artifactModel = modelsProvider.getModifiableArtifactModel();
        return artifactModel.getOrCreateModifiableArtifact(artifactModel.findArtifact(MavenUtil.getArtifactName((String)this.myPackaging, (Module)module, (boolean)exploded)));
    }

    @Nullable
    protected static Artifact findEjbClientArtifactDependency(Module depModule, IdeModifiableModelsProvider modelsProvider) {
        ModifiableArtifactModel artifactModel = modelsProvider.getModifiableArtifactModel();
        for (Artifact artifact : artifactModel.getArtifactsByType(JavaeeArtifactUtil.getInstance().getExplodedEjbArtifactType())) {
            if (!artifact.getName().equals(MavenUtil.getEjbClientArtifactName((Module)depModule, (boolean)true))) continue;
            return artifact;
        }
        return null;
    }

    protected void ensureArtifactExists(MavenProject p, IdeModifiableModelsProvider modelsProvider, Module module, boolean exploded) {
        String artifactName = MavenUtil.getArtifactName((String)this.myPackaging, (Module)module, (boolean)exploded);
        ModifiableArtifactModel artifactModel = modelsProvider.getModifiableArtifactModel();
        Artifact artifact = artifactModel.findArtifact(artifactName);
        ArtifactType artifactType = this.getArtifactType(exploded);
        if (artifact == null || !artifact.getArtifactType().equals(artifactType)) {
            if (artifact != null) {
                artifactModel.removeArtifact(artifact);
            }
            ModifiableArtifact res = JavaeeFacetImporter.addArtifact(artifactName, artifactType, artifactModel);
            this.configureArtifactPaths(p, res, exploded);
        }
    }

    protected abstract ArtifactType getArtifactType(boolean var1);

    private void reimportDependenciesPackaging(FACET_TYPE facet, ModifiableArtifact artifact, Module module, MavenRootModelAdapter rootModel, MavenProject mavenProject, MavenProjectsTree mavenTree, IdeModifiableModelsProvider modelsProvider, Map<MavenProject, String> mavenProjectToModuleName, List<MavenProjectsProcessorTask> postTasks) {
        this.prepareRootElement(facet, artifact.getRootElement(), mavenProject);
        for (MavenArtifact mavenArtifact : this.getOrderedDependenciesToPackage(mavenProject)) {
            Library library;
            String jarFileName;
            if (!mavenArtifact.isExportable()) continue;
            MavenProject p = mavenTree.findProject(mavenArtifact.getMavenId());
            if (p != null) {
                jarFileName = this.getJarFileNameForModule(mavenProject, mavenArtifact, p);
                Module depModule = modelsProvider.getModifiableModuleModel().findModuleByName(mavenProjectToModuleName.get(p));
                if (depModule == null || this.addFacetDependency(modelsProvider, mavenProject, facet, artifact, depModule, mavenArtifact, jarFileName)) continue;
                this.addModuleDependency(modelsProvider, mavenProject, artifact, depModule, mavenArtifact, jarFileName);
                continue;
            }
            jarFileName = this.getJarFileNameForLibrary(mavenProject, facet, mavenArtifact);
            if (this.reimportCustomDependencyPackaging(mavenProject, facet, mavenArtifact, postTasks) || (library = rootModel.findLibrary(mavenArtifact)) == null) continue;
            this.addLibraryDependency(modelsProvider, module.getProject(), mavenProject, (JavaeeFacet)facet, artifact, library, mavenArtifact, jarFileName);
        }
    }

    @NotNull
    protected String getJarFileNameForModule(MavenProject mavenProject, MavenArtifact depArtifact, MavenProject depProject) {
        String string = depProject.getFinalName() + (StringUtil.isEmpty((String)depArtifact.getClassifier()) ? "" : "-" + depArtifact.getClassifier()) + "." + depArtifact.getExtension();
        if (string == null) {
            JavaeeFacetImporter.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    protected String getJarFileNameForLibrary(MavenProject mavenProject, FACET_TYPE facet, MavenArtifact mavenArtifact) {
        if (Comparing.equal((String)mavenArtifact.getVersion(), (String)mavenArtifact.getBaseVersion())) {
            String string = mavenArtifact.getFile().getName();
            if (string == null) {
                JavaeeFacetImporter.$$$reportNull$$$0(3);
            }
            return string;
        }
        String string = mavenArtifact.getFileNameWithBaseVersion(null, null);
        if (string == null) {
            JavaeeFacetImporter.$$$reportNull$$$0(4);
        }
        return string;
    }

    protected void prepareRootElement(FACET_TYPE facet, CompositePackagingElement<?> rootElement, MavenProject mavenProject) {
        rootElement.removeAllChildren();
        rootElement.addOrFindChild(JavaeeArtifactUtil.getInstance().createFacetResourcesElement(facet));
        this.prepareArtifactManifest(rootElement, mavenProject);
    }

    protected void prepareArtifactManifest(CompositePackagingElement<?> rootElement, MavenProject mavenProject) {
        String manifestPath = FileUtil.toSystemIndependentName((String)(this.doGetExplodedPath(mavenProject) + "/" + "META-INF/MANIFEST.MF"));
        rootElement.addOrFindChild(PackagingElementFactory.getInstance().createFileCopyWithParentDirectories(manifestPath, ManifestFileUtil.MANIFEST_DIR_NAME));
    }

    protected List<MavenArtifact> getOrderedDependenciesToPackage(MavenProject mavenProject) {
        return mavenProject.getDependencies();
    }

    protected boolean reimportCustomDependencyPackaging(MavenProject mavenProject, FACET_TYPE facet, MavenArtifact depArtifact, List<MavenProjectsProcessorTask> postTasks) {
        return false;
    }

    protected boolean addFacetDependency(IdeModifiableModelsProvider modelsProvider, MavenProject mavenProject, FACET_TYPE facet, ModifiableArtifact artifact, Module depModule, MavenArtifact depArtifact, @NotNull String jarFileName) {
        if (jarFileName == null) {
            JavaeeFacetImporter.$$$reportNull$$$0(5);
        }
        return false;
    }

    @Nullable
    protected JavaeeFacet findFacetDependency(Module module, IdeModifiableModelsProvider modifiableModelsProvider, JavaeeFacetType ... types) {
        ModifiableFacetModel facetModel = modifiableModelsProvider.getModifiableFacetModel(module);
        for (JavaeeFacetType each : types) {
            JavaeeFacet f = (JavaeeFacet)facetModel.getFacetByType(each.getId());
            if (f == null) continue;
            return f;
        }
        return null;
    }

    protected void addModuleDependency(IdeModifiableModelsProvider modelsProvider, MavenProject mavenProject, ModifiableArtifact artifact, Module depModule, MavenArtifact depArtifact, @NotNull String jarFileName) {
        if (jarFileName == null) {
            JavaeeFacetImporter.$$$reportNull$$$0(6);
        }
        this.doAddModuleDependency(modelsProvider, mavenProject, artifact, depModule, depArtifact, jarFileName, this.buildCopyPackagingUrl(mavenProject));
    }

    protected void doAddModuleDependency(IdeModifiableModelsProvider modelsProvider, MavenProject mavenProject, ModifiableArtifact artifact, Module depModule, MavenArtifact depArtifact, String jarFileName, String relativeOutputPath) {
        PackagingElementFactory factory = PackagingElementFactory.getInstance();
        JavaeeArtifactProperties artifactProperties = JavaeeFacetImporter.getProperties(artifact);
        boolean unpackModuleJars = artifactProperties != null && artifactProperties.getUnpackNestedArchives();
        CompositePackagingElement packagingElement = unpackModuleJars ? factory.createDirectory(jarFileName) : factory.createArchive(jarFileName);
        PackagingElement moduleOutput = depArtifact != null && "tests".equals(depArtifact.getClassifier()) ? factory.createTestModuleOutput(depModule) : factory.createModuleOutput(depModule);
        packagingElement.addOrFindChild(moduleOutput);
        this.addPackagingElements(modelsProvider, mavenProject, artifact, relativeOutputPath, Collections.singletonList(packagingElement));
    }

    private void addPackagingElements(IdeModifiableModelsProvider modelsProvider, MavenProject mavenProject, ModifiableArtifact artifact, String relativeOutputPath, List<? extends PackagingElement<?>> elements) {
        PackagingElementFactory factory = PackagingElementFactory.getInstance();
        if (this.isLinkViaManifest(mavenProject)) {
            String classpathPrefix = this.getManifestClasspathPrefix(mavenProject);
            ArrayList<PackagingElement> copiedElements = new ArrayList<PackagingElement>();
            for (PackagingElement<?> element : elements) {
                copiedElements.add(ArtifactUtil.copyWithChildren(element, (Project)modelsProvider.getPackagingElementResolvingContext().getProject()));
            }
            List classpathElements = factory.createParentDirectories(StringUtil.notNullize((String)classpathPrefix, (String)relativeOutputPath), copiedElements);
            ArtifactExternalDependenciesImporter importer = modelsProvider.getArtifactExternalDependenciesImporter();
            List classpath = ManifestFileUtil.getClasspathForElements((List)classpathElements, (PackagingElementResolvingContext)modelsProvider.getPackagingElementResolvingContext(), (ArtifactType)artifact.getArtifactType());
            ManifestFileConfiguration manifestFile = importer.getManifestFile((Artifact)artifact, modelsProvider.getPackagingElementResolvingContext());
            if (manifestFile != null) {
                manifestFile.addToClasspath(classpath);
            }
        }
        if (this.shouldIncludeInArtifact(mavenProject)) {
            artifact.getRootElement().addOrFindChildren((Collection)factory.createParentDirectories(relativeOutputPath, elements));
        }
    }

    protected void addLibraryDependency(IdeModifiableModelsProvider modelsProvider, Project project, MavenProject mavenProject, JavaeeFacet facet, ModifiableArtifact artifact, Library depLibrary, MavenArtifact depArtifact, @NotNull String jarFileName) {
        if (jarFileName == null) {
            JavaeeFacetImporter.$$$reportNull$$$0(7);
        }
        this.doAddLibraryDependency(modelsProvider, mavenProject, artifact, depLibrary, this.buildCopyPackagingUrl(mavenProject), jarFileName);
    }

    protected void doAddLibraryDependency(IdeModifiableModelsProvider modelsProvider, MavenProject mavenProject, ModifiableArtifact artifact, Library depLibrary, String relativeOutputPath, String jarFileName) {
        this.addPackagingElements(modelsProvider, mavenProject, artifact, relativeOutputPath, JavaeeFacetImporter.createLibraryElements(depLibrary, jarFileName, modelsProvider));
    }

    private static List<? extends PackagingElement<?>> createLibraryElements(Library depLibrary, String jarFileName, IdeModifiableModelsProvider modelsProvider) {
        String filePath;
        String fileName;
        String[] urls = modelsProvider.getLibraryUrls(depLibrary, OrderRootType.CLASSES);
        if (urls.length == 1 && !(fileName = PathUtil.getFileName((String)(filePath = FileUtil.toSystemIndependentName((String)PathUtil.getLocalPath((String)VfsUtil.urlToPath((String)urls[0])))))).equals(jarFileName)) {
            return Collections.singletonList(PackagingElementFactory.getInstance().createFileCopy(filePath, jarFileName));
        }
        return PackagingElementFactory.getInstance().createLibraryElements(depLibrary);
    }

    protected void reimportSourceRoots(FACET_TYPE facet, MavenRootModelAdapter rootModel) {
        this.setSourceRoots(facet, rootModel.getSourceRootUrls(false));
    }

    protected void setSourceRoots(FACET_TYPE f, String[] urls) {
    }

    protected void setDescriptor(FACET_TYPE facet, ConfigFileMetaData metaData, String path) {
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(path);
        if (file == null) {
            return;
        }
        this.setDescriptorUrl(facet, metaData, file.getUrl());
    }

    protected void setDescriptorUrl(FACET_TYPE facet, ConfigFileMetaData metaData, String url) {
        facet.getDescriptorsContainer().getConfiguration().replaceConfigFile(metaData, url);
    }

    private String buildCopyPackagingUrl(MavenProject project) {
        String url = this.getDependencyPackagingUrl(project);
        if (!StringUtil.startsWithChar((CharSequence)url, (char)'/')) {
            url = "/" + url;
        }
        if (!StringUtil.endsWithChar((CharSequence)url, (char)'/')) {
            url = url + "/";
        }
        return url;
    }

    protected boolean isLinkViaManifest(MavenProject project) {
        return false;
    }

    @Nullable
    public String getManifestClasspathPrefix(MavenProject project) {
        return null;
    }

    protected boolean shouldIncludeInArtifact(MavenProject project) {
        return true;
    }

    protected String getDependencyPackagingUrl(MavenProject project) {
        return ((JavaeeFacetType)this.myFacetType).getDefaultUriForJar();
    }

    @Nullable
    protected Element findConfigElementForArtifact(MavenArtifact artifact, MavenProject project, String path, String childPath) {
        ArtifactConfig config = this.findConfigElementForArtifact(artifact, this.getArtifactConfigs(project, path, childPath));
        return config == null ? null : config.config;
    }

    @Nullable
    protected ArtifactConfig findConfigElementForArtifact(MavenArtifact artifact, List<ArtifactConfig> configs) {
        for (String each : new String[]{artifact.getClassifier(), null}) {
            for (ArtifactConfig eachConfig : configs) {
                if (!eachConfig.groupId.equals(artifact.getGroupId()) || !eachConfig.artifactId.equals(artifact.getArtifactId()) || !Comparing.equal((String)each, (String)artifact.getClassifier())) continue;
                return eachConfig;
            }
        }
        return null;
    }

    protected List<ArtifactConfig> getArtifactConfigs(MavenProject project, String path, String childPath) {
        Element element = this.getConfig(project);
        if (element == null) {
            return Collections.emptyList();
        }
        SmartList result = new SmartList();
        for (Element each : MavenJDOMUtil.findChildrenByPath((Element)element, (String)path, (String)childPath)) {
            String groupId = MavenJDOMUtil.findChildValueByPath((Element)each, (String)"groupId");
            String artifactId = MavenJDOMUtil.findChildValueByPath((Element)each, (String)"artifactId");
            String classifier = MavenJDOMUtil.findChildValueByPath((Element)each, (String)"classifier");
            if (groupId == null || artifactId == null) continue;
            result.add(new ArtifactConfig(groupId, artifactId, classifier, each));
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/ext/jee/JavaeeFacetImporter";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jarFileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "addArtifact";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptorsDirectoryPath";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getJarFileNameForModule";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getJarFileNameForLibrary";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/ext/jee/JavaeeFacetImporter";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addFacetDependency";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addModuleDependency";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addLibraryDependency";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static class ArtifactConfig {
        @NotNull
        public final String groupId;
        @NotNull
        public final String artifactId;
        @Nullable
        public final String classifier;
        @NotNull
        public final Element config;

        public ArtifactConfig(@NotNull String groupId, @NotNull String artifactId, String classifier, Element config) {
            if (groupId == null) {
                ArtifactConfig.$$$reportNull$$$0(0);
            }
            if (artifactId == null) {
                ArtifactConfig.$$$reportNull$$$0(1);
            }
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.classifier = classifier;
            this.config = config;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "groupId";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "artifactId";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/idea/maven/ext/jee/JavaeeFacetImporter$ArtifactConfig";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

