/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.ext.jee;

import com.intellij.execution.configurations.ParametersList;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectModelBuildableElement;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactProperties;
import com.intellij.packaging.artifacts.ArtifactPropertiesProvider;
import com.intellij.task.ProjectModelBuildTask;
import com.intellij.task.ProjectTaskNotification;
import java.io.File;
import java.util.Collections;
import org.jetbrains.idea.maven.execution.MavenRunner;
import org.jetbrains.idea.maven.execution.MavenRunnerParameters;
import org.jetbrains.idea.maven.execution.build.MavenArtifactBuilder;
import org.jetbrains.idea.maven.execution.build.MavenProjectTaskRunner;
import org.jetbrains.idea.maven.ext.jee.JavaeeArtifactProperties;
import org.jetbrains.idea.maven.ext.jee.JavaeeArtifactPropertiesProvider;
import org.jetbrains.idea.maven.model.MavenExplicitProfiles;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;

public class JavaeeArtifactBuilder
implements MavenArtifactBuilder {
    public boolean isApplicable(ProjectModelBuildTask task) {
        ProjectModelBuildableElement buildableElement = task.getBuildableElement();
        if (!(buildableElement instanceof Artifact)) {
            return false;
        }
        Artifact artifact = (Artifact)buildableElement;
        ArtifactProperties properties = artifact.getProperties((ArtifactPropertiesProvider)JavaeeArtifactPropertiesProvider.getInstance());
        if (properties == null || !(properties.getState() instanceof JavaeeArtifactProperties)) {
            return false;
        }
        return ((JavaeeArtifactProperties)((Object)properties.getState())).getModuleName() != null;
    }

    public void build(Project project, ProjectModelBuildTask task, ProjectTaskNotification callback) {
        String outputFilePath;
        boolean clean;
        Artifact artifact = (Artifact)task.getBuildableElement();
        ArtifactProperties artifactProperties = artifact.getProperties((ArtifactPropertiesProvider)JavaeeArtifactPropertiesProvider.getInstance());
        JavaeeArtifactProperties properties = (JavaeeArtifactProperties)((Object)artifactProperties.getState());
        Module module = ModuleManager.getInstance((Project)project).findModuleByName(properties.getModuleName());
        if (module == null) {
            return;
        }
        MavenProjectsManager mavenProjectsManager = MavenProjectsManager.getInstance((Project)project);
        MavenProject mavenProject = mavenProjectsManager.findProject(module);
        if (mavenProject == null) {
            return;
        }
        boolean bl = clean = !task.isIncrementalBuild();
        if (clean && (outputFilePath = artifact.getOutputFilePath()) != null) {
            FileUtil.delete((File)new File(FileUtil.toSystemDependentName((String)outputFilePath)));
        }
        MavenRunner mavenRunner = MavenRunner.getInstance((Project)project);
        ParametersList parameters = new ParametersList();
        parameters.add("compile");
        parameters.add(JavaeeArtifactBuilder.getClCommand(properties));
        VirtualFile pomFile = mavenProject.getFile();
        MavenExplicitProfiles explicitProfiles = mavenProjectsManager.getExplicitProfiles();
        MavenRunnerParameters command = new MavenRunnerParameters(true, pomFile.getParent().getPath(), pomFile.getName(), parameters.getList(), explicitProfiles.getEnabledProfiles(), explicitProfiles.getDisabledProfiles());
        MavenProjectTaskRunner.runBatch((Project)project, (MavenRunner)mavenRunner, (String)"Maven Artifact Build", Collections.singletonList(command), (ProjectTaskNotification)callback);
    }

    private static String getClCommand(JavaeeArtifactProperties properties) {
        switch (properties.getPackaging()) {
            case "war": {
                return properties.getExploded() ? "war:exploded" : "war:war";
            }
            case "ear": {
                return "ear:ear";
            }
            case "ejb": {
                return "ejb:ejb";
            }
        }
        return "package";
    }
}

