/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ognl.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ognl.OgnlTypes;
import com.intellij.lang.ognl.psi.OgnlBinaryExpression;
import com.intellij.lang.ognl.psi.OgnlConditionalExpression;
import com.intellij.lang.ognl.psi.OgnlExpression;
import com.intellij.lang.ognl.psi.OgnlFqnTypeExpression;
import com.intellij.lang.ognl.psi.OgnlLiteralExpression;
import com.intellij.lang.ognl.psi.OgnlMapExpression;
import com.intellij.lang.ognl.psi.OgnlNewArrayExpression;
import com.intellij.lang.ognl.psi.OgnlNewExpression;
import com.intellij.lang.ognl.psi.OgnlParameterList;
import com.intellij.lang.ognl.psi.OgnlParenthesizedExpression;
import com.intellij.lang.ognl.psi.OgnlTokenGroups;
import com.intellij.lang.ognl.psi.OgnlTokenType;
import com.intellij.lang.ognl.psi.OgnlUnaryExpression;
import com.intellij.lang.ognl.psi.OgnlVariableAssignmentExpression;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceProvider;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class OgnlPsiUtil {
    OgnlPsiUtil() {
    }

    @NotNull
    static OgnlTokenType getOperator(OgnlBinaryExpression expression) {
        ASTNode node = expression.getNode().findChildByType(OgnlTokenGroups.OPERATIONS);
        assert (node != null) : "unknown operation sign: '" + expression.getText() + "'";
        OgnlTokenType ognlTokenType = (OgnlTokenType)node.getElementType();
        if (ognlTokenType == null) {
            OgnlPsiUtil.$$$reportNull$$$0(0);
        }
        return ognlTokenType;
    }

    @NotNull
    static OgnlTokenType getUnaryOperator(OgnlUnaryExpression expression) {
        ASTNode node = expression.getNode().findChildByType(OgnlTokenGroups.UNARY_OPS);
        assert (node != null) : "unknown unary operation sign: '" + expression.getText() + "'";
        OgnlTokenType ognlTokenType = (OgnlTokenType)node.getElementType();
        if (ognlTokenType == null) {
            OgnlPsiUtil.$$$reportNull$$$0(1);
        }
        return ognlTokenType;
    }

    @NotNull
    static String getVariableName(OgnlVariableAssignmentExpression expression) {
        ASTNode nameNode = expression.getNode().findChildByType(OgnlTypes.IDENTIFIER);
        assert (nameNode != null);
        String string = nameNode.getText();
        if (string == null) {
            OgnlPsiUtil.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    static PsiType getType(@Nullable OgnlExpression expression) {
        if (expression == null) {
            return null;
        }
        if (expression instanceof OgnlLiteralExpression) {
            return OgnlPsiUtil.resolveLiteralExpressionType((OgnlLiteralExpression)expression);
        }
        if (expression instanceof OgnlConditionalExpression) {
            OgnlExpression thenExpression = ((OgnlConditionalExpression)expression).getThen();
            return OgnlPsiUtil.getType(thenExpression);
        }
        if (expression instanceof OgnlBinaryExpression) {
            OgnlExpression leftExpression = ((OgnlBinaryExpression)expression).getLeft();
            return OgnlPsiUtil.getType(leftExpression);
        }
        if (expression instanceof OgnlVariableAssignmentExpression) {
            OgnlExpression assignment = ((OgnlVariableAssignmentExpression)expression).getAssignment();
            return OgnlPsiUtil.getType(assignment);
        }
        if (expression instanceof OgnlParenthesizedExpression) {
            OgnlExpression argument = ((OgnlParenthesizedExpression)expression).getExpression();
            return OgnlPsiUtil.getType(argument);
        }
        return null;
    }

    private static PsiType resolveLiteralExpressionType(OgnlLiteralExpression expression) {
        ASTNode node = expression.getNode();
        IElementType type = node.getFirstChildNode().getElementType();
        if (type == OgnlTypes.STRING_LITERAL) {
            return PsiType.getJavaLangString((PsiManager)expression.getManager(), (GlobalSearchScope)expression.getResolveScope());
        }
        if (type == OgnlTypes.CHARACTER_LITERAL) {
            return PsiType.CHAR;
        }
        if (type == OgnlTypes.INTEGER_LITERAL) {
            return PsiType.INT;
        }
        if (type == OgnlTypes.BIG_INTEGER_LITERAL) {
            return JavaPsiFacade.getInstance((Project)expression.getProject()).getElementFactory().createTypeByFQClassName("java.math.BigInteger", expression.getResolveScope());
        }
        if (type == OgnlTypes.DOUBLE_LITERAL) {
            return PsiType.DOUBLE;
        }
        if (type == OgnlTypes.BIG_DECIMAL_LITERAL) {
            return JavaPsiFacade.getInstance((Project)expression.getProject()).getElementFactory().createTypeByFQClassName("java.math.BigDecimal", expression.getResolveScope());
        }
        if (type == OgnlTypes.TRUE_KEYWORD || type == OgnlTypes.FALSE_KEYWORD) {
            return PsiType.BOOLEAN;
        }
        if (type == OgnlTypes.NULL_KEYWORD) {
            return PsiType.NULL;
        }
        throw new IllegalArgumentException("could not resolve type for literal " + type + " / " + expression.getText());
    }

    @Nullable
    static Object getConstantValue(OgnlLiteralExpression expression) {
        ASTNode node = expression.getNode();
        IElementType type = node.getFirstChildNode().getElementType();
        String text = expression.getText();
        if (type == OgnlTypes.STRING_LITERAL) {
            return StringUtil.unquoteString((String)text);
        }
        if (type == OgnlTypes.CHARACTER_LITERAL) {
            return StringUtil.unquoteString((String)text);
        }
        if (type == OgnlTypes.INTEGER_LITERAL) {
            return Integer.parseInt(text);
        }
        if (type == OgnlTypes.BIG_INTEGER_LITERAL) {
            return new BigInteger(text.substring(0, expression.getTextLength() - 1));
        }
        if (type == OgnlTypes.DOUBLE_LITERAL) {
            return Double.parseDouble(text);
        }
        if (type == OgnlTypes.BIG_DECIMAL_LITERAL) {
            return new BigDecimal(text.substring(0, expression.getTextLength() - 1));
        }
        if (type == OgnlTypes.TRUE_KEYWORD || type == OgnlTypes.FALSE_KEYWORD) {
            return Boolean.valueOf(text);
        }
        if (type == OgnlTypes.NULL_KEYWORD) {
            return null;
        }
        throw new IllegalArgumentException("could not resolve constant value for literal " + type + " / " + text);
    }

    static int getParameterCount(OgnlParameterList parameterList) {
        return parameterList.getParametersList().size();
    }

    static void customizeFqnTypeExpressionReferences(OgnlFqnTypeExpression fqnTypeExpression, JavaClassReferenceProvider referenceProvider) {
        PsiElement parent = fqnTypeExpression.getParent();
        if (parent instanceof OgnlNewExpression || parent instanceof OgnlNewArrayExpression) {
            referenceProvider.setOption(JavaClassReferenceProvider.CONCRETE, (Object)Boolean.TRUE);
            referenceProvider.setOption(JavaClassReferenceProvider.NOT_INTERFACE, (Object)Boolean.TRUE);
            referenceProvider.setOption(JavaClassReferenceProvider.NOT_ENUM, (Object)Boolean.TRUE);
            return;
        }
        if (parent instanceof OgnlMapExpression) {
            referenceProvider.setOption(JavaClassReferenceProvider.CONCRETE, (Object)Boolean.TRUE);
            referenceProvider.setOption(JavaClassReferenceProvider.INSTANTIATABLE, (Object)Boolean.TRUE);
            referenceProvider.setOption(JavaClassReferenceProvider.SUPER_CLASSES, Collections.singletonList("java.util.Map"));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/lang/ognl/psi/impl/OgnlPsiUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOperator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnaryOperator";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariableName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

