/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ognl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ognl.psi.OgnlTokenType;
import com.intellij.lang.ognl.psi.impl.OgnlBinaryExpressionImpl;
import com.intellij.lang.ognl.psi.impl.OgnlConditionalExpressionImpl;
import com.intellij.lang.ognl.psi.impl.OgnlFqnTypeExpressionImpl;
import com.intellij.lang.ognl.psi.impl.OgnlIndexedExpressionImpl;
import com.intellij.lang.ognl.psi.impl.OgnlLambdaExpressionImpl;
import com.intellij.lang.ognl.psi.impl.OgnlLiteralExpressionImpl;
import com.intellij.lang.ognl.psi.impl.OgnlMapEntryElementImpl;
import com.intellij.lang.ognl.psi.impl.OgnlMapExpressionImpl;
import com.intellij.lang.ognl.psi.impl.OgnlMethodCallExpressionImpl;
import com.intellij.lang.ognl.psi.impl.OgnlNewArrayExpressionImpl;
import com.intellij.lang.ognl.psi.impl.OgnlNewExpressionImpl;
import com.intellij.lang.ognl.psi.impl.OgnlParameterListImpl;
import com.intellij.lang.ognl.psi.impl.OgnlParenthesizedExpressionImpl;
import com.intellij.lang.ognl.psi.impl.OgnlProjectionExpressionImpl;
import com.intellij.lang.ognl.psi.impl.OgnlReferenceExpressionImpl;
import com.intellij.lang.ognl.psi.impl.OgnlSelectionExpressionImpl;
import com.intellij.lang.ognl.psi.impl.OgnlSequenceExpressionImpl;
import com.intellij.lang.ognl.psi.impl.OgnlUnaryExpressionImpl;
import com.intellij.lang.ognl.psi.impl.OgnlVariableAssignmentExpressionImpl;
import com.intellij.lang.ognl.psi.impl.OgnlVariableExpressionImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;

public interface OgnlTypes {
    public static final IElementType BINARY_EXPRESSION = new OgnlTokenType("BINARY_EXPRESSION");
    public static final IElementType CONDITIONAL_EXPRESSION = new OgnlTokenType("CONDITIONAL_EXPRESSION");
    public static final IElementType EXPRESSION = new OgnlTokenType("EXPRESSION");
    public static final IElementType FQN_TYPE_EXPRESSION = new OgnlTokenType("FQN_TYPE_EXPRESSION");
    public static final IElementType INDEXED_EXPRESSION = new OgnlTokenType("INDEXED_EXPRESSION");
    public static final IElementType LAMBDA_EXPRESSION = new OgnlTokenType("LAMBDA_EXPRESSION");
    public static final IElementType LITERAL_EXPRESSION = new OgnlTokenType("LITERAL_EXPRESSION");
    public static final IElementType MAP_ENTRY_ELEMENT = new OgnlTokenType("MAP_ENTRY_ELEMENT");
    public static final IElementType MAP_EXPRESSION = new OgnlTokenType("MAP_EXPRESSION");
    public static final IElementType METHOD_CALL_EXPRESSION = new OgnlTokenType("METHOD_CALL_EXPRESSION");
    public static final IElementType NEW_ARRAY_EXPRESSION = new OgnlTokenType("NEW_ARRAY_EXPRESSION");
    public static final IElementType NEW_EXPRESSION = new OgnlTokenType("NEW_EXPRESSION");
    public static final IElementType PARAMETER_LIST = new OgnlTokenType("PARAMETER_LIST");
    public static final IElementType PARENTHESIZED_EXPRESSION = new OgnlTokenType("PARENTHESIZED_EXPRESSION");
    public static final IElementType PROJECTION_EXPRESSION = new OgnlTokenType("PROJECTION_EXPRESSION");
    public static final IElementType REFERENCE_EXPRESSION = new OgnlTokenType("REFERENCE_EXPRESSION");
    public static final IElementType SELECTION_EXPRESSION = new OgnlTokenType("SELECTION_EXPRESSION");
    public static final IElementType SEQUENCE_EXPRESSION = new OgnlTokenType("SEQUENCE_EXPRESSION");
    public static final IElementType UNARY_EXPRESSION = new OgnlTokenType("UNARY_EXPRESSION");
    public static final IElementType VARIABLE_ASSIGNMENT_EXPRESSION = new OgnlTokenType("VARIABLE_ASSIGNMENT_EXPRESSION");
    public static final IElementType VARIABLE_EXPRESSION = new OgnlTokenType("VARIABLE_EXPRESSION");
    public static final IElementType AND = new OgnlTokenType("&");
    public static final IElementType AND_AND = new OgnlTokenType("&&");
    public static final IElementType AND_KEYWORD = new OgnlTokenType("and");
    public static final IElementType AT = new OgnlTokenType("@");
    public static final IElementType BAND_KEYWORD = new OgnlTokenType("band");
    public static final IElementType BIG_DECIMAL_LITERAL = new OgnlTokenType("BIG_DECIMAL_LITERAL");
    public static final IElementType BIG_INTEGER_LITERAL = new OgnlTokenType("BIG_INTEGER_LITERAL");
    public static final IElementType BOR_KEYWORD = new OgnlTokenType("bor");
    public static final IElementType CHARACTER_LITERAL = new OgnlTokenType("CHARACTER_LITERAL");
    public static final IElementType COLON = new OgnlTokenType(":");
    public static final IElementType COMMA = new OgnlTokenType(",");
    public static final IElementType DIVISION = new OgnlTokenType("/");
    public static final IElementType DOLLAR = new OgnlTokenType("$");
    public static final IElementType DOT = new OgnlTokenType(".");
    public static final IElementType DOUBLE_LITERAL = new OgnlTokenType("DOUBLE_LITERAL");
    public static final IElementType EQ = new OgnlTokenType("=");
    public static final IElementType EQUAL = new OgnlTokenType("==");
    public static final IElementType EQ_KEYWORD = new OgnlTokenType("eq");
    public static final IElementType EXPRESSION_END = new OgnlTokenType("EXPRESSION_END");
    public static final IElementType EXPRESSION_START = new OgnlTokenType("%{");
    public static final IElementType FALSE_KEYWORD = new OgnlTokenType("false");
    public static final IElementType GREATER = new OgnlTokenType(">");
    public static final IElementType GREATER_EQUAL = new OgnlTokenType(">=");
    public static final IElementType GT_EQ_KEYWORD = new OgnlTokenType("gte");
    public static final IElementType GT_KEYWORD = new OgnlTokenType("gt");
    public static final IElementType HASH = new OgnlTokenType("#");
    public static final IElementType IDENTIFIER = new OgnlTokenType("IDENTIFIER");
    public static final IElementType INSTANCEOF_KEYWORD = new OgnlTokenType("instanceof");
    public static final IElementType INTEGER_LITERAL = new OgnlTokenType("INTEGER_LITERAL");
    public static final IElementType IN_KEYWORD = new OgnlTokenType("in");
    public static final IElementType LBRACE = new OgnlTokenType("{");
    public static final IElementType LBRACKET = new OgnlTokenType("[");
    public static final IElementType LESS = new OgnlTokenType("<");
    public static final IElementType LESS_EQUAL = new OgnlTokenType("<=");
    public static final IElementType LPARENTH = new OgnlTokenType("(");
    public static final IElementType LT_EQ_KEYWORD = new OgnlTokenType("lte");
    public static final IElementType LT_KEYWORD = new OgnlTokenType("lt");
    public static final IElementType MINUS = new OgnlTokenType("-");
    public static final IElementType MODULO = new OgnlTokenType("%");
    public static final IElementType MULTIPLY = new OgnlTokenType("*");
    public static final IElementType NEGATE = new OgnlTokenType("!");
    public static final IElementType NEQ_KEYWORD = new OgnlTokenType("neq");
    public static final IElementType NEW_KEYWORD = new OgnlTokenType("new");
    public static final IElementType NOT = new OgnlTokenType("~");
    public static final IElementType NOT_EQUAL = new OgnlTokenType("!=");
    public static final IElementType NOT_IN_KEYWORD = new OgnlTokenType("not in");
    public static final IElementType NOT_KEYWORD = new OgnlTokenType("not");
    public static final IElementType NULL_KEYWORD = new OgnlTokenType("null");
    public static final IElementType OR = new OgnlTokenType("|");
    public static final IElementType OR_KEYWORD = new OgnlTokenType("or");
    public static final IElementType OR_OR = new OgnlTokenType("||");
    public static final IElementType PLUS = new OgnlTokenType("+");
    public static final IElementType QUESTION = new OgnlTokenType("?");
    public static final IElementType RBRACE = new OgnlTokenType("}");
    public static final IElementType RBRACKET = new OgnlTokenType("]");
    public static final IElementType RPARENTH = new OgnlTokenType(")");
    public static final IElementType SHIFT_LEFT = new OgnlTokenType("<<");
    public static final IElementType SHIFT_LEFT_KEYWORD = new OgnlTokenType("shl");
    public static final IElementType SHIFT_RIGHT = new OgnlTokenType(">>");
    public static final IElementType SHIFT_RIGHT_KEYWORD = new OgnlTokenType("shr");
    public static final IElementType SHIFT_RIGHT_LOGICAL = new OgnlTokenType(">>>");
    public static final IElementType SHIFT_RIGHT_LOGICAL_KEYWORD = new OgnlTokenType("ushr");
    public static final IElementType STRING_LITERAL = new OgnlTokenType("STRING_LITERAL");
    public static final IElementType TRUE_KEYWORD = new OgnlTokenType("true");
    public static final IElementType XOR = new OgnlTokenType("^");
    public static final IElementType XOR_KEYWORD = new OgnlTokenType("xor");

    public static class Factory {
        public static PsiElement createElement(ASTNode node) {
            IElementType type = node.getElementType();
            if (type == BINARY_EXPRESSION) {
                return new OgnlBinaryExpressionImpl(node);
            }
            if (type == CONDITIONAL_EXPRESSION) {
                return new OgnlConditionalExpressionImpl(node);
            }
            if (type == FQN_TYPE_EXPRESSION) {
                return new OgnlFqnTypeExpressionImpl(node);
            }
            if (type == INDEXED_EXPRESSION) {
                return new OgnlIndexedExpressionImpl(node);
            }
            if (type == LAMBDA_EXPRESSION) {
                return new OgnlLambdaExpressionImpl(node);
            }
            if (type == LITERAL_EXPRESSION) {
                return new OgnlLiteralExpressionImpl(node);
            }
            if (type == MAP_ENTRY_ELEMENT) {
                return new OgnlMapEntryElementImpl(node);
            }
            if (type == MAP_EXPRESSION) {
                return new OgnlMapExpressionImpl(node);
            }
            if (type == METHOD_CALL_EXPRESSION) {
                return new OgnlMethodCallExpressionImpl(node);
            }
            if (type == NEW_ARRAY_EXPRESSION) {
                return new OgnlNewArrayExpressionImpl(node);
            }
            if (type == NEW_EXPRESSION) {
                return new OgnlNewExpressionImpl(node);
            }
            if (type == PARAMETER_LIST) {
                return new OgnlParameterListImpl(node);
            }
            if (type == PARENTHESIZED_EXPRESSION) {
                return new OgnlParenthesizedExpressionImpl(node);
            }
            if (type == PROJECTION_EXPRESSION) {
                return new OgnlProjectionExpressionImpl(node);
            }
            if (type == REFERENCE_EXPRESSION) {
                return new OgnlReferenceExpressionImpl(node);
            }
            if (type == SELECTION_EXPRESSION) {
                return new OgnlSelectionExpressionImpl(node);
            }
            if (type == SEQUENCE_EXPRESSION) {
                return new OgnlSequenceExpressionImpl(node);
            }
            if (type == UNARY_EXPRESSION) {
                return new OgnlUnaryExpressionImpl(node);
            }
            if (type == VARIABLE_ASSIGNMENT_EXPRESSION) {
                return new OgnlVariableAssignmentExpressionImpl(node);
            }
            if (type == VARIABLE_EXPRESSION) {
                return new OgnlVariableExpressionImpl(node);
            }
            throw new AssertionError((Object)("Unknown element type: " + type));
        }
    }
}

