/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.data.commons.view;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.spring.data.commons.view.SpringRepositoriesViewSettings;
import com.intellij.spring.data.commons.view.panels.SpringRepositoriesModulesPanel;
import com.intellij.spring.data.commons.view.panels.SpringRepositoriesPanel;
import com.intellij.spring.data.utils.model.RepositoriesSearchUtil;
import com.intellij.spring.model.BeanService;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.toolWindow.SpringBaseView;
import com.intellij.ui.FinderRecursivePanel;
import com.intellij.util.messages.MessageBusConnection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SpringRepositoriesView
extends SpringBaseView {
    SpringRepositoriesView(Project project) {
        super(project);
        this.installToolbar();
        this.installContentListeners();
        this.installSettingsListener();
    }

    private void installContentListeners() {
        MessageBusConnection messageBusConnection = this.installProjectModuleListener();
        messageBusConnection.subscribe(PsiModificationTracker.TOPIC, (Object)new PsiModificationTracker.Listener(){

            public void modificationCountChanged() {
                SpringRepositoriesView.this.myRootPanel.updatePanel();
            }
        });
    }

    protected FinderRecursivePanel createRootPanel() {
        SpringRepositoriesViewSettings settings = SpringRepositoriesViewSettings.getInstance(this.myProject);
        if (settings.isShowModules()) {
            return new SpringRepositoriesModulesPanel(this.myProject);
        }
        return new SpringRepositoriesPanel(this.myProject);
    }

    private void installToolbar() {
        final SpringRepositoriesViewSettings settings = SpringRepositoriesViewSettings.getInstance(this.myProject);
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new ToggleAction("Show modules", null, AllIcons.Actions.GroupByModule){

            public boolean isSelected(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                return settings.isShowModules();
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                if (e == null) {
                    2.$$$reportNull$$$0(1);
                }
                settings.setShowModules(state);
                settings.fireSettingsChanged(SpringRepositoriesViewSettings.ChangeType.FULL);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/spring/data/commons/view/SpringRepositoriesView$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isSelected";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "setSelected";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        group.add((AnAction)new ToggleAction("Search in libraries", null, AllIcons.Modules.Library){

            public boolean isSelected(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                return settings.isSearchInLibraries();
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                if (e == null) {
                    3.$$$reportNull$$$0(1);
                }
                settings.setSearchInLibraries(state);
                settings.fireSettingsChanged(SpringRepositoriesViewSettings.ChangeType.FULL);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/spring/data/commons/view/SpringRepositoriesView$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isSelected";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "setSelected";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        group.add((AnAction)new ToggleAction("Show inherited members", null, AllIcons.Hierarchy.Subtypes){

            public boolean isSelected(@NotNull AnActionEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                return settings.isShowAllRepositoryMethods();
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                if (e == null) {
                    4.$$$reportNull$$$0(1);
                }
                settings.setShowAllRepositoryMethods(state);
                settings.fireSettingsChanged(SpringRepositoriesViewSettings.ChangeType.UPDATE_LIST);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/spring/data/commons/view/SpringRepositoriesView$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isSelected";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "setSelected";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        group.addSeparator();
        group.add(this.getHelpAction());
        this.setToolbar(ActionManager.getInstance().createActionToolbar("SpringRepositoriesView", (ActionGroup)group, false).getComponent());
    }

    private void installSettingsListener() {
        this.myProject.getMessageBus().connect((Disposable)this.myProject).subscribe(SpringRepositoriesViewSettings.TOPIC, (Object)new SpringRepositoriesViewSettings.Listener(){

            @Override
            public void settingsChanged(SpringRepositoriesViewSettings.ChangeType changeType) {
                if (changeType == SpringRepositoriesViewSettings.ChangeType.FULL) {
                    SpringRepositoriesView.this.performFullUpdate();
                } else if (changeType == SpringRepositoriesViewSettings.ChangeType.UPDATE_DETAILS) {
                    SpringRepositoriesView.this.performDetailsUpdate();
                } else if (changeType == SpringRepositoriesViewSettings.ChangeType.UPDATE_LIST) {
                    SpringRepositoriesView.this.myRootPanel.updatePanel();
                } else if (changeType == SpringRepositoriesViewSettings.ChangeType.REPLACE_CHILD_UPDATE) {
                    SpringRepositoriesView.this.myRootPanel.updateRightComponent(true);
                }
            }
        });
    }

    @NotNull
    public static List<CommonSpringBean> getRepositories(@NotNull Module module) {
        boolean inLibraries;
        if (module == null) {
            SpringRepositoriesView.$$$reportNull$$$0(0);
        }
        GlobalSearchScope scope = (inLibraries = SpringRepositoriesViewSettings.getInstance(module.getProject()).isSearchInLibraries()) ? GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module) : GlobalSearchScope.moduleWithDependenciesScope((Module)module);
        List<CommonSpringBean> list = RepositoriesSearchUtil.getAllRepositories(scope, module, "org.springframework.data.repository.Repository");
        if (list == null) {
            SpringRepositoriesView.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    public static Set<SpringBeanPointer> getRepositoryPointers(@NotNull Module module) {
        if (module == null) {
            SpringRepositoriesView.$$$reportNull$$$0(2);
        }
        Set set = BeanService.getInstance().mapSpringBeans(SpringRepositoriesView.getRepositories(module));
        if (set == null) {
            SpringRepositoriesView.$$$reportNull$$$0(3);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/data/commons/view/SpringRepositoriesView";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/data/commons/view/SpringRepositoriesView";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepositories";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepositoryPointers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getRepositories";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getRepositoryPointers";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

