/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.data.commons.util.parser;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.spring.data.commons.util.parser.Part;
import com.intellij.spring.data.commons.util.parser.domain.OrderBySource;
import com.intellij.spring.data.commons.util.parser.domain.Sort;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PartTree
implements Iterable<OrPart> {
    private static final String KEYWORD_TEMPLATE = "(%s)(?=(\\p{Lu}|\\P{InBASIC_LATIN}))";
    private static final String QUERY_PATTERN = "find|read|get|query|stream";
    private static final String COUNT_PATTERN = "count";
    private static final String EXISTS_PATTERN = "exists";
    private static final String DELETE_PATTERN = "delete|remove";
    public static final Pattern PREFIX_TEMPLATE = Pattern.compile("^(find|read|get|query|stream|count|exists|delete|remove)((\\p{Lu}.*?))??By");
    private final Subject subject;
    private final Predicate predicate;
    private final String mySource;

    public PartTree(@NotNull String source, @NotNull PsiClass domainClass) {
        if (source == null) {
            PartTree.$$$reportNull$$$0(0);
        }
        if (domainClass == null) {
            PartTree.$$$reportNull$$$0(1);
        }
        this.mySource = source;
        Matcher matcher = PREFIX_TEMPLATE.matcher(source);
        if (!matcher.find()) {
            this.subject = new Subject(null);
            this.predicate = new Predicate(source, domainClass);
        } else {
            this.subject = new Subject(matcher.group(0));
            this.predicate = new Predicate(source.substring(matcher.group().length()), domainClass);
        }
    }

    public String getSource() {
        return this.mySource;
    }

    @Override
    public Iterator<OrPart> iterator() {
        return this.predicate.iterator();
    }

    public Sort getSort() {
        OrderBySource orderBySource = this.getOrderBySource();
        return orderBySource == null ? null : orderBySource.toSort();
    }

    @Nullable
    public OrderBySource getOrderBySource() {
        return this.predicate.getOrderBySource();
    }

    public boolean isDistinct() {
        return this.subject.isDistinct();
    }

    public Boolean isCountProjection() {
        return this.subject.isCountProjection();
    }

    public Boolean isExistsProjection() {
        return this.subject.isExistsProjection();
    }

    public Boolean isDelete() {
        return this.subject.isDelete();
    }

    public boolean isLimiting() {
        return this.getMaxResults() != null;
    }

    public Integer getMaxResults() {
        return this.subject.getMaxResults();
    }

    public List<Part> getParts() {
        ArrayList<Part> result = new ArrayList<Part>();
        for (OrPart orPart : this) {
            for (Part part : orPart) {
                result.add(part);
            }
        }
        return result;
    }

    public Iterable<Part> getParts(Part.Type type) {
        ArrayList<Part> result = new ArrayList<Part>();
        for (Part part : this.getParts()) {
            if (!part.getType().equals((Object)type)) continue;
            result.add(part);
        }
        return result;
    }

    public String toString() {
        OrderBySource orderBySource = this.getOrderBySource();
        return String.format("%s%s", StringUtil.join((Iterable)this.predicate.nodes, (String)" or "), orderBySource == null ? "" : " " + orderBySource);
    }

    private static String[] split(String text, String keyword) {
        if (text.equals(keyword)) {
            return new String[]{"", ""};
        }
        String format = String.format(KEYWORD_TEMPLATE, keyword);
        if (text.endsWith(keyword)) {
            List splitted = StringUtil.split((String)text, (String)keyword);
            splitted.add("");
            return ArrayUtil.toStringArray((Collection)splitted);
        }
        Pattern pattern = Pattern.compile(format);
        return pattern.split(text);
    }

    public Subject getSubject() {
        return this.subject;
    }

    public Predicate getPredicate() {
        return this.predicate;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "source";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "domainClass";
                break;
            }
        }
        objectArray[1] = "com/intellij/spring/data/commons/util/parser/PartTree";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class Predicate {
        private static final Pattern ALL_IGNORE_CASE = Pattern.compile("AllIgnor(ing|e)Case");
        private static final String ORDER_BY = "OrderBy";
        private final List<OrPart> nodes;
        private final OrderBySource orderBySource;
        private boolean alwaysIgnoreCase;

        Predicate(@NotNull String predicate, @NotNull PsiClass domainClass) {
            if (predicate == null) {
                Predicate.$$$reportNull$$$0(0);
            }
            if (domainClass == null) {
                Predicate.$$$reportNull$$$0(1);
            }
            this.nodes = new ArrayList<OrPart>();
            String[] parts = PartTree.split(this.detectAndSetAllIgnoreCase(predicate), ORDER_BY);
            if (parts.length > 2) {
                // empty if block
            }
            this.buildTree(parts[0], domainClass);
            this.orderBySource = parts.length == 2 ? new OrderBySource(parts[1], domainClass) : null;
        }

        private String detectAndSetAllIgnoreCase(String predicate) {
            Matcher matcher = ALL_IGNORE_CASE.matcher(predicate);
            if (matcher.find()) {
                this.alwaysIgnoreCase = true;
                predicate = predicate.substring(0, matcher.start()) + predicate.substring(matcher.end());
            }
            return predicate;
        }

        private void buildTree(@NotNull String source, @NotNull PsiClass domainClass) {
            String[] split;
            if (source == null) {
                Predicate.$$$reportNull$$$0(2);
            }
            if (domainClass == null) {
                Predicate.$$$reportNull$$$0(3);
            }
            for (String part : split = PartTree.split(source, "Or")) {
                this.nodes.add(new OrPart(part, domainClass, this.alwaysIgnoreCase));
            }
        }

        public Iterator<OrPart> iterator() {
            return this.nodes.iterator();
        }

        public OrderBySource getOrderBySource() {
            return this.orderBySource;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "predicate";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "domainClass";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/spring/data/commons/util/parser/PartTree$Predicate";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "buildTree";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class Subject {
        private static final String DISTINCT = "Distinct";
        private static final Pattern COUNT_BY_TEMPLATE = Pattern.compile("^count(\\p{Lu}.*?)??By");
        private static final Pattern EXISTS_BY_TEMPLATE = Pattern.compile("^(exists)(\\p{Lu}.*?)??By");
        private static final Pattern DELETE_BY_TEMPLATE = Pattern.compile("^(delete|remove)(\\p{Lu}.*?)??By");
        private static final String LIMITING_QUERY_PATTERN = "(First|Top)(\\d*)?";
        private static final Pattern LIMITED_QUERY_TEMPLATE = Pattern.compile("^(find|read|get|query|stream)(Distinct)?(First|Top)(\\d*)?(\\p{Lu}.*?)??By");
        private final String myExpression;
        private final boolean distinct;
        private final boolean exists;
        private final boolean count;
        private final boolean delete;
        private final Integer maxResults;

        public Subject(String subject) {
            this.myExpression = subject;
            this.distinct = subject == null ? false : subject.contains(DISTINCT);
            this.count = this.matches(subject, COUNT_BY_TEMPLATE);
            this.delete = this.matches(subject, DELETE_BY_TEMPLATE);
            this.exists = this.matches(subject, EXISTS_BY_TEMPLATE);
            this.maxResults = this.returnMaxResultsIfFirstKSubjectOrNull(subject);
        }

        private Integer returnMaxResultsIfFirstKSubjectOrNull(String subject) {
            if (subject == null) {
                return null;
            }
            Matcher grp = LIMITED_QUERY_TEMPLATE.matcher(subject);
            if (!grp.find()) {
                return null;
            }
            return StringUtil.isNotEmpty((String)grp.group(4)) ? Integer.valueOf(grp.group(4)) : 1;
        }

        public Boolean isDelete() {
            return this.delete;
        }

        public boolean isCountProjection() {
            return this.count;
        }

        public boolean isExistsProjection() {
            return this.exists;
        }

        public boolean isDistinct() {
            return this.distinct;
        }

        public Integer getMaxResults() {
            return this.maxResults;
        }

        private boolean matches(String subject, Pattern pattern) {
            return subject != null && pattern.matcher(subject).find();
        }

        public String getExpression() {
            return this.myExpression;
        }

        public String toString() {
            return "SUBJECT ('" + this.myExpression + ')';
        }
    }

    public static class OrPart
    implements Iterable<Part> {
        private final List<Part> children;
        private final String mySource;

        OrPart(@NotNull String source, PsiClass domainClass, boolean alwaysIgnoreCase) {
            String[] split;
            if (source == null) {
                OrPart.$$$reportNull$$$0(0);
            }
            this.children = new ArrayList<Part>();
            this.mySource = source;
            for (String part : split = PartTree.split(source, "And")) {
                this.children.add(new Part(part, domainClass, alwaysIgnoreCase));
            }
        }

        @Override
        public Iterator<Part> iterator() {
            return this.children.iterator();
        }

        public String toString() {
            return "OR ('" + this.mySource + "')";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/spring/data/commons/util/parser/PartTree$OrPart", "<init>"));
        }
    }
}

