/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.data.commons.ql;

import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.jpa.DefaultQlModel;
import com.intellij.jpa.ql.QlFile;
import com.intellij.jpa.ql.model.QlModel;
import com.intellij.jpa.util.JpaUtil;
import com.intellij.lang.Language;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.spring.data.commons.ql.domain.SpringDataDomainModel;
import com.intellij.spring.data.commons.ql.language.SpringDataQLLanguage;
import com.intellij.spring.data.commons.util.SpringDataUtil;
import com.intellij.spring.el.SpringELLanguage;
import com.intellij.spring.el.SpringElTemplateParser;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.sql.psi.SqlLanguage;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.TextRangeUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Pair;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UAnnotationUtils;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UPolyadicExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastLiteralUtils;

public class SpringDataQLInjector
implements MultiHostInjector {
    public static final Set<String> QUERY_ANNOTATIONS = ContainerUtil.immutableSet((Object[])new String[]{"org.springframework.data.jpa.repository.Query"});

    @NotNull
    public List<? extends Class<? extends PsiElement>> elementsToInjectIn() {
        List<Class<PsiElement>> list = Collections.singletonList(PsiElement.class);
        if (list == null) {
            SpringDataQLInjector.$$$reportNull$$$0(0);
        }
        return list;
    }

    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement context) {
        Iterator operands;
        if (registrar == null) {
            SpringDataQLInjector.$$$reportNull$$$0(1);
        }
        if (context == null) {
            SpringDataQLInjector.$$$reportNull$$$0(2);
        }
        if (!(operands = SpringDataQLInjector.getInjectionHostsForContext(context).iterator()).hasNext()) {
            return;
        }
        Project project = context.getProject();
        if (!SpringCommonUtils.hasSpringFacets((Project)project)) {
            return;
        }
        if (!SpringDataUtil.hasSpringDataSupport(project)) {
            return;
        }
        PsiLanguageInjectionHost theFirstHost = (PsiLanguageInjectionHost)operands.next();
        if (this.isQueryAnnotationHost((PsiElement)theFirstHost)) {
            Language languageToInject = SpringDataQLInjector.getLanguageToInject(theFirstHost);
            HashMap<PsiLanguageInjectionHost, List> spElTextRangeMap = new HashMap<PsiLanguageInjectionHost, List>();
            MultiHostRegistrar qlHostRegistrar = registrar.startInjecting(languageToInject);
            Iterator hostIterator = ContainerUtil.concatIterators((Iterator[])new Iterator[]{Collections.singleton(theFirstHost).iterator(), operands});
            while (hostIterator.hasNext()) {
                PsiLanguageInjectionHost operand = (PsiLanguageInjectionHost)hostIterator.next();
                String text = operand.getText();
                List spElTextRanges = SpringElTemplateParser.parse((String)text);
                if (spElTextRanges.size() != 0) {
                    spElTextRangeMap.put(operand, spElTextRanges);
                }
                TextRange valueTextRange = ElementManipulators.getValueTextRange((PsiElement)operand);
                for (TextRange qlRange : TextRangeUtil.excludeRanges((TextRange)valueTextRange, (List)spElTextRanges)) {
                    String suffix = SpringDataQLInjector.hasSpElTextRangeInPosition(qlRange.getEndOffset(), spElTextRanges) ? SpringDataQLInjector.getSuffixString(text, qlRange) : null;
                    qlHostRegistrar.addPlace(null, suffix, operand, qlRange);
                }
                TextRange lastSpEL = (TextRange)ContainerUtil.getLastItem((List)spElTextRanges);
                if (lastSpEL == null || lastSpEL.getEndOffset() != valueTextRange.getEndOffset()) continue;
                qlHostRegistrar.addPlace(null, null, operand, TextRange.from((int)lastSpEL.getEndOffset(), (int)0));
            }
            qlHostRegistrar.doneInjecting();
            for (Map.Entry entry : spElTextRangeMap.entrySet()) {
                PsiLanguageInjectionHost host = (PsiLanguageInjectionHost)entry.getKey();
                for (TextRange range : (List)entry.getValue()) {
                    registrar.startInjecting((Language)SpringELLanguage.INSTANCE).addPlace(null, null, host, range).doneInjecting();
                }
            }
            theFirstHost.putUserData(QlFile.PERSISTENCE_MODEL_KEY, (Object)SpringDataQLInjector.getQlModel((PsiElement)theFirstHost));
        }
    }

    private static StreamEx<PsiLanguageInjectionHost> getInjectionHostsForContext(PsiElement context) {
        if (!(context instanceof PsiLanguageInjectionHost) && !(context.getFirstChild() instanceof PsiLanguageInjectionHost)) {
            return StreamEx.empty();
        }
        UExpression uElement = (UExpression)UastContextKt.toUElement((PsiElement)context, UExpression.class);
        if (uElement == null) {
            return StreamEx.empty();
        }
        if (uElement instanceof UPolyadicExpression) {
            return (StreamEx)((StreamEx)StreamEx.of((Collection)((UPolyadicExpression)uElement).getOperands()).select(ULiteralExpression.class).map(UastLiteralUtils::getPsiLanguageInjectionHost).nonNull().filter(PsiLanguageInjectionHost::isValidHost)).distinct();
        }
        if (uElement instanceof ULiteralExpression && !(uElement.getUastParent() instanceof UPolyadicExpression)) {
            PsiLanguageInjectionHost host = UastLiteralUtils.getPsiLanguageInjectionHost((ULiteralExpression)((ULiteralExpression)uElement));
            if (host != context || !host.isValidHost()) {
                return StreamEx.empty();
            }
            return StreamEx.of((Object)host);
        }
        return StreamEx.empty();
    }

    public boolean isQueryAnnotationHost(@NotNull PsiElement host) {
        String annotationParamName;
        Pair annotationEntry;
        if (host == null) {
            SpringDataQLInjector.$$$reportNull$$$0(3);
        }
        if (host instanceof PsiLanguageInjectionHost && (annotationEntry = UAnnotationUtils.getContainingAnnotationEntry((UElement)UastContextKt.toUElement((PsiElement)host))) != null && ((annotationParamName = (String)annotationEntry.getSecond()) == null || "value".equals(annotationParamName) || "countQuery".equals(annotationParamName))) {
            PsiAnnotation annotation = (PsiAnnotation)annotationEntry.getFirst();
            return !annotation.getProject().isDefault() && SpringDataQLInjector.isQueryAnnotation(annotation);
        }
        return false;
    }

    private static boolean isQueryAnnotation(@NotNull PsiAnnotation psiAnnotation) {
        if (psiAnnotation == null) {
            SpringDataQLInjector.$$$reportNull$$$0(4);
        }
        return QUERY_ANNOTATIONS.contains(psiAnnotation.getQualifiedName());
    }

    private static Language getLanguageToInject(PsiLanguageInjectionHost host) {
        return SpringDataQLInjector.isNativeQuery(host) ? SqlLanguage.INSTANCE : SpringDataQLLanguage.INSTANCE;
    }

    private static boolean isNativeQuery(PsiLanguageInjectionHost host) {
        Pair annotationEntry = UAnnotationUtils.getContainingAnnotationEntry((UElement)UastContextKt.toUElement((PsiElement)host));
        if (annotationEntry == null) {
            return false;
        }
        PsiAnnotation annotation = (PsiAnnotation)annotationEntry.getFirst();
        if (annotation.getProject().isDefault()) {
            return false;
        }
        PsiAnnotationMemberValue nativeQueryMemberValue = annotation.findAttributeValue("nativeQuery");
        if (nativeQueryMemberValue == null) {
            return false;
        }
        Boolean value = (Boolean)JamCommonUtil.getObjectValue((PsiAnnotationMemberValue)nativeQueryMemberValue, Boolean.class);
        return value != null && value != false;
    }

    @NotNull
    private static String getSuffixString(String text, TextRange qlRange) {
        String string = qlRange.substring(text).trim().endsWith("?") ? "0" : "SpEl";
        if (string == null) {
            SpringDataQLInjector.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    private static QlModel getQlModel(PsiElement host) {
        PsiElement originalElement = host.getOriginalElement();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)originalElement);
        if (module != null && JpaUtil.getJpaFacet((Module)module) != null) {
            DefaultQlModel defaultQlModel = new DefaultQlModel(false, module);
            if (defaultQlModel == null) {
                SpringDataQLInjector.$$$reportNull$$$0(6);
            }
            return defaultQlModel;
        }
        SpringDataDomainModel springDataDomainModel = new SpringDataDomainModel(originalElement);
        if (springDataDomainModel == null) {
            SpringDataQLInjector.$$$reportNull$$$0(7);
        }
        return springDataDomainModel;
    }

    private static boolean hasSpElTextRangeInPosition(int offset, List<TextRange> ranges) {
        for (TextRange range : ranges) {
            if (!range.contains(offset)) continue;
            return true;
        }
        return false;
    }

    static {
        SpringDataQLLanguage.INSTANCE.getDisplayName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/data/commons/ql/SpringDataQLInjector";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAnnotation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "elementsToInjectIn";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/data/commons/ql/SpringDataQLInjector";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuffixString";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getQlModel";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getLanguagesToInject";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isQueryAnnotationHost";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isQueryAnnotation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

