/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.thymeleaf.lang.psi.impl;

import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.thymeleaf.lang.psi.ThymeleafTemplateFragmentReference;
import com.intellij.thymeleaf.lang.psi.ThymesELMethodCallExpression;
import com.intellij.thymeleaf.lang.psi.ThymesELVariable;
import com.intellij.thymeleaf.lang.psi.ThymesElExpression;
import com.intellij.thymeleaf.lang.psi.ThymesPathTemplateSelector;
import com.intellij.thymeleaf.lang.psi.ThymesTemplateName;
import com.intellij.thymeleaf.lang.psi.ThymesTemplateSelectionExpression;
import com.intellij.thymeleaf.lang.psi.ThymesTemplateSelector;
import com.intellij.thymeleaf.lang.psi.impl.ThymeleafPsiCompositeElementImpl;
import com.intellij.thymeleaf.lang.support.utils.ThymeleafCommonUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import icons.ThymeleafIcons;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ThymeleafTemplateFragmentReferenceImpl
extends ThymeleafPsiCompositeElementImpl
implements ThymeleafTemplateFragmentReference {
    private static final Function<XmlTag, XmlAttribute> FRAGMENT = tag -> ThymeleafCommonUtil.findThymeleafAttribute(tag, "fragment");
    private static final Function<XmlTag, XmlAttribute> ID_REF = tag -> tag.getAttribute("id");

    public ThymeleafTemplateFragmentReferenceImpl(@NotNull ASTNode node) {
        if (node == null) {
            ThymeleafTemplateFragmentReferenceImpl.$$$reportNull$$$0(0);
        }
        super(node);
    }

    @NotNull
    public PsiElement getElement() {
        ThymeleafTemplateFragmentReferenceImpl thymeleafTemplateFragmentReferenceImpl = this;
        if (thymeleafTemplateFragmentReferenceImpl == null) {
            ThymeleafTemplateFragmentReferenceImpl.$$$reportNull$$$0(1);
        }
        return thymeleafTemplateFragmentReferenceImpl;
    }

    public PsiReference getReference() {
        return this;
    }

    @NotNull
    public TextRange getRangeInElement() {
        TextRange textRange = this.getTextRange();
        TextRange textRange2 = new TextRange(0, textRange.getEndOffset() - textRange.getStartOffset());
        if (textRange2 == null) {
            ThymeleafTemplateFragmentReferenceImpl.$$$reportNull$$$0(2);
        }
        return textRange2;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.getText();
        if (string == null) {
            ThymeleafTemplateFragmentReferenceImpl.$$$reportNull$$$0(3);
        }
        return string;
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            ThymeleafTemplateFragmentReferenceImpl.$$$reportNull$$$0(4);
        }
        throw new UnsupportedOperationException();
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            ThymeleafTemplateFragmentReferenceImpl.$$$reportNull$$$0(5);
        }
        if (element instanceof PsiFile) {
            return this.handleElementRename(((PsiFile)element).getName());
        }
        return element;
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element == null) {
            ThymeleafTemplateFragmentReferenceImpl.$$$reportNull$$$0(6);
        }
        PsiElement resolve = this.resolve();
        return element.equals(resolve);
    }

    @NotNull
    public Object[] getVariants() {
        HashSet results = ContainerUtil.newHashSet();
        XmlFile templateFile = this.getTemplateFile();
        if (templateFile != null) {
            for (Map.Entry<String, PsiElement> entry : ThymeleafTemplateFragmentReferenceImpl.getTemplateFragments(templateFile, FRAGMENT).entrySet()) {
                results.add(LookupElementBuilder.create((String)entry.getKey()).bold().withIcon(ThymeleafIcons.Thymeleaf));
            }
            for (Map.Entry<String, PsiElement> entry : ThymeleafTemplateFragmentReferenceImpl.getTemplateFragments(templateFile, ID_REF).entrySet()) {
                results.add(LookupElementBuilder.create((String)("#" + entry.getKey())).bold().withIcon(ThymeleafIcons.Thymeleaf));
            }
        }
        Object[] objectArray = ArrayUtil.toObjectArray((Collection)results);
        if (objectArray == null) {
            ThymeleafTemplateFragmentReferenceImpl.$$$reportNull$$$0(7);
        }
        return objectArray;
    }

    public boolean isSoft() {
        PsiElement element = this.getElement();
        ThymesTemplateSelectionExpression selectionExpression = (ThymesTemplateSelectionExpression)PsiTreeUtil.getParentOfType((PsiElement)element, ThymesTemplateSelectionExpression.class);
        if (selectionExpression != null) {
            ThymesTemplateSelector templateSelector = selectionExpression.getTemplateSelector();
            return templateSelector != null && !this.isSimpleSelector(templateSelector);
        }
        return false;
    }

    public boolean isSimpleSelector(@NotNull ThymesTemplateSelector templateSelector) {
        ThymesPathTemplateSelector selector;
        if (templateSelector == null) {
            ThymeleafTemplateFragmentReferenceImpl.$$$reportNull$$$0(8);
        }
        return (selector = templateSelector.getPathTemplateSelector()) != null && selector.getTemplateNameList().size() == 1;
    }

    public PsiElement resolve() {
        String fragmentName = this.getText();
        XmlFile templateFile = this.getTemplateFile();
        if (templateFile != null) {
            String fragmentRef = fragmentName.startsWith("#") && fragmentName.length() > 1 ? fragmentName.substring(1) : fragmentName;
            Function<XmlTag, XmlAttribute> function = fragmentName.startsWith("#") ? ID_REF : FRAGMENT;
            for (Map.Entry<String, PsiElement> entry : ThymeleafTemplateFragmentReferenceImpl.getTemplateFragments(templateFile, function).entrySet()) {
                if (!fragmentRef.equals(entry.getKey())) continue;
                return entry.getValue();
            }
        }
        return null;
    }

    @NotNull
    private static Map<String, PsiElement> getTemplateFragments(@NotNull XmlFile file, final Function<XmlTag, XmlAttribute> function) {
        if (file == null) {
            ThymeleafTemplateFragmentReferenceImpl.$$$reportNull$$$0(9);
        }
        final HashMap result = ContainerUtil.newHashMap();
        file.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(){

            public void visitXmlTag(XmlTag tag) {
                String value;
                XmlAttribute attribute = (XmlAttribute)function.fun((Object)tag);
                if (attribute != null && StringUtil.isNotEmpty((String)(value = attribute.getValue()))) {
                    ThymesElExpression expression = ThymeleafCommonUtil.getAttributeExpression(attribute);
                    if (expression == null) {
                        result.put(attribute.getValue(), attribute.getValueElement());
                    } else if (expression instanceof ThymesELVariable) {
                        result.put(expression.getText(), expression);
                    } else if (expression instanceof ThymesELMethodCallExpression) {
                        ThymesElExpression thymesElExpression = ((ThymesELMethodCallExpression)expression).getElExpression();
                        result.put(thymesElExpression.getText(), thymesElExpression);
                    }
                }
                super.visitXmlTag(tag);
            }
        });
        HashMap hashMap = result;
        if (hashMap == null) {
            ThymeleafTemplateFragmentReferenceImpl.$$$reportNull$$$0(10);
        }
        return hashMap;
    }

    @Nullable
    public XmlFile getTemplateFile() {
        ThymesTemplateName templateName;
        ThymesPathTemplateSelector pathTemplateSelector;
        ThymesTemplateSelector templateSelector;
        PsiElement element = this.getElement();
        ThymesTemplateSelectionExpression selectionExpression = (ThymesTemplateSelectionExpression)PsiTreeUtil.getParentOfType((PsiElement)element, ThymesTemplateSelectionExpression.class);
        if (selectionExpression != null && (templateSelector = selectionExpression.getTemplateSelector()) != null && (pathTemplateSelector = templateSelector.getPathTemplateSelector()) != null && (templateName = pathTemplateSelector.getTemplateNameList().get(0)) != null) {
            if ("this".equals(templateName.getText())) {
                PsiFile thFile = this.getContainingFile();
                if (thFile != null) {
                    PsiElement context = thFile.getContext();
                    return context instanceof XmlAttributeValue ? (XmlFile)context.getContainingFile() : null;
                }
            } else {
                PsiElement templateFile = templateName.resolve();
                if (templateFile instanceof XmlFile) {
                    return (XmlFile)templateFile;
                }
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/thymeleaf/lang/psi/impl/ThymeleafTemplateFragmentReferenceImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateSelector";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/thymeleaf/lang/psi/impl/ThymeleafTemplateFragmentReferenceImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateFragments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 10: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isSimpleSelector";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getTemplateFragments";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

