/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.execution.CantRunException;
import com.intellij.execution.ConfigurationUtil;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.TestClassCollector;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.execution.junit.RefactoringListeners;
import com.intellij.execution.junit.TestClassFilter;
import com.intellij.execution.junit.TestObject;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.SearchForTestsTask;
import com.intellij.execution.testframework.SourceScope;
import com.intellij.execution.testframework.TestSearchScope;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PackageScope;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.rt.execution.junit.JUnitStarter;
import com.intellij.util.Function;
import com.intellij.util.containers.JBTreeTraverser;
import gnu.trove.THashSet;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestPackage
extends TestObject {
    public TestPackage(JUnitConfiguration configuration, ExecutionEnvironment environment) {
        super(configuration, environment);
    }

    @Override
    @Nullable
    public SourceScope getSourceScope() {
        JUnitConfiguration.Data data = this.getConfiguration().getPersistentData();
        return data.getScope().getSourceScope((ModuleBasedConfiguration)this.getConfiguration());
    }

    public SearchForTestsTask createSearchingForTestsTask() {
        final JUnitConfiguration.Data data = this.getConfiguration().getPersistentData();
        return new SearchForTestsTask(this.getConfiguration().getProject(), this.myServerSocket){
            private final Set<String> myClassNames;
            {
                super(arg0, arg1);
                this.myClassNames = new LinkedHashSet<String>();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void search() {
                this.myClassNames.clear();
                SourceScope sourceScope = TestPackage.this.getSourceScope();
                Module module = ((JavaRunConfigurationModule)TestPackage.this.getConfiguration().getConfigurationModule()).getModule();
                if (sourceScope != null) {
                    DumbService instance = DumbService.getInstance((Project)this.myProject);
                    try {
                        instance.setAlternativeResolveEnabled(true);
                        TestClassFilter classFilter = TestPackage.this.getClassFilter(data);
                        TestObject.LOG.assertTrue(classFilter.getBase() != null);
                        TestPackage.this.searchTests(module, classFilter, this.myClassNames);
                    }
                    catch (CantRunException cantRunException) {
                    }
                    finally {
                        instance.setAlternativeResolveEnabled(false);
                    }
                }
            }

            protected void onFound() {
                try {
                    String packageName = TestPackage.this.getPackageName(data);
                    if ("-junit5".equals(TestPackage.this.getRunner()) && this.myClassNames.isEmpty() && TestPackage.this.getConfiguration().getTestSearchScope() == TestSearchScope.SINGLE_MODULE) {
                        VirtualFile[] rootPaths = TestPackage.this.getRootPaths();
                        TestObject.LOG.assertTrue(rootPaths != null);
                        JUnitStarter.printClassesList(Arrays.stream(rootPaths).map(root -> "+" + root.getPath()).collect(Collectors.toList()), (String)packageName, (String)"", (String)(packageName.isEmpty() ? ".*" : packageName + "\\..*"), (File)TestPackage.this.myTempFile);
                    } else {
                        TestPackage.this.addClassesListToJavaParameters(this.myClassNames, Function.ID, packageName, TestPackage.this.createTempFiles(), TestPackage.this.getJavaParameters());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
    }

    protected void searchTests(Module module, TestClassFilter classFilter, Set<? super String> names) throws CantRunException {
        if ("-junit5".equals(this.getRunner())) {
            return;
        }
        THashSet classes = new THashSet();
        if (Registry.is((String)"junit4.search.4.tests.all.in.scope", (boolean)true)) {
            Condition acceptClassCondition = aClass -> (Boolean)ReadAction.compute(() -> aClass.isValid() && classFilter.isAccepted((PsiClass)aClass));
            this.collectClassesRecursively(classFilter, (Condition<? super PsiClass>)acceptClassCondition, (Set<? super PsiClass>)classes);
        } else {
            ConfigurationUtil.findAllTestClasses(classFilter, module, (Set<? super PsiClass>)classes);
        }
        classes.forEach(psiClass -> names.add(JavaExecutionUtil.getRuntimeQualifiedName((PsiClass)psiClass)));
    }

    @Nullable
    protected VirtualFile[] getRootPaths() {
        Module module = ((JavaRunConfigurationModule)this.getConfiguration().getConfigurationModule()).getModule();
        boolean chooseSingleModule = this.getConfiguration().getTestSearchScope() == TestSearchScope.SINGLE_MODULE;
        return TestClassCollector.getRootPath((Module)module, (boolean)chooseSingleModule);
    }

    protected boolean createTempFiles() {
        return false;
    }

    @NotNull
    protected String getPackageName(JUnitConfiguration.Data data) throws CantRunException {
        PsiPackage aPackage = this.getPackage(data);
        String string = aPackage != null ? aPackage.getQualifiedName() : "";
        if (string == null) {
            TestPackage.$$$reportNull$$$0(0);
        }
        return string;
    }

    protected void collectClassesRecursively(TestClassFilter classFilter, Condition<? super PsiClass> acceptClassCondition, Set<? super PsiClass> classes) throws CantRunException {
        PsiPackage aPackage = this.getPackage(this.getConfiguration().getPersistentData());
        if (aPackage != null) {
            GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)this.getConfiguration().getProject()).intersectWith(classFilter.getScope());
            TestPackage.collectClassesRecursively(aPackage, scope, acceptClassCondition, classes);
        }
    }

    private static void collectClassesRecursively(PsiPackage aPackage, GlobalSearchScope scope, Condition<? super PsiClass> acceptAsTest, Set<? super PsiClass> classes) {
        PsiClass[] psiClasses;
        PsiPackage[] psiPackages;
        for (PsiPackage psiPackage : psiPackages = (PsiPackage[])ReadAction.compute(() -> aPackage.getSubPackages(scope))) {
            TestPackage.collectClassesRecursively(psiPackage, scope, acceptAsTest, classes);
        }
        for (PsiClass aClass : psiClasses = (PsiClass[])ReadAction.compute(() -> aPackage.getClasses(scope))) {
            TestPackage.collectInnerClasses(aClass, acceptAsTest, classes);
        }
    }

    protected static void collectInnerClasses(PsiClass aClass, Condition<? super PsiClass> acceptAsTest, Set<? super PsiClass> classes) {
        if (Registry.is((String)"junit4.accept.inner.classes", (boolean)true)) {
            classes.addAll((Collection)ReadAction.compute(() -> ((JBTreeTraverser)((JBTreeTraverser)JBTreeTraverser.of(PsiClass::getInnerClasses).withRoot((Object)aClass)).filter(acceptAsTest)).toList()));
        } else if (acceptAsTest.value((Object)aClass)) {
            classes.add((PsiClass)aClass);
        }
    }

    @Override
    protected JavaParameters createJavaParameters() throws ExecutionException {
        JavaParameters javaParameters = super.createJavaParameters();
        JUnitConfiguration.Data data = this.getConfiguration().getPersistentData();
        Project project = this.getConfiguration().getProject();
        SourceScope sourceScope = data.getScope().getSourceScope((ModuleBasedConfiguration)this.getConfiguration());
        if (sourceScope == null || !"-junit5".equals(this.getRunner())) {
            JUnitUtil.checkTestCase((SourceScope)sourceScope, (Project)project);
        }
        this.createTempFiles(javaParameters);
        this.createServerSocket(javaParameters);
        return javaParameters;
    }

    protected boolean configureByModule(Module module) {
        return super.configureByModule(module) && this.getConfiguration().getPersistentData().getScope() != TestSearchScope.WHOLE_PROJECT;
    }

    protected TestClassFilter getClassFilter(JUnitConfiguration.Data data) throws CantRunException {
        Module module = ((JavaRunConfigurationModule)this.getConfiguration().getConfigurationModule()).getModule();
        if (this.getConfiguration().getPersistentData().getScope() == TestSearchScope.WHOLE_PROJECT) {
            module = null;
        }
        TestClassFilter classFilter = TestClassFilter.create(this.getSourceScope(), module);
        return classFilter.intersectionWith(this.filterScope(data));
    }

    protected GlobalSearchScope filterScope(JUnitConfiguration.Data data) throws CantRunException {
        Ref ref = new Ref();
        GlobalSearchScope aPackage = (GlobalSearchScope)ReadAction.compute(() -> {
            try {
                return PackageScope.packageScope((PsiPackage)this.getPackage(data), (boolean)true);
            }
            catch (CantRunException e) {
                ref.set((Object)e);
                return null;
            }
        });
        CantRunException exception = (CantRunException)((Object)ref.get());
        if (exception != null) {
            throw exception;
        }
        return aPackage;
    }

    protected PsiPackage getPackage(JUnitConfiguration.Data data) throws CantRunException {
        Project project = this.getConfiguration().getProject();
        String packageName = data.getPackageName();
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        PsiPackage aPackage = JavaPsiFacade.getInstance((Project)psiManager.getProject()).findPackage(packageName);
        if (aPackage == null) {
            throw CantRunException.packageNotFound((String)packageName);
        }
        return aPackage;
    }

    @Override
    public String suggestActionName() {
        JUnitConfiguration.Data data = this.getConfiguration().getPersistentData();
        if (data.getPackageName().trim().length() > 0) {
            return ExecutionBundle.message((String)"test.in.scope.presentable.text", (Object[])new Object[]{data.getPackageName()});
        }
        return ExecutionBundle.message((String)"all.tests.scope.presentable.text", (Object[])new Object[0]);
    }

    @Override
    public RefactoringElementListener getListener(PsiElement element, JUnitConfiguration configuration) {
        if (!(element instanceof PsiPackage)) {
            return null;
        }
        return RefactoringListeners.getListener((PsiPackage)((PsiPackage)element), configuration.myPackage);
    }

    @Override
    public boolean isConfiguredByElement(JUnitConfiguration configuration, PsiClass testClass, PsiMethod testMethod, PsiPackage testPackage, PsiDirectory testDir) {
        return testPackage != null && Comparing.equal((String)testPackage.getQualifiedName(), (String)configuration.getPersistentData().getPackageName());
    }

    @Override
    public void checkConfiguration() throws RuntimeConfigurationException {
        super.checkConfiguration();
        String packageName = this.getConfiguration().getPersistentData().getPackageName();
        PsiPackage aPackage = JavaPsiFacade.getInstance((Project)this.getConfiguration().getProject()).findPackage(packageName);
        if (aPackage == null) {
            throw new RuntimeConfigurationWarning(ExecutionBundle.message((String)"package.does.not.exist.error.message", (Object[])new Object[]{packageName}));
        }
        if (this.getSourceScope() == null) {
            ((JavaRunConfigurationModule)this.getConfiguration().getConfigurationModule()).checkForWarning();
        }
    }

    public File getWorkingDirsFile() {
        return this.myWorkingDirsFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/junit/TestPackage", "getPackageName"));
    }
}

