/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.inline.InlineOptionsDialog;
import java.util.Map;
import org.jetbrains.android.refactoring.AndroidAttributeInfo;
import org.jetbrains.android.refactoring.AndroidInlineAllStyleUsagesProcessor;
import org.jetbrains.android.refactoring.StyleRefData;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AndroidInlineStyleDialog
extends InlineOptionsDialog {
    private final String myStyleName;
    private final boolean myInlineThisByDefault;
    private final Map<AndroidAttributeInfo, String> myAttributeValues;
    private final StyleRefData myParentStyleRef;
    private final XmlTag myStyleTag;

    AndroidInlineStyleDialog(@NotNull Project project, @NotNull PsiElement styleElement, @NotNull XmlTag styleTag, @NotNull String styleName, @NotNull Map<AndroidAttributeInfo, String> attributeValues, @Nullable StyleRefData parentStyleRef, boolean inlineThisByDefault, boolean invokedOnReference) {
        if (project == null) {
            AndroidInlineStyleDialog.$$$reportNull$$$0(0);
        }
        if (styleElement == null) {
            AndroidInlineStyleDialog.$$$reportNull$$$0(1);
        }
        if (styleTag == null) {
            AndroidInlineStyleDialog.$$$reportNull$$$0(2);
        }
        if (styleName == null) {
            AndroidInlineStyleDialog.$$$reportNull$$$0(3);
        }
        if (attributeValues == null) {
            AndroidInlineStyleDialog.$$$reportNull$$$0(4);
        }
        super(project, true, styleElement);
        this.myStyleTag = styleTag;
        this.myStyleName = styleName;
        this.myInlineThisByDefault = inlineThisByDefault;
        this.myAttributeValues = attributeValues;
        this.myParentStyleRef = parentStyleRef;
        this.myInvokedOnReference = invokedOnReference;
        this.setTitle(AndroidBundle.message("android.inline.style.title", styleName));
        this.init();
    }

    protected String getNameLabelText() {
        return "Style '" + this.myStyleName + "'";
    }

    protected String getBorderTitle() {
        return "Inline";
    }

    protected String getInlineAllText() {
        return AndroidBundle.message("android.inline.style.inline.all.text", new Object[0]);
    }

    protected String getInlineThisText() {
        return AndroidBundle.message("android.inline.style.inline.this.text", new Object[0]);
    }

    protected boolean isInlineThis() {
        return this.myInlineThisByDefault;
    }

    protected void doAction() {
        if (this.isInlineThisOnly()) {
            this.close(0);
        } else {
            this.invokeRefactoring(new AndroidInlineAllStyleUsagesProcessor(this.myProject, this.myElement, this.myStyleTag, this.myStyleName, this.myAttributeValues, this.myParentStyleRef, null));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "styleElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "styleTag";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "styleName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "attributeValues";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/android/refactoring/AndroidInlineStyleDialog";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

