/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring;

import com.intellij.analysis.AnalysisScopeBundle;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.android.refactoring.AndroidFindStyleApplicationsProcessor;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidFindStyleApplicationsDialog
extends DialogWrapper {
    private JPanel myPanel;
    private JBRadioButton myModuleScopeRadio;
    private JBRadioButton myFileScopeRadio;
    private JBRadioButton myProjectScopeRadio;
    private JBLabel myCaptionLabel;
    private final VirtualFile myFile;
    private final AndroidFindStyleApplicationsProcessor myProcessor;
    private static final String FIND_STYLE_APPLICATIONS_SCOPE_PROPERTY = "ANDROID_FIND_STYLE_APPLICATION_SCOPE";

    protected AndroidFindStyleApplicationsDialog(@Nullable VirtualFile file, @NotNull AndroidFindStyleApplicationsProcessor processor, boolean showModuleRadio) {
        if (processor == null) {
            AndroidFindStyleApplicationsDialog.$$$reportNull$$$0(0);
        }
        super(processor.getModule().getProject(), true);
        this.myFile = file;
        this.myProcessor = processor;
        this.$$$setupUI$$$();
        Module module = processor.getModule();
        this.myModuleScopeRadio.setText(AnalysisScopeBundle.message((String)"scope.option.module.with.mnemonic", (Object[])new Object[]{module.getName()}));
        this.myModuleScopeRadio.setVisible(showModuleRadio);
        if (file != null) {
            this.myFileScopeRadio.setText("File '" + file.getName() + "'");
        } else {
            this.myFileScopeRadio.setVisible(false);
        }
        String scopeValue = PropertiesComponent.getInstance().getValue(FIND_STYLE_APPLICATIONS_SCOPE_PROPERTY);
        AndroidFindStyleApplicationsProcessor.MyScope scope = null;
        if (scopeValue != null) {
            try {
                scope = Enum.valueOf(AndroidFindStyleApplicationsProcessor.MyScope.class, scopeValue);
            }
            catch (IllegalArgumentException e) {
                scope = null;
            }
        }
        if (scope == null) {
            scope = AndroidFindStyleApplicationsProcessor.MyScope.FILE;
        }
        switch (scope) {
            case PROJECT: {
                this.myProjectScopeRadio.setSelected(true);
                break;
            }
            case MODULE: {
                this.myModuleScopeRadio.setSelected(true);
                break;
            }
            case FILE: {
                this.myFileScopeRadio.setSelected(true);
            }
        }
        if (this.myModuleScopeRadio.isSelected() && !this.myModuleScopeRadio.isVisible() || this.myFileScopeRadio.isSelected() && !this.myFileScopeRadio.isVisible()) {
            this.myProjectScopeRadio.setSelected(true);
        }
        this.myCaptionLabel.setText("Choose a scope where to search possible applications of style '" + this.myProcessor.getStyleName() + "'");
        this.setTitle(AndroidBundle.message("android.find.style.applications.title", new Object[0]));
        this.init();
    }

    protected void doOKAction() {
        AndroidFindStyleApplicationsProcessor.MyScope scope = this.myModuleScopeRadio.isSelected() ? AndroidFindStyleApplicationsProcessor.MyScope.MODULE : (this.myProjectScopeRadio.isSelected() ? AndroidFindStyleApplicationsProcessor.MyScope.PROJECT : AndroidFindStyleApplicationsProcessor.MyScope.FILE);
        PropertiesComponent.getInstance().setValue(FIND_STYLE_APPLICATIONS_SCOPE_PROPERTY, scope.name());
        this.myProcessor.configureScope(scope, this.myFile);
        this.myProcessor.setPrepareSuccessfulSwingThreadCallback(new Runnable(){

            @Override
            public void run() {
                AndroidFindStyleApplicationsDialog.this.close(0);
            }
        });
        this.myProcessor.run();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/android/refactoring/AndroidFindStyleApplicationsDialog", "<init>"));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBRadioButton jBRadioButton;
        JBRadioButton jBRadioButton2;
        JBRadioButton jBRadioButton3;
        JBLabel jBLabel;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myCaptionLabel = jBLabel = new JBLabel();
        jBLabel.setText("");
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 1, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myProjectScopeRadio = jBRadioButton3 = new JBRadioButton();
        jBRadioButton3.setText("Whole project");
        jBRadioButton3.setMnemonic('W');
        jBRadioButton3.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jBRadioButton3, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myModuleScopeRadio = jBRadioButton2 = new JBRadioButton();
        jPanel2.add((Component)jBRadioButton2, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myFileScopeRadio = jBRadioButton = new JBRadioButton();
        jBRadioButton.setText("Current file");
        jBRadioButton.setMnemonic('F');
        jBRadioButton.setDisplayedMnemonicIndex(8);
        jPanel2.add((Component)jBRadioButton, new GridConstraints(2, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add((AbstractButton)jBRadioButton3);
        buttonGroup.add((AbstractButton)jBRadioButton2);
        buttonGroup.add((AbstractButton)jBRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

