/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections.lint;

import com.android.builder.model.LintOptions;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.editors.strings.StringsVirtualFile;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.lint.AndroidLintLintBaselineInspection;
import com.android.tools.idea.lint.LintIdeClient;
import com.android.tools.idea.lint.LintIdeIssueRegistry;
import com.android.tools.idea.lint.LintIdeRequest;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.LintBaseline;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.client.api.LintRequest;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Scope;
import com.google.common.collect.Lists;
import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.codeInspection.lang.GlobalInspectionContextExtension;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.module.impl.scopes.ModuleWithDependenciesScope;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressWrapper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.containers.HashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.inspections.lint.AndroidLintExternalAnnotator;
import org.jetbrains.android.inspections.lint.AndroidLintInspectionBase;
import org.jetbrains.android.inspections.lint.ProblemData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AndroidLintGlobalInspectionContext
implements GlobalInspectionContextExtension<AndroidLintGlobalInspectionContext> {
    static final Key<AndroidLintGlobalInspectionContext> ID = Key.create((String)"AndroidLintGlobalInspectionContext");
    private Map<Issue, Map<File, List<ProblemData>>> myResults;
    private LintBaseline myBaseline;
    private Issue myEnabledIssue;

    AndroidLintGlobalInspectionContext() {
    }

    @NotNull
    public Key<AndroidLintGlobalInspectionContext> getID() {
        Key<AndroidLintGlobalInspectionContext> key = ID;
        if (key == null) {
            AndroidLintGlobalInspectionContext.$$$reportNull$$$0(0);
        }
        return key;
    }

    public void performPreRunActivities(@NotNull List<Tools> globalTools, @NotNull List<Tools> localTools, @NotNull GlobalInspectionContext context) {
        Tools tool;
        String id;
        Issue issue2;
        Tools tool2;
        if (globalTools == null) {
            AndroidLintGlobalInspectionContext.$$$reportNull$$$0(1);
        }
        if (localTools == null) {
            AndroidLintGlobalInspectionContext.$$$reportNull$$$0(2);
        }
        if (context == null) {
            AndroidLintGlobalInspectionContext.$$$reportNull$$$0(3);
        }
        Project project = context.getProject();
        if (localTools.isEmpty() && globalTools.size() == 1 && !(tool2 = globalTools.get(0)).getShortName().startsWith("AndroidLint")) {
            return;
        }
        if (!ProjectFacetManager.getInstance((Project)project).hasFacets(AndroidFacet.ID)) {
            return;
        }
        Set<Issue> issues = AndroidLintExternalAnnotator.getIssuesFromInspections(project, null);
        if (issues.isEmpty()) {
            return;
        }
        if (localTools.isEmpty() && globalTools.size() == 1 && (issue2 = new LintIdeIssueRegistry().getIssue(id = (tool = globalTools.get(0)).getShortName().substring("AndroidLint".length()))) != null && !issue2.isEnabledByDefault()) {
            issues = Collections.singleton(issue2);
            issue2.setEnabledByDefault(true);
            this.myEnabledIssue = issue2;
        }
        HashMap problemMap = new HashMap();
        AnalysisScope scope = context.getRefManager().getScope();
        if (scope == null && (scope = AndroidLintLintBaselineInspection.ourRerunScope) == null) {
            return;
        }
        LintIdeClient client = LintIdeClient.forBatch(project, (Map<Issue, Map<File, List<ProblemData>>>)problemMap, scope, issues);
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (indicator != null) {
            ProgressWrapper.unwrap((ProgressIndicator)indicator).setText("Running Android Lint");
        }
        EnumSet lintScope = EnumSet.copyOf(Scope.ALL);
        lintScope.remove(Scope.CLASS_FILE);
        lintScope.remove(Scope.ALL_CLASS_FILES);
        lintScope.remove(Scope.JAVA_LIBRARIES);
        ArrayList files = null;
        ArrayList modules = Lists.newArrayList();
        int scopeType = scope.getScopeType();
        switch (scopeType) {
            case 4: {
                ModuleWithDependenciesScope s;
                Object searchScope = (SearchScope)ReadAction.compute(() -> ((AnalysisScope)scope).toSearchScope());
                if (!(searchScope instanceof ModuleWithDependenciesScope) || (s = (ModuleWithDependenciesScope)searchScope).isSearchInLibraries()) break;
                modules.add(s.getModule());
                break;
            }
            case 3: 
            case 9: 
            case 10: {
                files = Lists.newArrayList();
                Object searchScope = (SearchScope)ReadAction.compute(() -> ((AnalysisScope)scope).toSearchScope());
                if (searchScope instanceof LocalSearchScope) {
                    LocalSearchScope localSearchScope = (LocalSearchScope)searchScope;
                    PsiElement[] elements = localSearchScope.getScope();
                    ArrayList finalFiles = files;
                    ApplicationManager.getApplication().runReadAction(() -> {
                        for (PsiElement element : elements) {
                            VirtualFile virtualFile;
                            if (!(element instanceof PsiFile)) continue;
                            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
                            if (module != null && !modules.contains(module)) {
                                modules.add(module);
                            }
                            if ((virtualFile = ((PsiFile)element).getVirtualFile()) == null) continue;
                            if (virtualFile instanceof StringsVirtualFile) {
                                StringsVirtualFile f = (StringsVirtualFile)virtualFile;
                                if (modules.contains(f.getFacet().getModule())) continue;
                                modules.add(f.getFacet().getModule());
                                continue;
                            }
                            finalFiles.add(virtualFile);
                        }
                    });
                } else {
                    final ArrayList finalList = files;
                    scope.accept(new PsiElementVisitor(){

                        public void visitFile(PsiFile file) {
                            VirtualFile virtualFile = file.getVirtualFile();
                            if (virtualFile != null) {
                                finalList.add(virtualFile);
                            }
                        }
                    });
                }
                if (files.isEmpty()) {
                    files = null;
                    break;
                }
                lintScope = null;
                break;
            }
            case 1: {
                modules.addAll(Arrays.asList(ModuleManager.getInstance((Project)project).getModules()));
                break;
            }
            case 2: 
            case 7: 
            case 8: {
                break;
            }
            case 6: {
                break;
            }
            default: {
                Logger.getInstance(this.getClass()).warn("Unexpected inspection scope " + scope + ", " + scopeType);
            }
        }
        if (modules.isEmpty()) {
            for (SearchScope module : ModuleManager.getInstance((Project)project).getModules()) {
                if (!scope.containsModule((Module)module)) continue;
                modules.add(module);
            }
            if (modules.isEmpty() && files != null) {
                for (VirtualFile file : files) {
                    Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project);
                    if (module == null || modules.contains(module)) continue;
                    modules.add(module);
                }
            }
            if (modules.isEmpty()) {
                AnalysisScope narrowed = scope.getNarrowedComplementaryScope(project);
                for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
                    if (!narrowed.containsModule(module)) continue;
                    modules.add(module);
                }
            }
        }
        LintIdeRequest request = new LintIdeRequest(client, project, files, modules, false);
        request.setScope(lintScope);
        LintDriver lint = new LintDriver((IssueRegistry)new LintIdeIssueRegistry(), (LintClient)client, (LintRequest)request);
        this.myBaseline = null;
        for (SearchScope module : modules) {
            AndroidModuleModel model = AndroidModuleModel.get((Module)module);
            if (model == null) continue;
            GradleVersion version = model.getModelVersion();
            if (version == null || !version.isAtLeast(2, 3, 0, "beta", 2, true)) break;
            LintOptions options = model.getAndroidProject().getLintOptions();
            try {
                String path;
                File baselineFile = options.getBaselineFile();
                if (baselineFile == null || AndroidLintLintBaselineInspection.ourSkipBaselineNextRun) break;
                if (!baselineFile.isAbsolute() && (path = module.getProject().getBasePath()) != null) {
                    baselineFile = new File(FileUtil.toSystemDependentName((String)path), baselineFile.getPath());
                }
                this.myBaseline = new LintBaseline((LintClient)client, baselineFile);
                lint.setBaseline(this.myBaseline);
                if (!baselineFile.isFile()) {
                    this.myBaseline.setWriteOnClose(true);
                    break;
                }
                if (!AndroidLintLintBaselineInspection.ourUpdateBaselineNextRun) break;
                this.myBaseline.setRemoveFixed(true);
                this.myBaseline.setWriteOnClose(true);
            }
            catch (Throwable throwable) {}
            break;
        }
        lint.analyze();
        List<Tools> tools = AndroidLintInspectionBase.getDynamicTools();
        AndroidLintInspectionBase.resetDynamicTools();
        if (tools != null) {
            for (Tools tool3 : tools) {
                String name = tool3.getShortName();
                boolean found = false;
                for (Tools registered : globalTools) {
                    if (!registered.getShortName().equals(name)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                globalTools.add(tool3);
            }
        }
        AndroidLintLintBaselineInspection.clearNextRunState();
        this.myResults = problemMap;
    }

    @Nullable
    public Map<Issue, Map<File, List<ProblemData>>> getResults() {
        return this.myResults;
    }

    public void performPostRunActivities(@NotNull List<InspectionToolWrapper> inspections, @NotNull GlobalInspectionContext context) {
        if (inspections == null) {
            AndroidLintGlobalInspectionContext.$$$reportNull$$$0(4);
        }
        if (context == null) {
            AndroidLintGlobalInspectionContext.$$$reportNull$$$0(5);
        }
        if (this.myBaseline != null) {
            if (this.myBaseline.isWriteOnClose()) {
                ApplicationManager.getApplication().runReadAction(() -> this.myBaseline.close());
            }
            if (this.myBaseline.isWriteOnClose()) {
                String message = this.myBaseline.isRemoveFixed() ? String.format("Updated baseline file %1$s<br>Removed %2$d issues<br>%3$s remaining", this.myBaseline.getFile().getName(), this.myBaseline.getFixedCount(), LintUtils.describeCounts((int)this.myBaseline.getFoundErrorCount(), (int)this.myBaseline.getFoundWarningCount(), (boolean)false, (boolean)true)) : String.format("Created baseline file %1$s<br>%2$d issues will be filtered out", this.myBaseline.getFile().getName(), this.myBaseline.getTotalCount());
                new NotificationGroup("Convert to WebP", NotificationDisplayType.BALLOON, true).createNotification(message, NotificationType.INFORMATION).notify(context.getProject());
            }
        }
    }

    public void cleanup() {
        if (this.myEnabledIssue != null) {
            this.myEnabledIssue.setEnabledByDefault(false);
            this.myEnabledIssue = null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/inspections/lint/AndroidLintGlobalInspectionContext";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalTools";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localTools";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspections";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/inspections/lint/AndroidLintGlobalInspectionContext";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "performPreRunActivities";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "performPostRunActivities";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

