/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections;

import com.android.sdklib.SdkVersionInfo;
import com.android.tools.idea.lint.LintIdeClient;
import com.android.tools.idea.lint.LintIdeUtils;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.lint.checks.ApiLookup;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.inspections.AndroidDeprecationInspection;
import org.jetbrains.android.inspections.VersionChecks;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidDeprecationFilter
extends AndroidDeprecationInspection.DeprecationFilter {
    private static final String ACTION_BAR_ACTIVITY = "android.support.v7.app.ActionBarActivity";
    private static final String APP_COMPAT_ACTIVITY = "android.support.v7.app.AppCompatActivity";

    private static int getDeprecatedIn(@Nullable Project project, @NotNull PsiElement deprecatedElement) {
        String owner;
        PsiClass containingClass;
        if (deprecatedElement == null) {
            AndroidDeprecationFilter.$$$reportNull$$$0(0);
        }
        if (project == null) {
            return -1;
        }
        ApiLookup apiLookup = LintIdeClient.getApiLookup(project);
        if (apiLookup == null) {
            return -1;
        }
        if (deprecatedElement instanceof PsiClass) {
            String owner2 = LintIdeUtils.getInternalName((PsiClass)deprecatedElement);
            if (owner2 != null) {
                return apiLookup.getClassDeprecatedIn(owner2);
            }
        } else if (deprecatedElement instanceof PsiMember && (containingClass = ((PsiMember)deprecatedElement).getContainingClass()) != null && (owner = LintIdeUtils.getInternalName(containingClass)) != null) {
            if (deprecatedElement instanceof PsiField) {
                String name = ((PsiField)deprecatedElement).getName();
                if (name != null) {
                    return apiLookup.getFieldDeprecatedIn(owner, name);
                }
            } else if (deprecatedElement instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)deprecatedElement;
                String name = LintIdeUtils.getInternalMethodName(method);
                String desc = LintIdeUtils.getInternalDescription(method, false, false);
                if (desc != null) {
                    return apiLookup.getMethodDeprecatedIn(owner, name, desc);
                }
            }
        }
        return -1;
    }

    @Override
    public boolean isExcluded(@NotNull PsiElement deprecatedElement, @NotNull PsiElement referenceElement, @Nullable String symbolName) {
        AndroidFacet facet;
        Project project;
        int deprecatedIn;
        if (deprecatedElement == null) {
            AndroidDeprecationFilter.$$$reportNull$$$0(1);
        }
        if (referenceElement == null) {
            AndroidDeprecationFilter.$$$reportNull$$$0(2);
        }
        if ((deprecatedIn = AndroidDeprecationFilter.getDeprecatedIn(project = referenceElement.getProject(), deprecatedElement)) != -1 && (facet = AndroidFacet.getInstance(referenceElement)) != null && !facet.isDisposed() && AndroidModuleInfo.getInstance(facet).getMinSdkVersion().getApiLevel() < deprecatedIn) {
            return !VersionChecks.isPrecededByVersionCheckExit(referenceElement, deprecatedIn) && !VersionChecks.isWithinVersionCheckConditional(referenceElement, deprecatedIn);
        }
        return false;
    }

    @Override
    @NotNull
    public String getDeprecationMessage(@NotNull PsiElement deprecatedElement, @NotNull PsiElement referenceElement, @Nullable String symbolName, @NotNull String defaultMessage) {
        if (deprecatedElement == null) {
            AndroidDeprecationFilter.$$$reportNull$$$0(3);
        }
        if (referenceElement == null) {
            AndroidDeprecationFilter.$$$reportNull$$$0(4);
        }
        if (defaultMessage == null) {
            AndroidDeprecationFilter.$$$reportNull$$$0(5);
        }
        if (ACTION_BAR_ACTIVITY.equals(symbolName)) {
            if ("ActionBarActivity is deprecated; use `AppCompatActivity` instead" == null) {
                AndroidDeprecationFilter.$$$reportNull$$$0(6);
            }
            return "ActionBarActivity is deprecated; use `AppCompatActivity` instead";
        }
        int version = AndroidDeprecationFilter.getDeprecatedIn(referenceElement.getProject(), deprecatedElement);
        if (version != -1) {
            String string = defaultMessage + " as of " + SdkVersionInfo.getAndroidName((int)version);
            if (string == null) {
                AndroidDeprecationFilter.$$$reportNull$$$0(7);
            }
            return string;
        }
        String string = defaultMessage;
        if (string == null) {
            AndroidDeprecationFilter.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Override
    @NotNull
    public LocalQuickFix[] getQuickFixes(@NotNull PsiElement deprecatedElement, @NotNull PsiElement referenceElement, @Nullable String symbolName) {
        if (deprecatedElement == null) {
            AndroidDeprecationFilter.$$$reportNull$$$0(9);
        }
        if (referenceElement == null) {
            AndroidDeprecationFilter.$$$reportNull$$$0(10);
        }
        if (ACTION_BAR_ACTIVITY.equals(symbolName)) {
            LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new ReplaceSuperClassFix(referenceElement, APP_COMPAT_ACTIVITY)};
            if (localQuickFixArray == null) {
                AndroidDeprecationFilter.$$$reportNull$$$0(11);
            }
            return localQuickFixArray;
        }
        if (LocalQuickFix.EMPTY_ARRAY == null) {
            AndroidDeprecationFilter.$$$reportNull$$$0(12);
        }
        return LocalQuickFix.EMPTY_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deprecatedElement";
                break;
            }
            case 2: 
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceElement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultMessage";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/inspections/AndroidDeprecationFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/inspections/AndroidDeprecationFilter";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeprecationMessage";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuickFixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDeprecatedIn";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isExcluded";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDeprecationMessage";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getQuickFixes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ReplaceSuperClassFix
    implements LocalQuickFix {
        private final String myQualifiedName;
        @NotNull
        private final SmartPsiElementPointer<PsiElement> myElement;

        ReplaceSuperClassFix(@NotNull PsiElement element, @NotNull String qualifiedName) {
            if (element == null) {
                ReplaceSuperClassFix.$$$reportNull$$$0(0);
            }
            if (qualifiedName == null) {
                ReplaceSuperClassFix.$$$reportNull$$$0(1);
            }
            this.myQualifiedName = qualifiedName;
            this.myElement = SmartPointerManager.getInstance((Project)element.getProject()).createSmartPsiElementPointer(element);
        }

        @Nls
        @NotNull
        public String getName() {
            String string = "Replace With " + this.myQualifiedName.substring(this.myQualifiedName.lastIndexOf(46) + 1);
            if (string == null) {
                ReplaceSuperClassFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            if ("Replace deprecated code" == null) {
                ReplaceSuperClassFix.$$$reportNull$$$0(3);
            }
            return "Replace deprecated code";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement replace;
            if (project == null) {
                ReplaceSuperClassFix.$$$reportNull$$$0(4);
            }
            if (descriptor == null) {
                ReplaceSuperClassFix.$$$reportNull$$$0(5);
            }
            if ((replace = this.myElement.getElement()) == null) {
                return;
            }
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
            PsiElementFactory elementFactory = facade.getElementFactory();
            PsiJavaCodeReferenceElement newReference = elementFactory.createReferenceFromText(this.myQualifiedName, replace);
            newReference = replace.replace((PsiElement)newReference);
            JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)newReference);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qualifiedName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/android/inspections/AndroidDeprecationFilter$ReplaceSuperClassFix";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/android/inspections/AndroidDeprecationFilter$ReplaceSuperClassFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

