/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.facet;

import com.android.builder.model.SourceProvider;
import com.google.common.collect.Sets;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.annotations.NotNull;

class LegacySourceProvider
implements SourceProvider {
    @NotNull
    private final AndroidFacet myAndroidFacet;

    LegacySourceProvider(@NotNull AndroidFacet androidFacet) {
        if (androidFacet == null) {
            LegacySourceProvider.$$$reportNull$$$0(0);
        }
        this.myAndroidFacet = androidFacet;
    }

    @NotNull
    public String getName() {
        if ("main" == null) {
            LegacySourceProvider.$$$reportNull$$$0(1);
        }
        return "main";
    }

    @NotNull
    public File getManifestFile() {
        Module module = this.myAndroidFacet.getModule();
        VirtualFile manifestFile = AndroidRootUtil.getFileByRelativeModulePath(module, this.myAndroidFacet.getProperties().MANIFEST_FILE_RELATIVE_PATH, true);
        if (manifestFile == null) {
            VirtualFile root;
            VirtualFile virtualFile = root = !this.myAndroidFacet.requiresAndroidModel() ? AndroidRootUtil.getMainContentRoot(this.myAndroidFacet) : null;
            if (root != null) {
                File file = new File(VfsUtilCore.virtualToIoFile((VirtualFile)root), "AndroidManifest.xml");
                if (file == null) {
                    LegacySourceProvider.$$$reportNull$$$0(2);
                }
                return file;
            }
            File file = new File("AndroidManifest.xml");
            if (file == null) {
                LegacySourceProvider.$$$reportNull$$$0(3);
            }
            return file;
        }
        File file = VfsUtilCore.virtualToIoFile((VirtualFile)manifestFile);
        if (file == null) {
            LegacySourceProvider.$$$reportNull$$$0(4);
        }
        return file;
    }

    @NotNull
    public Set<File> getJavaDirectories() {
        HashSet dirs = Sets.newHashSet();
        Module module = this.myAndroidFacet.getModule();
        VirtualFile[] contentRoots = ModuleRootManager.getInstance((Module)module).getContentRoots();
        if (contentRoots.length != 0) {
            for (VirtualFile root : contentRoots) {
                dirs.add(VfsUtilCore.virtualToIoFile((VirtualFile)root));
            }
        }
        HashSet hashSet = dirs;
        if (hashSet == null) {
            LegacySourceProvider.$$$reportNull$$$0(5);
        }
        return hashSet;
    }

    @NotNull
    public Set<File> getResourcesDirectories() {
        Set<File> set = Collections.emptySet();
        if (set == null) {
            LegacySourceProvider.$$$reportNull$$$0(6);
        }
        return set;
    }

    @NotNull
    public Set<File> getAidlDirectories() {
        VirtualFile dir = AndroidRootUtil.getAidlGenDir(this.myAndroidFacet);
        Set<File> set = dir == null ? Collections.emptySet() : Collections.singleton(VfsUtilCore.virtualToIoFile((VirtualFile)dir));
        if (set == null) {
            LegacySourceProvider.$$$reportNull$$$0(7);
        }
        return set;
    }

    @NotNull
    public Set<File> getRenderscriptDirectories() {
        VirtualFile dir = AndroidRootUtil.getRenderscriptGenDir(this.myAndroidFacet);
        Set<File> set = dir == null ? Collections.emptySet() : Collections.singleton(VfsUtilCore.virtualToIoFile((VirtualFile)dir));
        if (set == null) {
            LegacySourceProvider.$$$reportNull$$$0(8);
        }
        return set;
    }

    @NotNull
    public Set<File> getResDirectories() {
        String resRelPath = this.myAndroidFacet.getProperties().RES_FOLDER_RELATIVE_PATH;
        VirtualFile dir = AndroidRootUtil.getFileByRelativeModulePath(this.myAndroidFacet.getModule(), resRelPath, true);
        Set<File> set = dir == null ? Collections.emptySet() : Collections.singleton(VfsUtilCore.virtualToIoFile((VirtualFile)dir));
        if (set == null) {
            LegacySourceProvider.$$$reportNull$$$0(9);
        }
        return set;
    }

    @NotNull
    public Set<File> getAssetsDirectories() {
        VirtualFile dir = AndroidRootUtil.getAssetsDir(this.myAndroidFacet);
        Set<File> set = dir == null ? Collections.emptySet() : Collections.singleton(VfsUtilCore.virtualToIoFile((VirtualFile)dir));
        if (set == null) {
            LegacySourceProvider.$$$reportNull$$$0(10);
        }
        return set;
    }

    @NotNull
    public Collection<File> getJniLibsDirectories() {
        List<File> list = Collections.emptyList();
        if (list == null) {
            LegacySourceProvider.$$$reportNull$$$0(11);
        }
        return list;
    }

    @NotNull
    public Collection<File> getShadersDirectories() {
        List<File> list = Collections.emptyList();
        if (list == null) {
            LegacySourceProvider.$$$reportNull$$$0(12);
        }
        return list;
    }

    @NotNull
    public Collection<File> getCDirectories() {
        List<File> list = Collections.emptyList();
        if (list == null) {
            LegacySourceProvider.$$$reportNull$$$0(13);
        }
        return list;
    }

    @NotNull
    public Collection<File> getCppDirectories() {
        List<File> list = Collections.emptyList();
        if (list == null) {
            LegacySourceProvider.$$$reportNull$$$0(14);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidFacet";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/facet/LegacySourceProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/facet/LegacySourceProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getManifestFile";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getJavaDirectories";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourcesDirectories";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAidlDirectories";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getRenderscriptDirectories";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getResDirectories";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getAssetsDirectories";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getJniLibsDirectories";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getShadersDirectories";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getCDirectories";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getCppDirectories";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

