/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.exportSignedPackage;

import com.intellij.credentialStore.CredentialAttributesKt;
import com.intellij.credentialStore.Credentials;
import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.ide.wizard.CommitStepException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.jetbrains.android.compiler.artifact.ApkSigningSettingsForm;
import org.jetbrains.android.exportSignedPackage.ExportSignedPackageWizard;
import org.jetbrains.android.exportSignedPackage.ExportSignedPackageWizardStep;
import org.jetbrains.android.exportSignedPackage.GenerateSignedApkSettings;
import org.jetbrains.android.exportSignedPackage.GradleSigningInfo;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidUiUtil;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class KeystoreStep
extends ExportSignedPackageWizardStep
implements ApkSigningSettingsForm {
    static final String KEY_STORE_PASSWORD_KEY = "KEY_STORE_PASSWORD";
    static final String KEY_PASSWORD_KEY = "KEY_PASSWORD";
    private JPanel myContentPanel;
    private JPasswordField myKeyStorePasswordField;
    private JPasswordField myKeyPasswordField;
    private TextFieldWithBrowseButton.NoPathCompletion myKeyAliasField;
    private JTextField myKeyStorePathField;
    private JButton myCreateKeyStoreButton;
    private JButton myLoadKeyStoreButton;
    private JBCheckBox myRememberPasswordCheckBox;
    private final ExportSignedPackageWizard myWizard;
    private final boolean myUseGradleForSigning;

    KeystoreStep(ExportSignedPackageWizard wizard, boolean useGradleForSigning) {
        this.myWizard = wizard;
        this.myUseGradleForSigning = useGradleForSigning;
        this.$$$setupUI$$$();
        Project project = wizard.getProject();
        GenerateSignedApkSettings settings = GenerateSignedApkSettings.getInstance(project);
        this.myKeyStorePathField.setText(settings.KEY_STORE_PATH);
        this.myKeyAliasField.setText(settings.KEY_ALIAS);
        this.myRememberPasswordCheckBox.setSelected(settings.REMEMBER_PASSWORDS);
        if (settings.REMEMBER_PASSWORDS) {
            String keyPasswordKey;
            String keyStorePasswordKey = KeystoreStep.makePasswordKey(KEY_STORE_PASSWORD_KEY, settings.KEY_STORE_PATH, null);
            String password = KeystoreStep.retrievePassword(KeyStorePasswordRequestor.class, keyStorePasswordKey);
            if (password != null) {
                this.myKeyStorePasswordField.setText(password);
            }
            if ((password = KeystoreStep.retrievePassword(KeyPasswordRequestor.class, keyPasswordKey = KeystoreStep.makePasswordKey(KEY_PASSWORD_KEY, settings.KEY_STORE_PATH, settings.KEY_ALIAS))) != null) {
                this.myKeyPasswordField.setText(password);
            }
        }
        AndroidUiUtil.initSigningSettingsForm(project, this);
    }

    private static String retrievePassword(@NotNull Class<?> primaryRequestor, @NotNull String key) {
        PasswordSafe passwordSafe;
        String password;
        if (primaryRequestor == null) {
            KeystoreStep.$$$reportNull$$$0(0);
        }
        if (key == null) {
            KeystoreStep.$$$reportNull$$$0(1);
        }
        if ((password = (passwordSafe = PasswordSafe.getInstance()).getPassword(CredentialAttributesKt.CredentialAttributes(primaryRequestor, (String)key))) == null) {
            password = passwordSafe.getPassword(CredentialAttributesKt.CredentialAttributes(KeystoreStep.class, (String)key));
        }
        return password;
    }

    private static void updateSavedPassword(@NotNull Class<?> primaryRequestor, @NotNull String key, @Nullable String value) {
        if (primaryRequestor == null) {
            KeystoreStep.$$$reportNull$$$0(2);
        }
        if (key == null) {
            KeystoreStep.$$$reportNull$$$0(3);
        }
        PasswordSafe passwordSafe = PasswordSafe.getInstance();
        passwordSafe.set(CredentialAttributesKt.CredentialAttributes(primaryRequestor, (String)key), value == null ? null : new Credentials(key, value));
        passwordSafe.set(CredentialAttributesKt.CredentialAttributes(KeystoreStep.class, (String)key), null == null ? null : new Credentials(key, (String)null));
    }

    static String makePasswordKey(@NotNull String prefix, @NotNull String keyStorePath, @Nullable String keyAlias2) {
        if (prefix == null) {
            KeystoreStep.$$$reportNull$$$0(4);
        }
        if (keyStorePath == null) {
            KeystoreStep.$$$reportNull$$$0(5);
        }
        return prefix + "__" + keyStorePath + (keyAlias2 != null ? "__" + keyAlias2 : "");
    }

    public JComponent getPreferredFocusedComponent() {
        if (this.myKeyStorePathField.getText().isEmpty()) {
            return this.myKeyStorePathField;
        }
        if (this.myKeyStorePasswordField.getPassword().length == 0) {
            return this.myKeyStorePasswordField;
        }
        if (this.myKeyAliasField.getText().isEmpty()) {
            return this.myKeyAliasField;
        }
        if (this.myKeyPasswordField.getPassword().length == 0) {
            return this.myKeyPasswordField;
        }
        return null;
    }

    public JComponent getComponent() {
        return this.myContentPanel;
    }

    @Override
    public String getHelpId() {
        return "reference.android.reference.extract.signed.package.specify.keystore";
    }

    @Override
    protected void commitForNext() throws CommitStepException {
        boolean rememberPasswords;
        String keyStoreLocation = this.myKeyStorePathField.getText().trim();
        if (keyStoreLocation.isEmpty()) {
            throw new CommitStepException(AndroidBundle.message("android.export.package.specify.keystore.location.error", new Object[0]));
        }
        char[] keyStorePassword = this.myKeyStorePasswordField.getPassword();
        if (keyStorePassword.length == 0) {
            throw new CommitStepException(AndroidBundle.message("android.export.package.specify.key.store.password.error", new Object[0]));
        }
        String keyAlias2 = this.myKeyAliasField.getText().trim();
        if (keyAlias2.isEmpty()) {
            throw new CommitStepException(AndroidBundle.message("android.export.package.specify.key.alias.error", new Object[0]));
        }
        char[] keyPassword2 = this.myKeyPasswordField.getPassword();
        if (keyPassword2.length == 0) {
            throw new CommitStepException(AndroidBundle.message("android.export.package.specify.key.password.error", new Object[0]));
        }
        if (this.myUseGradleForSigning) {
            this.myWizard.setGradleSigningInfo(new GradleSigningInfo(keyStoreLocation, keyStorePassword, keyAlias2, keyPassword2));
        } else {
            KeyStore keyStore = this.loadKeyStore(new File(keyStoreLocation));
            if (keyStore == null) {
                throw new CommitStepException(AndroidBundle.message("android.export.package.keystore.error.title", new Object[0]));
            }
            this.loadKeyAndSaveToWizard(keyStore, keyAlias2, keyPassword2);
        }
        Project project = this.myWizard.getProject();
        GenerateSignedApkSettings settings = GenerateSignedApkSettings.getInstance(project);
        settings.KEY_STORE_PATH = keyStoreLocation;
        settings.KEY_ALIAS = keyAlias2;
        settings.REMEMBER_PASSWORDS = rememberPasswords = this.myRememberPasswordCheckBox.isSelected();
        String keyStorePasswordKey = KeystoreStep.makePasswordKey(KEY_STORE_PASSWORD_KEY, keyStoreLocation, null);
        String keyPasswordKey = KeystoreStep.makePasswordKey(KEY_PASSWORD_KEY, keyStoreLocation, keyAlias2);
        KeystoreStep.updateSavedPassword(KeyStorePasswordRequestor.class, keyStorePasswordKey, rememberPasswords ? new String(keyStorePassword) : null);
        KeystoreStep.updateSavedPassword(KeyPasswordRequestor.class, keyPasswordKey, rememberPasswords ? new String(keyPassword2) : null);
    }

    private KeyStore loadKeyStore(File keystoreFile) throws CommitStepException {
        KeyStore keyStore;
        char[] password = this.myKeyStorePasswordField.getPassword();
        FileInputStream fis = null;
        AndroidUtils.checkPassword(password);
        if (!keystoreFile.isFile()) {
            throw new CommitStepException(AndroidBundle.message("android.cannot.find.file.error", keystoreFile.getPath()));
        }
        try {
            keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            fis = new FileInputStream(keystoreFile);
            keyStore.load(fis, password);
        }
        catch (Exception e) {
            throw new CommitStepException(e.getMessage());
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
            Arrays.fill(password, '\u0000');
        }
        return keyStore;
    }

    private void loadKeyAndSaveToWizard(KeyStore keyStore, String alias, char[] keyPassword2) throws CommitStepException {
        KeyStore.PrivateKeyEntry entry;
        try {
            assert (keyStore != null);
            entry = (KeyStore.PrivateKeyEntry)keyStore.getEntry(alias, new KeyStore.PasswordProtection(keyPassword2));
        }
        catch (Exception e) {
            throw new CommitStepException("Error: " + e.getMessage());
        }
        if (entry == null) {
            throw new CommitStepException(AndroidBundle.message("android.extract.package.cannot.find.key.error", alias));
        }
        PrivateKey privateKey = entry.getPrivateKey();
        Certificate certificate = entry.getCertificate();
        if (privateKey == null || certificate == null) {
            throw new CommitStepException(AndroidBundle.message("android.extract.package.cannot.find.key.error", alias));
        }
        this.myWizard.setPrivateKey(privateKey);
        this.myWizard.setCertificate((X509Certificate)certificate);
    }

    @Override
    public JButton getLoadKeyStoreButton() {
        return this.myLoadKeyStoreButton;
    }

    @Override
    public JTextField getKeyStorePathField() {
        return this.myKeyStorePathField;
    }

    @Override
    public JPanel getPanel() {
        return this.myContentPanel;
    }

    @Override
    public JButton getCreateKeyStoreButton() {
        return this.myCreateKeyStoreButton;
    }

    @Override
    public JPasswordField getKeyStorePasswordField() {
        return this.myKeyStorePasswordField;
    }

    @Override
    public TextFieldWithBrowseButton getKeyAliasField() {
        return this.myKeyAliasField;
    }

    @Override
    public JPasswordField getKeyPasswordField() {
        return this.myKeyPasswordField;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "primaryRequestor";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyStorePath";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/android/exportSignedPackage/KeystoreStep";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "retrievePassword";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "updateSavedPassword";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "makePasswordKey";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JButton jButton;
        JButton jButton2;
        JTextField jTextField;
        TextFieldWithBrowseButton.NoPathCompletion noPathCompletion;
        JPasswordField jPasswordField;
        JPasswordField jPasswordField2;
        JPanel jPanel;
        this.myContentPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(7, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(6, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Key store path: ");
        jBLabel.setDisplayedMnemonic('K');
        jBLabel.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Key store password:");
        jBLabel2.setDisplayedMnemonic('P');
        jBLabel2.setDisplayedMnemonicIndex(10);
        jPanel.add((Component)jBLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myKeyStorePasswordField = jPasswordField2 = new JPasswordField();
        jPanel.add((Component)jPasswordField2, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Key alias:");
        jBLabel3.setDisplayedMnemonic('E');
        jBLabel3.setDisplayedMnemonicIndex(1);
        jPanel.add((Component)jBLabel3, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel4 = new JBLabel();
        jBLabel4.setText("Key password:");
        jBLabel4.setDisplayedMnemonic('W');
        jBLabel4.setDisplayedMnemonicIndex(8);
        jPanel.add((Component)jBLabel4, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myKeyPasswordField = jPasswordField = new JPasswordField();
        jPanel.add((Component)jPasswordField, new GridConstraints(4, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myKeyAliasField = noPathCompletion = new TextFieldWithBrowseButton.NoPathCompletion();
        jPanel.add((Component)noPathCompletion, new GridConstraints(3, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myKeyStorePathField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myCreateKeyStoreButton = jButton2 = new JButton();
        jButton2.setText("Create new...");
        jButton2.setMnemonic('C');
        jButton2.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jButton2, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myLoadKeyStoreButton = jButton = new JButton();
        jButton.setText("Choose existing...");
        jButton.setMnemonic('H');
        jButton.setDisplayedMnemonicIndex(1);
        jPanel2.add((Component)jButton, new GridConstraints(0, 2, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myRememberPasswordCheckBox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Remember passwords");
        jBCheckBox.setMnemonic('R');
        jBCheckBox.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jBCheckBox, new GridConstraints(5, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        jBLabel.setLabelFor(jTextField);
        jBLabel2.setLabelFor(jPasswordField2);
        jBLabel3.setLabelFor((Component)noPathCompletion);
        jBLabel4.setLabelFor(jPasswordField);
        ButtonGroup buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPanel;
    }

    private static class KeyPasswordRequestor {
        private KeyPasswordRequestor() {
        }
    }

    private static class KeyStorePasswordRequestor {
        private KeyStorePasswordRequestor() {
        }
    }
}

