/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.exportSignedPackage;

import com.android.builder.model.AndroidProject;
import com.android.builder.model.Variant;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.gradle.actions.GoToApkLocationTask;
import com.android.tools.idea.gradle.project.build.invoker.GradleBuildInvoker;
import com.android.tools.idea.gradle.project.build.invoker.GradleTaskFinder;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacetConfiguration;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.util.AndroidGradleSettings;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.CommonBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.ide.actions.ShowFilePathAction;
import com.intellij.ide.wizard.AbstractWizard;
import com.intellij.ide.wizard.CommitStepException;
import com.intellij.ide.wizard.Step;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.GuiUtils;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.android.AndroidCommonBundle;
import org.jetbrains.android.compiler.AndroidCompileUtil;
import org.jetbrains.android.exportSignedPackage.ApkStep;
import org.jetbrains.android.exportSignedPackage.ChooseModuleStep;
import org.jetbrains.android.exportSignedPackage.ExportSignedPackageWizardStep;
import org.jetbrains.android.exportSignedPackage.GradleSignStep;
import org.jetbrains.android.exportSignedPackage.GradleSigningInfo;
import org.jetbrains.android.exportSignedPackage.KeystoreStep;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.annotations.NotNull;

public class ExportSignedPackageWizard
extends AbstractWizard<ExportSignedPackageWizardStep> {
    private static final Logger LOG = Logger.getInstance(ExportSignedPackageWizard.class);
    @NotNull
    private final Project myProject;
    private AndroidFacet myFacet;
    private PrivateKey myPrivateKey;
    private X509Certificate myCertificate;
    private boolean mySigned;
    private CompileScope myCompileScope;
    private String myApkPath;
    private boolean myV1Signature;
    private boolean myV2Signature;
    private String myBuildType;
    private List<String> myFlavors;
    private GradleSigningInfo myGradleSigningInfo;

    public ExportSignedPackageWizard(@NotNull Project project, @NotNull List<AndroidFacet> facets, boolean signed) {
        if (project == null) {
            ExportSignedPackageWizard.$$$reportNull$$$0(0);
        }
        if (facets == null) {
            ExportSignedPackageWizard.$$$reportNull$$$0(1);
        }
        super(AndroidBundle.message("android.export.package.wizard.title", new Object[0]), project);
        this.myProject = project;
        this.mySigned = signed;
        assert (!facets.isEmpty());
        if (facets.size() > 1 || SystemInfo.isMac) {
            this.addStep((Step)new ChooseModuleStep(this, facets));
        } else {
            this.myFacet = facets.get(0);
        }
        boolean useGradleToSign = facets.get(0).requiresAndroidModel();
        if (signed) {
            this.addStep((Step)new KeystoreStep(this, useGradleToSign));
        }
        if (useGradleToSign) {
            this.addStep((Step)new GradleSignStep(this));
        } else {
            this.addStep((Step)new ApkStep(this));
        }
        this.init();
    }

    public boolean isSigned() {
        return this.mySigned;
    }

    protected void doOKAction() {
        if (!this.commitCurrentStep()) {
            return;
        }
        super.doOKAction();
        assert (this.myFacet != null);
        if (this.myFacet.requiresAndroidModel()) {
            this.buildAndSignGradleProject();
        } else {
            this.buildAndSignIntellijProject();
        }
    }

    private void buildAndSignIntellijProject() {
        CompilerManager.getInstance((Project)this.myProject).make(this.myCompileScope, (aborted, errors, warnings, compileContext) -> {
            if (aborted || errors != 0) {
                return;
            }
            String title = AndroidBundle.message("android.extract.package.task.title", new Object[0]);
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, title, true, null){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    ExportSignedPackageWizard.this.createAndAlignApk(ExportSignedPackageWizard.this.myApkPath);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/android/exportSignedPackage/ExportSignedPackageWizard$1", "run"));
                }
            });
        });
    }

    private void buildAndSignGradleProject() {
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, "Generating Signed APKs", false, null){

            public void run(@NotNull ProgressIndicator indicator) {
                GradleFacet gradleFacet;
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((gradleFacet = GradleFacet.getInstance(ExportSignedPackageWizard.this.myFacet.getModule())) == null) {
                    LOG.error("Unable to get gradle project information for module: " + ExportSignedPackageWizard.this.myFacet.getModule().getName());
                    return;
                }
                String gradleProjectPath = ((GradleFacetConfiguration)gradleFacet.getConfiguration()).GRADLE_PROJECT_PATH;
                String rootProjectPath = ExternalSystemApiUtil.getExternalRootProjectPath((Module)ExportSignedPackageWizard.this.myFacet.getModule());
                if (StringUtil.isEmpty((String)rootProjectPath)) {
                    LOG.error("Unable to get gradle root project path for module: " + ExportSignedPackageWizard.this.myFacet.getModule().getName());
                    return;
                }
                AndroidModuleModel androidModel = AndroidModuleModel.get(ExportSignedPackageWizard.this.myFacet);
                if (androidModel == null) {
                    LOG.error("Unable to obtain Android project model. Did the last Gradle sync complete successfully?");
                    return;
                }
                List<String> assembleTasks = ExportSignedPackageWizard.getAssembleTasks(gradleProjectPath, (AndroidProject)androidModel.getAndroidProject(), ExportSignedPackageWizard.this.myBuildType, ExportSignedPackageWizard.this.myFlavors);
                ArrayList projectProperties = Lists.newArrayList();
                projectProperties.add(this.createProperty("android.injected.signing.store.file", ((ExportSignedPackageWizard)ExportSignedPackageWizard.this).myGradleSigningInfo.keyStoreFilePath));
                projectProperties.add(this.createProperty("android.injected.signing.store.password", new String(((ExportSignedPackageWizard)ExportSignedPackageWizard.this).myGradleSigningInfo.keyStorePassword)));
                projectProperties.add(this.createProperty("android.injected.signing.key.alias", ((ExportSignedPackageWizard)ExportSignedPackageWizard.this).myGradleSigningInfo.keyAlias));
                projectProperties.add(this.createProperty("android.injected.signing.key.password", new String(((ExportSignedPackageWizard)ExportSignedPackageWizard.this).myGradleSigningInfo.keyPassword)));
                projectProperties.add(this.createProperty("android.injected.apk.location", ExportSignedPackageWizard.this.myApkPath));
                projectProperties.add(this.createProperty("android.injected.signing.v1-enabled", Boolean.toString(ExportSignedPackageWizard.this.myV1Signature)));
                projectProperties.add(this.createProperty("android.injected.signing.v2-enabled", Boolean.toString(ExportSignedPackageWizard.this.myV2Signature)));
                Map<Module, File> appModulesToOutputs = Collections.singletonMap(ExportSignedPackageWizard.this.myFacet.getModule(), ExportSignedPackageWizard.getApkLocation(ExportSignedPackageWizard.this.myApkPath, ExportSignedPackageWizard.this.myBuildType));
                assert (this.myProject != null);
                GradleBuildInvoker gradleBuildInvoker = GradleBuildInvoker.getInstance(this.myProject);
                gradleBuildInvoker.add(new GoToApkLocationTask(appModulesToOutputs, "Generate Signed APK"));
                gradleBuildInvoker.executeTasks(new File(rootProjectPath), assembleTasks, projectProperties);
                LOG.info("Export APK command: " + Joiner.on((char)',').join(assembleTasks) + ", destination: " + this.createProperty("android.injected.apk.location", ExportSignedPackageWizard.this.myApkPath));
            }

            private String createProperty(@NotNull String name, @NotNull String value) {
                if (name == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (value == null) {
                    2.$$$reportNull$$$0(2);
                }
                return AndroidGradleSettings.createProjectProperty((String)name, (String)value);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "indicator";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "name";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "value";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/android/exportSignedPackage/ExportSignedPackageWizard$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "run";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "createProperty";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @NotNull
    public static File getApkLocation(@NotNull String apkFolderPath, @NotNull String buildType) {
        if (apkFolderPath == null) {
            ExportSignedPackageWizard.$$$reportNull$$$0(2);
        }
        if (buildType == null) {
            ExportSignedPackageWizard.$$$reportNull$$$0(3);
        }
        File file = new File(apkFolderPath, buildType);
        if (file == null) {
            ExportSignedPackageWizard.$$$reportNull$$$0(4);
        }
        return file;
    }

    @NotNull
    public static List<String> getAssembleTasks(String gradleProjectPath, AndroidProject androidProject, String buildType, List<String> flavors) {
        HashMap variantsByFlavor = Maps.newHashMapWithExpectedSize((int)flavors.size());
        for (Variant v : androidProject.getVariants()) {
            if (!v.getBuildType().equals(buildType)) continue;
            variantsByFlavor.put(ExportSignedPackageWizard.getMergedFlavorName(v), v);
        }
        if (flavors.isEmpty()) {
            Variant v = (Variant)variantsByFlavor.get("");
            if (v != null) {
                String taskName = v.getMainArtifact().getAssembleTaskName();
                List<String> list = Collections.singletonList(GradleTaskFinder.getInstance().createBuildTask(gradleProjectPath, taskName));
                if (list == null) {
                    ExportSignedPackageWizard.$$$reportNull$$$0(5);
                }
                return list;
            }
            LOG.error("Unable to find default variant");
            List<String> list = Collections.emptyList();
            if (list == null) {
                ExportSignedPackageWizard.$$$reportNull$$$0(6);
            }
            return list;
        }
        ArrayList assembleTasks = Lists.newArrayListWithExpectedSize((int)flavors.size());
        for (String flavor : flavors) {
            Variant v = (Variant)variantsByFlavor.get(flavor);
            if (v == null) continue;
            String taskName = v.getMainArtifact().getAssembleTaskName();
            assembleTasks.add(GradleTaskFinder.getInstance().createBuildTask(gradleProjectPath, taskName));
        }
        ArrayList arrayList = assembleTasks;
        if (arrayList == null) {
            ExportSignedPackageWizard.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    public static String getMergedFlavorName(Variant variant) {
        return Joiner.on((char)'-').join((Iterable)variant.getProductFlavors());
    }

    protected void doNextAction() {
        if (!this.commitCurrentStep()) {
            return;
        }
        super.doNextAction();
    }

    private boolean commitCurrentStep() {
        try {
            ((ExportSignedPackageWizardStep)((Object)this.mySteps.get(this.myCurrentStep))).commitForNext();
        }
        catch (CommitStepException e) {
            Messages.showErrorDialog((Component)this.getContentPane(), (String)e.getMessage());
            return false;
        }
        return true;
    }

    protected int getNextStep(int stepIndex) {
        int result = super.getNextStep(stepIndex);
        if (result != this.myCurrentStep) {
            ((ExportSignedPackageWizardStep)((Object)this.mySteps.get(result))).setPreviousStepIndex(this.myCurrentStep);
        }
        return result;
    }

    protected int getPreviousStep(int stepIndex) {
        ExportSignedPackageWizardStep step = (ExportSignedPackageWizardStep)((Object)this.mySteps.get(stepIndex));
        int prevStepIndex = step.getPreviousStepIndex();
        assert (prevStepIndex >= 0);
        return prevStepIndex;
    }

    protected void updateStep() {
        int step = this.getCurrentStep();
        ExportSignedPackageWizardStep currentStep = (ExportSignedPackageWizardStep)((Object)this.mySteps.get(step));
        this.getFinishButton().setEnabled(currentStep.canFinish());
        super.updateStep();
        UIUtil.invokeLaterIfNeeded(() -> {
            this.getRootPane().setDefaultButton(this.getNextButton());
            JComponent component2 = currentStep.getPreferredFocusedComponent();
            if (component2 != null) {
                component2.requestFocus();
            }
        });
    }

    protected String getHelpID() {
        ExportSignedPackageWizardStep step = (ExportSignedPackageWizardStep)this.getCurrentStepObject();
        if (step != null) {
            return step.getHelpId();
        }
        return null;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            ExportSignedPackageWizard.$$$reportNull$$$0(8);
        }
        return project;
    }

    public void setFacet(@NotNull AndroidFacet facet) {
        if (facet == null) {
            ExportSignedPackageWizard.$$$reportNull$$$0(9);
        }
        this.myFacet = facet;
    }

    public AndroidFacet getFacet() {
        return this.myFacet;
    }

    public void setPrivateKey(@NotNull PrivateKey privateKey) {
        if (privateKey == null) {
            ExportSignedPackageWizard.$$$reportNull$$$0(10);
        }
        this.myPrivateKey = privateKey;
    }

    public void setCertificate(@NotNull X509Certificate certificate) {
        if (certificate == null) {
            ExportSignedPackageWizard.$$$reportNull$$$0(11);
        }
        this.myCertificate = certificate;
    }

    public PrivateKey getPrivateKey() {
        return this.myPrivateKey;
    }

    public X509Certificate getCertificate() {
        return this.myCertificate;
    }

    public void setCompileScope(@NotNull CompileScope compileScope) {
        if (compileScope == null) {
            ExportSignedPackageWizard.$$$reportNull$$$0(12);
        }
        this.myCompileScope = compileScope;
    }

    public void setApkPath(@NotNull String apkPath) {
        if (apkPath == null) {
            ExportSignedPackageWizard.$$$reportNull$$$0(13);
        }
        this.myApkPath = apkPath;
    }

    public void setV1Signature(boolean v1Signature) {
        this.myV1Signature = v1Signature;
    }

    public void setV2Signature(boolean v2Signature) {
        this.myV2Signature = v2Signature;
    }

    public void setGradleOptions(String buildType, @NotNull List<String> flavors) {
        if (flavors == null) {
            ExportSignedPackageWizard.$$$reportNull$$$0(14);
        }
        this.myBuildType = buildType;
        this.myFlavors = flavors;
    }

    private void createAndAlignApk(String apkPath) {
        File realDestFile;
        String message;
        BuildToolInfo buildTool;
        AndroidPlatform platform = ((AndroidFacetConfiguration)this.getFacet().getConfiguration()).getAndroidPlatform();
        assert (platform != null);
        String sdkPath = platform.getSdkData().getLocation().getPath();
        String zipAlignPath = AndroidCommonUtils.getZipAlign((String)sdkPath, (IAndroidTarget)platform.getTarget());
        File zipalign = new File(zipAlignPath);
        if (!zipalign.isFile() && (buildTool = platform.getTarget().getBuildToolInfo()) != null) {
            zipAlignPath = buildTool.getPath(BuildToolInfo.PathId.ZIP_ALIGN);
            zipalign = new File(zipAlignPath);
        }
        boolean runZipAlign = zipalign.isFile();
        File destFile = null;
        try {
            destFile = runZipAlign ? FileUtil.createTempFile((String)"android", (String)".apk") : new File(apkPath);
            this.createApk(destFile);
        }
        catch (Exception e) {
            this.showErrorInDispatchThread(e.getMessage());
        }
        if (destFile == null) {
            return;
        }
        if (runZipAlign && (message = AndroidCommonUtils.executeZipAlign((String)zipAlignPath, (File)destFile, (File)(realDestFile = new File(apkPath)))) != null) {
            this.showErrorInDispatchThread(message);
            return;
        }
        GuiUtils.invokeLaterIfNeeded(() -> {
            String title = AndroidBundle.message("android.export.package.wizard.title", new Object[0]);
            Project project = this.getProject();
            File apkFile = new File(apkPath);
            VirtualFile vApkFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(apkFile);
            if (vApkFile != null) {
                vApkFile.refresh(true, false);
            }
            if (!runZipAlign) {
                Messages.showWarningDialog((Project)project, (String)AndroidCommonBundle.message((String)"android.artifact.building.cannot.find.zip.align.error", (Object[])new Object[0]), (String)title);
            }
            if (ShowFilePathAction.isSupported()) {
                if (Messages.showOkCancelDialog((Project)project, (String)AndroidBundle.message("android.export.package.success.message", apkFile.getName()), (String)title, (String)RevealFileAction.getActionName(), (String)IdeBundle.message((String)"action.close", (Object[])new Object[0]), (Icon)Messages.getInformationIcon()) == 0) {
                    ShowFilePathAction.openFile((File)apkFile);
                }
            } else {
                Messages.showInfoMessage((Project)project, (String)AndroidBundle.message("android.export.package.success.message", apkFile), (String)title);
            }
        }, (ModalityState)ModalityState.defaultModalityState());
    }

    private void createApk(@NotNull File destFile) throws IOException, GeneralSecurityException {
        if (destFile == null) {
            ExportSignedPackageWizard.$$$reportNull$$$0(15);
        }
        String srcApkPath = AndroidCompileUtil.getUnsignedApkPath(this.getFacet());
        assert (srcApkPath != null);
        File srcApk = new File(FileUtil.toSystemDependentName((String)srcApkPath));
        if (this.isSigned()) {
            AndroidCommonUtils.signApk((File)srcApk, (File)destFile, (PrivateKey)this.getPrivateKey(), (X509Certificate)this.getCertificate());
        } else {
            FileUtil.copy((File)srcApk, (File)destFile);
        }
    }

    private void showErrorInDispatchThread(@NotNull String message) {
        if (message == null) {
            ExportSignedPackageWizard.$$$reportNull$$$0(16);
        }
        UIUtil.invokeLaterIfNeeded(() -> {
            if (message == null) {
                ExportSignedPackageWizard.$$$reportNull$$$0(17);
            }
            Messages.showErrorDialog((Project)this.getProject(), (String)("Error: " + message), (String)CommonBundle.getErrorTitle());
        });
    }

    public void setGradleSigningInfo(GradleSigningInfo gradleSigningInfo) {
        this.myGradleSigningInfo = gradleSigningInfo;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facets";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "apkFolderPath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildType";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/exportSignedPackage/ExportSignedPackageWizard";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "privateKey";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "certificate";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compileScope";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "apkPath";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flavors";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destFile";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/exportSignedPackage/ExportSignedPackageWizard";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getApkLocation";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAssembleTasks";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getApkLocation";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setFacet";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setPrivateKey";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setCertificate";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setCompileScope";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setApkPath";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setGradleOptions";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createApk";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "showErrorInDispatchThread";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "lambda$showErrorInDispatchThread$3";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

