/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.exportSignedPackage;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.wizard.CommitStepException;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import org.jetbrains.android.exportSignedPackage.CheckModulePanel;
import org.jetbrains.android.exportSignedPackage.ExportSignedPackageWizard;
import org.jetbrains.android.exportSignedPackage.ExportSignedPackageWizardStep;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidBundle;

class ChooseModuleStep
extends ExportSignedPackageWizardStep {
    public static final String MODULE_PROPERTY = "ExportedModule";
    private JComboBox myModuleCombo;
    private JPanel myContentPanel;
    private CheckModulePanel myCheckModulePanel;
    private final ExportSignedPackageWizard myWizard;

    protected ChooseModuleStep(ExportSignedPackageWizard wizard, List<AndroidFacet> facets) {
        this.myWizard = wizard;
        this.$$$setupUI$$$();
        assert (!facets.isEmpty());
        AndroidFacet selection = facets.get(0);
        String module = PropertiesComponent.getInstance((Project)wizard.getProject()).getValue(MODULE_PROPERTY);
        if (module != null) {
            for (AndroidFacet facet : facets) {
                if (!module.equals(facet.getModule().getName())) continue;
                selection = facet;
                break;
            }
        }
        this.myModuleCombo.setModel(new CollectionComboBoxModel(facets, (Object)selection));
        this.myModuleCombo.setRenderer(new ListCellRendererWrapper<AndroidFacet>(){

            public void customize(JList list, AndroidFacet value, int index, boolean selected, boolean hasFocus) {
                Module module = value.getModule();
                this.setText(module.getName());
                this.setIcon(ModuleType.get((Module)module).getIcon());
            }
        });
        this.myModuleCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChooseModuleStep.this.myCheckModulePanel.updateMessages(ChooseModuleStep.this.getSelectedFacet());
            }
        });
        this.myCheckModulePanel.updateMessages(this.getSelectedFacet());
    }

    private AndroidFacet getSelectedFacet() {
        return (AndroidFacet)((Object)this.myModuleCombo.getSelectedItem());
    }

    @Override
    public String getHelpId() {
        return "reference.android.reference.extract.signed.package.choose.module";
    }

    @Override
    protected void commitForNext() throws CommitStepException {
        if (this.myCheckModulePanel.hasError()) {
            throw new CommitStepException(AndroidBundle.message("android.project.contains.errors.error", new Object[0]));
        }
        AndroidFacet selectedFacet = this.getSelectedFacet();
        assert (selectedFacet != null);
        this.myWizard.setFacet(selectedFacet);
    }

    public JComponent getComponent() {
        return this.myContentPanel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        CheckModulePanel checkModulePanel;
        JComboBox jComboBox;
        JPanel jPanel;
        this.myContentPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        jLabel.setText("Module:");
        jLabel.setDisplayedMnemonic('M');
        jLabel.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myModuleCombo = jComboBox = new JComboBox();
        jPanel.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myCheckModulePanel = checkModulePanel = new CheckModulePanel();
        jPanel.add((Component)checkModulePanel, new GridConstraints(1, 0, 1, 2, 0, 3, 0, 0, null, null, null));
        jLabel.setLabelFor(jComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPanel;
    }
}

