/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.converters;

import com.intellij.psi.xml.XmlElement;
import com.intellij.util.containers.HashMap;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.ResolvingConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.dom.converters.AttributeValueDocumentationProvider;
import org.jetbrains.android.dom.converters.ResourceReferenceConverter;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DimensionConverter
extends ResolvingConverter<String>
implements AttributeValueDocumentationProvider {
    public static final DimensionConverter INSTANCE = new DimensionConverter();
    private static final Map<String, String> ourUnits = new HashMap();

    @NotNull
    public Collection<String> getVariants(ConvertContext context) {
        XmlElement element = context.getXmlElement();
        if (element == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                DimensionConverter.$$$reportNull$$$0(0);
            }
            return list;
        }
        String value = ResourceReferenceConverter.getValue(element);
        if (value == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                DimensionConverter.$$$reportNull$$$0(1);
            }
            return list;
        }
        String intPrefix = DimensionConverter.getIntegerPrefix(value);
        if (intPrefix.isEmpty()) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                DimensionConverter.$$$reportNull$$$0(2);
            }
            return list;
        }
        ArrayList<String> result = new ArrayList<String>(ourUnits.size());
        for (String unit : ourUnits.keySet()) {
            result.add(intPrefix + unit);
        }
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            DimensionConverter.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @Nullable
    public String fromString(@Nullable @NonNls String s, ConvertContext context) {
        String unit = DimensionConverter.getUnitFromValue(s);
        if (unit == null || unit.isEmpty()) {
            return null;
        }
        if ("dip".equals(unit)) {
            return s;
        }
        return ourUnits.get(unit) != null ? s : null;
    }

    @Nullable
    public String toString(@Nullable String s, ConvertContext context) {
        return s;
    }

    public String getErrorMessage(@Nullable String s, ConvertContext context) {
        String unit = DimensionConverter.getUnitFromValue(s);
        if (unit != null && !unit.isEmpty()) {
            if (unit.startsWith(",")) {
                return "Use a dot instead of a comma as the decimal mark";
            }
            return "Unknown unit '" + unit + "'";
        }
        return super.getErrorMessage(s, context);
    }

    @Nullable
    public static String getUnitFromValue(@Nullable String value) {
        if (value == null) {
            return null;
        }
        String intPrefix = DimensionConverter.getIntegerPrefix(value);
        if (intPrefix.isEmpty()) {
            return null;
        }
        return value.substring(intPrefix.length());
    }

    @NotNull
    static String getIntegerPrefix(@NotNull String s) {
        char c;
        if (s == null) {
            DimensionConverter.$$$reportNull$$$0(4);
        }
        if (s.isEmpty()) {
            if ("" == null) {
                DimensionConverter.$$$reportNull$$$0(5);
            }
            return "";
        }
        StringBuilder intPrefixBuilder = new StringBuilder();
        for (int i = 0; i < s.length() && (Character.isDigit(c = s.charAt(i)) || c == '.' || i <= 0 && c == '-'); ++i) {
            intPrefixBuilder.append(c);
        }
        String string = intPrefixBuilder.toString();
        if (string == null) {
            DimensionConverter.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    public String getDocumentation(@NotNull String value) {
        String unit;
        if (value == null) {
            DimensionConverter.$$$reportNull$$$0(7);
        }
        if ((unit = DimensionConverter.getUnitFromValue(value)) == null) {
            return null;
        }
        String description = ourUnits.get(unit);
        if (description == null || description.isEmpty()) {
            return null;
        }
        return "<html><body>" + description + "</body></html>";
    }

    static {
        ourUnits.put("dp", "<b>Density-independent Pixels</b> - an abstract unit that is based on the physical density of the screen.");
        ourUnits.put("sp", "<b>Scale-independent Pixels</b> - this is like the dp unit, but it is also scaled by the user's font size preference.");
        ourUnits.put("pt", "<b>Points</b> - 1/72 of an inch based on the physical size of the screen.");
        ourUnits.put("mm", "<b>Millimeters</b> - based on the physical size of the screen.");
        ourUnits.put("in", "<b>Inches</b> - based on the physical size of the screen.");
        ourUnits.put("px", "<b>Pixels</b> - corresponds to actual pixels on the screen. Not recommended.");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/dom/converters/DimensionConverter";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 4: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/dom/converters/DimensionConverter";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getIntegerPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getIntegerPrefix";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDocumentation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

