/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.converters;

import com.google.common.collect.Lists;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.util.DirectoryChooserUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.RunResult;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateMissingClassQuickFix
implements LocalQuickFix {
    private final SmartPsiElementPointer<PsiPackage> myPackage;
    @NotNull
    private final String myClassName;
    @NotNull
    private final Module myModule;
    private final String myBaseClassFqcn;

    CreateMissingClassQuickFix(@NotNull PsiPackage aPackage, @NotNull String className, @NotNull Module module, @Nullable String baseClassFqcn) {
        if (aPackage == null) {
            CreateMissingClassQuickFix.$$$reportNull$$$0(0);
        }
        if (className == null) {
            CreateMissingClassQuickFix.$$$reportNull$$$0(1);
        }
        if (module == null) {
            CreateMissingClassQuickFix.$$$reportNull$$$0(2);
        }
        this.myPackage = SmartPointerManager.getInstance((Project)aPackage.getProject()).createSmartPsiElementPointer((PsiElement)aPackage);
        this.myClassName = className;
        this.myModule = module;
        this.myBaseClassFqcn = baseClassFqcn;
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Nls
    @NotNull
    public String getName() {
        String string = String.format("Create class '%s'", this.myClassName);
        if (string == null) {
            CreateMissingClassQuickFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        if ("Create class" == null) {
            CreateMissingClassQuickFix.$$$reportNull$$$0(4);
        }
        return "Create class";
    }

    public void applyFix(final @NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiDirectory directory;
        PsiPackage aPackage;
        if (project == null) {
            CreateMissingClassQuickFix.$$$reportNull$$$0(5);
        }
        if (descriptor == null) {
            CreateMissingClassQuickFix.$$$reportNull$$$0(6);
        }
        if ((aPackage = (PsiPackage)this.myPackage.getElement()) == null) {
            return;
        }
        AndroidFacet facet = AndroidFacet.getInstance(this.myModule);
        if (facet == null) {
            return;
        }
        List<IdeaSourceProvider> providerList = IdeaSourceProvider.getCurrentSourceProviders(facet);
        ArrayList javaDirectories = Lists.newArrayList();
        for (IdeaSourceProvider provider : providerList) {
            javaDirectories.addAll(provider.getJavaDirectories());
        }
        PsiDirectory[] directories = aPackage.getDirectories();
        ArrayList filteredDirectories = Lists.newArrayListWithExpectedSize((int)directories.length);
        block5: for (PsiDirectory directory2 : directories) {
            for (VirtualFile file : javaDirectories) {
                if (!VfsUtilCore.isAncestor((VirtualFile)file, (VirtualFile)directory2.getVirtualFile(), (boolean)true)) continue;
                filteredDirectories.add(directory2);
                continue block5;
            }
        }
        switch (filteredDirectories.size()) {
            case 0: {
                directory = null;
                break;
            }
            case 1: {
                directory = (PsiDirectory)filteredDirectories.get(0);
                break;
            }
            default: {
                PsiDirectory[] array = filteredDirectories.toArray(new PsiDirectory[filteredDirectories.size()]);
                directory = DirectoryChooserUtil.selectDirectory((Project)aPackage.getProject(), (PsiDirectory[])array, (PsiDirectory)((PsiDirectory)filteredDirectories.get(0)), (String)"");
            }
        }
        if (directory == null) {
            return;
        }
        RunResult result = new WriteCommandAction<PsiClass>(project, new PsiFile[0]){

            protected void run(@NotNull Result<PsiClass> result) throws Throwable {
                PsiModifierList modifierList;
                PsiClass parentClass;
                if (result == null) {
                    1.$$$reportNull$$$0(0);
                }
                PsiClass psiClass = JavaDirectoryService.getInstance().createClass(directory, CreateMissingClassQuickFix.this.myClassName);
                JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
                PsiReferenceList list = psiClass.getExtendsList();
                if (list != null && CreateMissingClassQuickFix.this.myBaseClassFqcn != null && (parentClass = facade.findClass(CreateMissingClassQuickFix.this.myBaseClassFqcn, GlobalSearchScope.allScope((Project)project))) != null) {
                    list.add((PsiElement)facade.getElementFactory().createClassReferenceElement(parentClass));
                }
                if ((modifierList = psiClass.getModifierList()) != null) {
                    modifierList.setModifierProperty("public", true);
                }
                result.setResult((Object)psiClass);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/android/dom/converters/CreateMissingClassQuickFix$1", "run"));
            }
        }.execute();
        final PsiClass aClass = (PsiClass)result.getResultObject();
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                OpenFileDescriptor fileDescriptor = new OpenFileDescriptor(project, aClass.getContainingFile().getVirtualFile());
                FileEditorManager.getInstance((Project)project).openEditor(fileDescriptor, true);
            }
        }, project.getDisposed());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aPackage";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/dom/converters/CreateMissingClassQuickFix";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/dom/converters/CreateMissingClassQuickFix";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

