/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android;

import com.android.tools.idea.templates.TemplateManager;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetManagerAdapter;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Anchor;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.compiler.CompileTask;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Alarm;
import com.intellij.util.messages.MessageBusConnection;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.android.compiler.AndroidAutogeneratorMode;
import org.jetbrains.android.compiler.AndroidCompileUtil;
import org.jetbrains.android.compiler.AndroidPrecompileTask;
import org.jetbrains.android.compiler.ModuleSourceAutogenerating;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidResourceFilesListener;
import org.jetbrains.annotations.NotNull;

public class AndroidProjectComponent
implements ProjectComponent,
Disposable {
    private final Project myProject;
    private static boolean ourDynamicTemplateMenuCreated;

    protected AndroidProjectComponent(Project project) {
        this.myProject = project;
    }

    public void projectOpened() {
        CompilerManager manager = CompilerManager.getInstance((Project)this.myProject);
        manager.addBeforeTask((CompileTask)new AndroidPrecompileTask());
        if (!ApplicationManager.getApplication().isUnitTestMode() && !ApplicationManager.getApplication().isHeadlessEnvironment()) {
            if (ProjectFacetManager.getInstance((Project)this.myProject).hasFacets(AndroidFacet.ID)) {
                this.createAndroidSpecificComponents();
            } else {
                final MessageBusConnection connection2 = this.myProject.getMessageBus().connect();
                connection2.subscribe(FacetManager.FACETS_TOPIC, (Object)new FacetManagerAdapter(){

                    public void facetAdded(@NotNull Facet facet) {
                        if (facet == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (facet instanceof AndroidFacet) {
                            AndroidProjectComponent.this.createAndroidSpecificComponents();
                            connection2.disconnect();
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/AndroidProjectComponent$1", "facetAdded"));
                    }
                });
            }
        }
    }

    private void createAndroidSpecificComponents() {
        AndroidResourceFilesListener listener = new AndroidResourceFilesListener(this.myProject);
        Disposer.register((Disposable)this, (Disposable)listener);
        AndroidProjectComponent.createDynamicTemplateMenu();
        this.createAlarmForAutogeneration();
    }

    public void dispose() {
    }

    private static void createDynamicTemplateMenu() {
        if (ourDynamicTemplateMenuCreated) {
            return;
        }
        ourDynamicTemplateMenuCreated = true;
        DefaultActionGroup newGroup = (DefaultActionGroup)ActionManager.getInstance().getAction("NewGroup");
        newGroup.addSeparator();
        ActionGroup menu = TemplateManager.getInstance().getTemplateCreationMenu(null);
        if (menu != null) {
            newGroup.add((AnAction)menu, new Constraints(Anchor.AFTER, "NewFromTemplate"));
        }
    }

    private void createAlarmForAutogeneration() {
        final Alarm alarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
        alarm.addRequest(new Runnable(){

            @Override
            public void run() {
                if (!AndroidProjectComponent.this.myProject.isOpen()) {
                    return;
                }
                DumbService service = DumbService.getInstance((Project)AndroidProjectComponent.this.myProject);
                Map facetsToProcess = (Map)service.runReadActionInSmartMode(() -> AndroidProjectComponent.this.checkGenerate());
                if (!facetsToProcess.isEmpty()) {
                    AndroidProjectComponent.this.generate(facetsToProcess);
                }
                if (!alarm.isDisposed()) {
                    alarm.addRequest((Runnable)this, 2000);
                }
            }
        }, 2000);
    }

    private Map<AndroidFacet, Collection<AndroidAutogeneratorMode>> checkGenerate() {
        if (this.myProject.isDisposed()) {
            return Collections.emptyMap();
        }
        HashMap<AndroidFacet, Collection<AndroidAutogeneratorMode>> facetsToProcess = new HashMap<AndroidFacet, Collection<AndroidAutogeneratorMode>>();
        for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            AndroidFacet facet = AndroidFacet.getInstance(module);
            if (facet == null || !ModuleSourceAutogenerating.requiresAutoSourceGeneration(facet)) continue;
            ModuleSourceAutogenerating autogenerator = ModuleSourceAutogenerating.getInstance(facet);
            assert (autogenerator != null);
            EnumSet<AndroidAutogeneratorMode> modes = EnumSet.noneOf(AndroidAutogeneratorMode.class);
            for (AndroidAutogeneratorMode mode : AndroidAutogeneratorMode.values()) {
                if (!autogenerator.cleanRegeneratingState(mode) && !autogenerator.isGeneratedFileRemoved(mode)) continue;
                modes.add(mode);
            }
            if (modes.isEmpty()) continue;
            facetsToProcess.put(facet, modes);
        }
        return facetsToProcess;
    }

    private void generate(Map<AndroidFacet, Collection<AndroidAutogeneratorMode>> facetsToProcess) {
        TransactionGuard.getInstance().submitTransactionAndWait(() -> AndroidCompileUtil.createGenModulesAndSourceRoots(this.myProject, facetsToProcess.keySet()));
        for (Map.Entry<AndroidFacet, Collection<AndroidAutogeneratorMode>> entry : facetsToProcess.entrySet()) {
            AndroidFacet facet = entry.getKey();
            Collection<AndroidAutogeneratorMode> modes = entry.getValue();
            for (AndroidAutogeneratorMode mode : modes) {
                AndroidCompileUtil.doGenerate(facet, mode);
            }
        }
    }
}

