/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.updater;

import com.android.repository.api.ConstantSourceProvider;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RepositorySourceProvider;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.updater.SdkComponentSource;
import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.Credentials;
import com.intellij.credentialStore.OneTimeString;
import com.intellij.ide.externalComponents.ExternalComponentManager;
import com.intellij.ide.externalComponents.ExternalComponentSource;
import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.BaseComponent;
import com.intellij.util.proxy.CommonProxy;
import com.intellij.util.proxy.NonStaticAuthenticator;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidSdkUpdaterPlugin
implements BaseComponent {
    public void initComponent() {
        if (AndroidSdkUtils.isAndroidSdkManagerEnabled()) {
            this.setUpAuthenticator();
            ExternalComponentManager.getInstance().registerComponentSource((ExternalComponentSource)new SdkComponentSource());
            URL offlineRepo = AndroidSdkUpdaterPlugin.getOfflineRepoDir();
            if (offlineRepo != null) {
                ConstantSourceProvider provider = new ConstantSourceProvider(offlineRepo.toString(), "Offline Repo", (Collection)AndroidSdkHandler.getAllModules());
                AndroidSdkHandler.addCustomSourceProvider((RepositorySourceProvider)provider, (ProgressIndicator)new StudioLoggerProgressIndicator(this.getClass()));
            }
        }
    }

    @Nullable
    private static URL getOfflineRepoDir() {
        Path path = Paths.get(PathManager.getPreInstalledPluginsPath(), "sdk-updates", "offline-repo", "offline-repo.xml");
        if (Files.exists(path, new LinkOption[0])) {
            try {
                return path.toUri().toURL();
            }
            catch (MalformedURLException e) {
                return null;
            }
        }
        return null;
    }

    private void setUpAuthenticator() {
        CommonProxy.getInstance().setCustomAuth(this.getClass().getName(), (NonStaticAuthenticator)new AndroidAuthenticator());
    }

    public static String getCredentialServiceName(@NotNull String host) {
        if (host == null) {
            AndroidSdkUpdaterPlugin.$$$reportNull$$$0(0);
        }
        return "AndroidSdk:" + host;
    }

    @Nullable
    public static PasswordAuthentication getAuthentication(@NotNull String host) {
        OneTimeString password;
        Credentials credentials;
        if (host == null) {
            AndroidSdkUpdaterPlugin.$$$reportNull$$$0(1);
        }
        if ((credentials = PasswordSafe.getInstance().get(new CredentialAttributes(AndroidSdkUpdaterPlugin.getCredentialServiceName(host)))) != null && (password = credentials.getPassword()) != null) {
            return new PasswordAuthentication(credentials.getUserName(), password.toCharArray());
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "host";
        objectArray2[1] = "com/android/tools/idea/updater/AndroidSdkUpdaterPlugin";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getCredentialServiceName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getAuthentication";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class AndroidAuthenticator
    extends NonStaticAuthenticator {
        private AndroidAuthenticator() {
        }

        @Nullable
        public PasswordAuthentication getPasswordAuthentication() {
            String host;
            PasswordAuthentication result;
            URL url = this.getRequestingURL();
            if (url != null && (result = AndroidSdkUpdaterPlugin.getAuthentication(host = url.toString())) != null) {
                return result;
            }
            return AndroidSdkUpdaterPlugin.getAuthentication(CommonProxy.getHostNameReliably((String)this.getRequestingHost(), (InetAddress)this.getRequestingSite(), (URL)this.getRequestingURL()));
        }
    }
}

