/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.scene.target;

import com.android.tools.idea.common.model.AttributesTransaction;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.target.Target;
import com.android.tools.idea.uibuilder.scene.target.Notch;
import java.awt.Point;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TargetSnapper {
    public static final int PARENT = 1;
    public static final int PARENT_TARGET = 2;
    public static final int CHILD = 4;
    public static final int CHILD_TARGET = 8;
    public static final int ALL = 15;
    private final ArrayList<Notch> myHorizontalNotches = new ArrayList();
    private final ArrayList<Notch> myVerticalNotches = new ArrayList();
    @Nullable
    private Notch myCurrentNotchY;
    @Nullable
    private Notch myCurrentNotchX;
    private int myNotchesSourcesMask = 15;

    public Point applyNotches(SceneComponent component2, AttributesTransaction attributes, int mouseX, int mouseY) {
        return this.applyNotches(component2, attributes, new Point(mouseX, mouseY));
    }

    public Point applyNotches(@NotNull SceneComponent component2, @NotNull AttributesTransaction attributes, @NotNull Point snapLocation) {
        if (component2 == null) {
            TargetSnapper.$$$reportNull$$$0(0);
        }
        if (attributes == null) {
            TargetSnapper.$$$reportNull$$$0(1);
        }
        if (snapLocation == null) {
            TargetSnapper.$$$reportNull$$$0(2);
        }
        if (this.myCurrentNotchX != null) {
            snapLocation.x = this.myCurrentNotchX.trySnap(snapLocation.x);
            if (component2.allowsAutoConnect()) {
                this.myCurrentNotchX.applyAction(attributes);
            }
            this.myCurrentNotchX = null;
        }
        if (this.myCurrentNotchY != null) {
            snapLocation.y = this.myCurrentNotchY.trySnap(snapLocation.y);
            if (component2.allowsAutoConnect()) {
                this.myCurrentNotchY.applyAction(attributes);
            }
            this.myCurrentNotchY = null;
        }
        return snapLocation;
    }

    public int trySnapX(int x) {
        int count = this.myHorizontalNotches.size();
        for (int i = 0; i < count; ++i) {
            Notch notch2 = this.myHorizontalNotches.get(i);
            x = notch2.trySnap(x);
            if (!notch2.didApply()) continue;
            this.myCurrentNotchX = notch2;
            return x;
        }
        this.myCurrentNotchX = null;
        return x;
    }

    public int trySnapY(int y) {
        int count = this.myVerticalNotches.size();
        for (int i = 0; i < count; ++i) {
            Notch notch2 = this.myVerticalNotches.get(i);
            y = notch2.trySnap(y);
            if (!notch2.didApply()) continue;
            this.myCurrentNotchY = notch2;
            return y;
        }
        this.myCurrentNotchY = null;
        return y;
    }

    public void gatherNotches(@NotNull SceneComponent snappable) {
        Notch.Provider notchProvider;
        if (snappable == null) {
            TargetSnapper.$$$reportNull$$$0(3);
        }
        this.myCurrentNotchX = null;
        this.myCurrentNotchY = null;
        this.myHorizontalNotches.clear();
        this.myVerticalNotches.clear();
        SceneComponent parent = snappable.getParent();
        if (parent == null) {
            return;
        }
        if ((this.myNotchesSourcesMask & 1) > 0 && (notchProvider = parent.getNotchProvider()) != null) {
            notchProvider.fill(parent, snappable, this.myHorizontalNotches, this.myVerticalNotches);
        }
        if ((this.myNotchesSourcesMask & 2) > 0) {
            this.gatherNotchFromTargets(snappable, parent);
        }
        if ((this.myNotchesSourcesMask & 0xC) > 0) {
            int count = parent.getChildCount();
            for (int i = 0; i < count; ++i) {
                Notch.Provider provider;
                SceneComponent child = parent.getChild(i);
                if (child == snappable) continue;
                if ((this.myNotchesSourcesMask & 4) > 0 && (provider = child.getNotchProvider()) != null) {
                    provider.fill(child, snappable, this.myHorizontalNotches, this.myVerticalNotches);
                }
                if ((this.myNotchesSourcesMask & 8) <= 0) continue;
                this.gatherNotchFromTargets(snappable, child);
            }
        }
    }

    public void setSources(int sourceMask) {
        this.myNotchesSourcesMask = sourceMask;
    }

    private void gatherNotchFromTargets(@NotNull SceneComponent snappable, @NotNull SceneComponent owner) {
        if (snappable == null) {
            TargetSnapper.$$$reportNull$$$0(4);
        }
        if (owner == null) {
            TargetSnapper.$$$reportNull$$$0(5);
        }
        for (Target target : owner.getTargets()) {
            if (!(target instanceof Notch.Provider)) continue;
            ((Notch.Provider)((Object)target)).fill(owner, snappable, this.myHorizontalNotches, this.myVerticalNotches);
        }
    }

    public void renderCurrentNotches(@NotNull DisplayList list, @NotNull SceneContext sceneContext, @NotNull SceneComponent component2) {
        if (list == null) {
            TargetSnapper.$$$reportNull$$$0(6);
        }
        if (sceneContext == null) {
            TargetSnapper.$$$reportNull$$$0(7);
        }
        if (component2 == null) {
            TargetSnapper.$$$reportNull$$$0(8);
        }
        if (this.myCurrentNotchX != null) {
            this.myCurrentNotchX.render(list, sceneContext, component2);
        }
        if (this.myCurrentNotchY != null) {
            this.myCurrentNotchY.render(list, sceneContext, component2);
        }
    }

    @Nullable
    public Notch getSnappedNotchX() {
        return this.myCurrentNotchX;
    }

    @Nullable
    public Notch getSnappedNotchY() {
        return this.myCurrentNotchY;
    }

    public void cleanNotch() {
        this.myCurrentNotchX = null;
        this.myCurrentNotchY = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "snapLocation";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "snappable";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sceneContext";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/uibuilder/scene/target/TargetSnapper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "applyNotches";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "gatherNotches";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "gatherNotchFromTargets";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "renderCurrentNotches";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

