/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.scene.draw;

import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.draw.DrawRegion;
import com.android.tools.idea.uibuilder.handlers.constraint.draw.DrawConnectionUtils;
import com.android.tools.idea.uibuilder.handlers.constraint.drawing.ColorSet;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;

public class DrawHorizontalNotch
extends DrawRegion {
    public DrawHorizontalNotch(String s) {
        super(s);
    }

    public DrawHorizontalNotch(int x, int y, int width) {
        super(x, y, width, x);
    }

    @Override
    public void paint(Graphics2D g, SceneContext sceneContext) {
        ColorSet colorSet = sceneContext.getColorSet();
        Color background = colorSet.getFrames();
        g.setColor(background);
        Stroke stroke = g.getStroke();
        g.setStroke(DrawConnectionUtils.sDashedStroke);
        g.drawLine(this.x, this.y, this.x + this.width, this.y);
        g.setStroke(stroke);
    }

    public static void add(DisplayList list, SceneContext transform2, float left, float top, float right) {
        int l = transform2.getSwingXDip(left);
        int t = transform2.getSwingYDip(top);
        int w = transform2.getSwingDimensionDip(right - left);
        list.add(new DrawHorizontalNotch(l, t, w));
    }
}

