/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property;

import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceResolver;
import com.android.resources.ResourceType;
import com.android.tools.adtui.ptable.PTable;
import com.android.tools.adtui.ptable.PTableGroupItem;
import com.android.tools.adtui.ptable.PTableItem;
import com.android.tools.adtui.ptable.StarState;
import com.android.tools.idea.common.command.NlWriteCommandAction;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.property.NlProperty;
import com.android.tools.idea.common.property.PropertiesManager;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.uibuilder.property.NlFlagPropertyItem;
import com.android.tools.idea.uibuilder.property.NlIdPropertyItem;
import com.android.tools.idea.uibuilder.property.NlProperties;
import com.android.tools.idea.uibuilder.property.renderer.NlAttributeRenderer;
import com.android.tools.idea.uibuilder.property.renderer.NlPropertyRenderers;
import com.android.util.PropertiesMap;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.XmlName;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.AttributeFormat;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlPropertyItem
extends PTableItem
implements NlProperty {
    private static final Set<String> ATTRS_WITHOUT_DEFINITIONS = ImmutableSet.of((Object)"style", (Object)"class", (Object)"layout");
    @NotNull
    protected final List<NlComponent> myComponents;
    @NotNull
    protected final PropertiesManager myPropertiesManager;
    @Nullable
    protected final AttributeDefinition myDefinition;
    @NotNull
    private final String myName;
    @Nullable
    private final String myNamespace;
    @Nullable
    private PropertiesMap.Property myDefaultValue;
    @NotNull
    private StarState myStarState;

    public static NlPropertyItem create(@NotNull XmlName name, @Nullable AttributeDefinition attributeDefinition, @NotNull List<NlComponent> components, @NotNull PropertiesManager propertiesManager) {
        if (name == null) {
            NlPropertyItem.$$$reportNull$$$0(0);
        }
        if (components == null) {
            NlPropertyItem.$$$reportNull$$$0(1);
        }
        if (propertiesManager == null) {
            NlPropertyItem.$$$reportNull$$$0(2);
        }
        if (attributeDefinition != null && attributeDefinition.getFormats().contains((Object)AttributeFormat.Flag)) {
            return new NlFlagPropertyItem(name, attributeDefinition, components, propertiesManager);
        }
        if (name.getLocalName().equals("id")) {
            return new NlIdPropertyItem(name, attributeDefinition, components, propertiesManager);
        }
        return new NlPropertyItem(name, attributeDefinition, components, propertiesManager);
    }

    protected NlPropertyItem(@NotNull XmlName name, @Nullable AttributeDefinition attributeDefinition, @NotNull List<NlComponent> components, @NotNull PropertiesManager propertiesManager) {
        if (name == null) {
            NlPropertyItem.$$$reportNull$$$0(3);
        }
        if (components == null) {
            NlPropertyItem.$$$reportNull$$$0(4);
        }
        if (propertiesManager == null) {
            NlPropertyItem.$$$reportNull$$$0(5);
        }
        assert (!components.isEmpty());
        if (attributeDefinition == null && !ATTRS_WITHOUT_DEFINITIONS.contains(name.getLocalName()) && !"http://schemas.android.com/tools".equals(name.getNamespaceKey())) {
            throw new IllegalArgumentException("Missing attribute definition for " + name.getLocalName());
        }
        this.myComponents = components;
        this.myPropertiesManager = propertiesManager;
        this.myName = name.getLocalName();
        this.myNamespace = name.getNamespaceKey();
        this.myDefinition = attributeDefinition;
        this.myStarState = StarState.STAR_ABLE;
    }

    protected NlPropertyItem(@NotNull NlPropertyItem property2, @NotNull String namespace) {
        if (property2 == null) {
            NlPropertyItem.$$$reportNull$$$0(6);
        }
        if (namespace == null) {
            NlPropertyItem.$$$reportNull$$$0(7);
        }
        assert (!property2.myComponents.isEmpty());
        this.myComponents = property2.myComponents;
        this.myPropertiesManager = property2.myPropertiesManager;
        this.myName = property2.myName;
        this.myNamespace = namespace;
        this.myDefinition = property2.myDefinition;
        this.myStarState = StarState.STAR_ABLE;
        if (property2.getParent() != null) {
            PTableGroupItem group = (PTableGroupItem)property2.getParent();
            group.addChild((PTableItem)this, (PTableItem)property2);
        }
    }

    public boolean sameDefinition(@Nullable NlPropertyItem other) {
        return other != null && Objects.equal((Object)this.myName, (Object)other.myName) && Objects.equal((Object)this.myNamespace, (Object)other.myNamespace) && this.myDefinition == other.myDefinition;
    }

    @Override
    @NotNull
    public List<NlComponent> getComponents() {
        List<NlComponent> list = this.myComponents;
        if (list == null) {
            NlPropertyItem.$$$reportNull$$$0(8);
        }
        return list;
    }

    @NotNull
    public StarState getStarState() {
        StarState starState = this.myStarState;
        if (starState == null) {
            NlPropertyItem.$$$reportNull$$$0(9);
        }
        return starState;
    }

    public void setInitialStarred() {
        this.myStarState = StarState.STARRED;
    }

    public void setStarState(@NotNull StarState starState) {
        if (starState == null) {
            NlPropertyItem.$$$reportNull$$$0(10);
        }
        this.myStarState = starState;
        NlProperties.saveStarState(this.myNamespace, this.myName, starState == StarState.STARRED, this.myPropertiesManager);
        this.myPropertiesManager.starStateChanged();
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            NlPropertyItem.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Override
    @Nullable
    public String getNamespace() {
        return this.myNamespace;
    }

    public void setDefaultValue(@Nullable PropertiesMap.Property defaultValue) {
        this.myDefaultValue = defaultValue;
    }

    @Override
    @Nullable
    public String getValue() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        String prev = null;
        for (NlComponent component2 : this.myComponents) {
            String value = component2.getAttribute(this.myNamespace, this.myName);
            if (value == null) {
                return null;
            }
            if (prev == null) {
                prev = value;
                continue;
            }
            if (value.equals(prev)) continue;
            return null;
        }
        return prev;
    }

    @Override
    @Nullable
    public String getResolvedValue() {
        return this.resolveValue(this.getValue());
    }

    @Override
    public boolean isDefaultValue(@Nullable String value) {
        if (value == null) {
            return true;
        }
        if (this.myDefaultValue == null) {
            return false;
        }
        return value.equals(this.myDefaultValue.resource);
    }

    @Override
    @Nullable
    public String resolveValue(@Nullable String value) {
        if (this.myDefaultValue != null && this.isDefaultValue(value)) {
            if (this.myDefaultValue.value == null) {
                this.myDefaultValue = new PropertiesMap.Property(this.myDefaultValue.resource, this.resolveValueUsingResolver(this.myDefaultValue.resource));
            }
            return this.myDefaultValue.value;
        }
        return value != null ? this.resolveValueUsingResolver(value) : null;
    }

    public void mouseMoved(@NotNull PTable table2, @NotNull MouseEvent event, @NotNull Rectangle rectRightColumn) {
        if (table2 == null) {
            NlPropertyItem.$$$reportNull$$$0(12);
        }
        if (event == null) {
            NlPropertyItem.$$$reportNull$$$0(13);
        }
        if (rectRightColumn == null) {
            NlPropertyItem.$$$reportNull$$$0(14);
        }
        NlAttributeRenderer renderer = NlPropertyRenderers.getInstance().get(this);
        renderer.mouseMoved(table2, event, rectRightColumn);
    }

    public void delete() {
        PTableGroupItem group = (PTableGroupItem)this.getParent();
        if (group != null) {
            group.deleteChild((PTableItem)this);
        }
    }

    public static boolean isReference(@Nullable String value) {
        return value != null && (value.startsWith("?") || value.startsWith("@") && !NlPropertyItem.isId(value));
    }

    @NotNull
    private String resolveValueUsingResolver(@NotNull String value) {
        ResourceResolver resolver;
        if (value == null) {
            NlPropertyItem.$$$reportNull$$$0(15);
        }
        if (NlPropertyItem.isReference(value) && (resolver = this.getResolver()) != null) {
            ResourceValue resource = resolver.findResValue(value, false);
            if (resource == null) {
                resource = resolver.findResValue(value, true);
            }
            if (resource != null) {
                ResourceValue resolved;
                if (resource.getValue() != null) {
                    String string = value = resource.getResourceType() == ResourceType.FONT ? resource.getName() : resource.getValue();
                    if (resource.isFramework()) {
                        value = NlPropertyItem.addAndroidPrefix(value);
                    }
                }
                if ((resolved = resolver.resolveResValue(resource)) != null && resolved.getValue() != null) {
                    String string = value = resolved.getResourceType() == ResourceType.FONT ? resolved.getName() : resolved.getValue();
                    if (resource.isFramework()) {
                        value = NlPropertyItem.addAndroidPrefix(value);
                    }
                }
            }
        }
        String string = value;
        if (string == null) {
            NlPropertyItem.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NotNull
    private static String addAndroidPrefix(@NotNull String value) {
        if (value == null) {
            NlPropertyItem.$$$reportNull$$$0(17);
        }
        if (value.startsWith("@") && !value.startsWith("@android:")) {
            String string = "@android:" + value.substring(1);
            if (string == null) {
                NlPropertyItem.$$$reportNull$$$0(18);
            }
            return string;
        }
        String string = value;
        if (string == null) {
            NlPropertyItem.$$$reportNull$$$0(19);
        }
        return string;
    }

    private static boolean isId(@NotNull String value) {
        if (value == null) {
            NlPropertyItem.$$$reportNull$$$0(20);
        }
        return value.startsWith("@id/") || value.startsWith("@+id/") || value.startsWith("@android:id/") || value.startsWith("@android:+id/");
    }

    @Override
    @NotNull
    public NlProperty getChildProperty(@NotNull String itemName) {
        if (itemName == null) {
            NlPropertyItem.$$$reportNull$$$0(21);
        }
        throw new UnsupportedOperationException(itemName);
    }

    @Override
    @NotNull
    public NlPropertyItem getDesignTimeProperty() {
        if ("http://schemas.android.com/tools".equals(this.myNamespace)) {
            NlPropertyItem nlPropertyItem = this;
            if (nlPropertyItem == null) {
                NlPropertyItem.$$$reportNull$$$0(22);
            }
            return nlPropertyItem;
        }
        NlPropertyItem nlPropertyItem = new NlPropertyItem(this, "http://schemas.android.com/tools");
        if (nlPropertyItem == null) {
            NlPropertyItem.$$$reportNull$$$0(23);
        }
        return nlPropertyItem;
    }

    @Override
    @NotNull
    public NlModel getModel() {
        NlModel nlModel = this.myComponents.get(0).getModel();
        if (nlModel == null) {
            NlPropertyItem.$$$reportNull$$$0(24);
        }
        return nlModel;
    }

    @Override
    @Nullable
    public XmlTag getTag() {
        return this.myComponents.size() == 1 ? this.myComponents.get(0).getTag() : null;
    }

    @Override
    @Nullable
    public String getTagName() {
        String tagName = null;
        for (NlComponent component2 : this.myComponents) {
            if (tagName == null) {
                tagName = component2.getTagName();
                continue;
            }
            if (tagName.equals(component2.getTagName())) continue;
            return null;
        }
        return tagName;
    }

    @Override
    @Nullable
    public ResourceResolver getResolver() {
        Configuration configuration = this.getModel().getConfiguration();
        return configuration.getResourceResolver();
    }

    @Override
    public void setValue(@Nullable Object value) {
        String strValue;
        String string = strValue = value == null ? null : value.toString();
        if (StringUtil.isEmpty((String)strValue) || this.isDefaultValue(strValue)) {
            strValue = null;
        }
        this.setValueIgnoreDefaultValue(strValue, null);
    }

    protected void setValueIgnoreDefaultValue(@Nullable String attrValue, @Nullable Runnable valueUpdated) {
        assert (ApplicationManager.getApplication().isDispatchThread());
        if (this.getModel().getProject().isDisposed()) {
            return;
        }
        String oldValue = this.getValue();
        String componentName = this.myComponents.size() == 1 ? this.myComponents.get(0).getTagName() : "Multiple";
        NlWriteCommandAction.run(this.myComponents, "Set " + componentName + '.' + this.myName + " to " + attrValue, () -> {
            this.myComponents.forEach(component2 -> component2.setAttribute(this.myNamespace, this.myName, attrValue));
            this.myPropertiesManager.propertyChanged(this, oldValue, attrValue);
            if (valueUpdated == null) {
                return;
            }
            valueUpdated.run();
        });
        this.myPropertiesManager.logPropertyChange(this);
    }

    @NotNull
    public List<String> getParentStylables() {
        List<String> list = this.myDefinition == null ? Collections.emptyList() : this.myDefinition.getParentStyleables();
        if (list == null) {
            NlPropertyItem.$$$reportNull$$$0(25);
        }
        return list;
    }

    @Override
    @Nullable
    public AttributeDefinition getDefinition() {
        return this.myDefinition;
    }

    public boolean isEditable(int column) {
        return column == 1;
    }

    public String toString() {
        return NlPropertyItem.namespaceToPrefix(this.myNamespace) + this.myName;
    }

    @Override
    @NotNull
    public String getTooltipText() {
        String value;
        StringBuilder sb = new StringBuilder(100);
        sb.append(NlPropertyItem.namespaceToPrefix(this.myNamespace));
        sb.append(this.myName);
        if (this.myDefinition != null && (value = this.myDefinition.getDocValue(null)) != null) {
            sb.append(": ");
            sb.append(value);
        }
        String string = sb.toString();
        if (string == null) {
            NlPropertyItem.$$$reportNull$$$0(26);
        }
        return string;
    }

    @NotNull
    static String namespaceToPrefix(@Nullable String namespace) {
        if (namespace == null) {
            if ("" == null) {
                NlPropertyItem.$$$reportNull$$$0(27);
            }
            return "";
        }
        if (namespace.equalsIgnoreCase("http://schemas.android.com/apk/res/android")) {
            if ("@android:" == null) {
                NlPropertyItem.$$$reportNull$$$0(28);
            }
            return "@android:";
        }
        if (namespace.equalsIgnoreCase("http://schemas.android.com/apk/res-auto")) {
            if ("@app:" == null) {
                NlPropertyItem.$$$reportNull$$$0(29);
            }
            return "@app:";
        }
        if ("" == null) {
            NlPropertyItem.$$$reportNull$$$0(30);
        }
        return "";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 16: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 16: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertiesManager";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 16: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/property/NlPropertyItem";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "starState";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rectRightColumn";
                break;
            }
            case 15: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "itemName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/property/NlPropertyItem";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponents";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getStarState";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveValueUsingResolver";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "addAndroidPrefix";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getDesignTimeProperty";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentStylables";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getTooltipText";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "namespaceToPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 16: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setStarState";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "mouseMoved";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "resolveValueUsingResolver";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addAndroidPrefix";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isId";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getChildProperty";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 16: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

