/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.palette2;

import com.android.tools.idea.common.model.NlLayoutType;
import com.android.tools.idea.uibuilder.palette.NlPaletteModel;
import com.android.tools.idea.uibuilder.palette.Palette;
import com.android.tools.idea.uibuilder.palette2.CategoryListModel;
import com.android.tools.idea.uibuilder.palette2.DependencyManager;
import com.android.tools.idea.uibuilder.palette2.ItemFilter;
import com.android.tools.idea.uibuilder.palette2.ItemListModel;
import com.google.common.collect.Lists;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.UIUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public class DataModel {
    public static final Palette.Group COMMON = new Palette.Group("Common");
    public static final Palette.Group RESULTS = new Palette.Group("All Results");
    public static final String FAVORITE_ITEMS = "Palette.Favorite.items";
    private final CategoryListModel myListModel;
    private final ItemListModel myItemModel;
    private final ItemFilter myItemFilter;
    private final DependencyManager myDependencyManager;
    private final List<String> myFavoriteItems;
    private NlLayoutType myLayoutType;
    private Palette myPalette;
    private Palette.Group myCurrentSelectedGroup;

    public DataModel(@NotNull DependencyManager dependencyManager) {
        if (dependencyManager == null) {
            DataModel.$$$reportNull$$$0(0);
        }
        this.myListModel = new CategoryListModel();
        this.myItemModel = new ItemListModel();
        this.myItemFilter = new ItemFilter();
        this.myFavoriteItems = DataModel.readFavoriteItems();
        this.myDependencyManager = dependencyManager;
        this.myLayoutType = NlLayoutType.UNKNOWN;
        this.myPalette = Palette.EMPTY;
        this.myCurrentSelectedGroup = COMMON;
    }

    @NotNull
    public CategoryListModel getCategoryListModel() {
        CategoryListModel categoryListModel = this.myListModel;
        if (categoryListModel == null) {
            DataModel.$$$reportNull$$$0(1);
        }
        return categoryListModel;
    }

    @NotNull
    public ItemListModel getItemListModel() {
        ItemListModel itemListModel = this.myItemModel;
        if (itemListModel == null) {
            DataModel.$$$reportNull$$$0(2);
        }
        return itemListModel;
    }

    public void setLayoutType(@NotNull AndroidFacet facet, @NotNull NlLayoutType layoutType) {
        if (facet == null) {
            DataModel.$$$reportNull$$$0(3);
        }
        if (layoutType == null) {
            DataModel.$$$reportNull$$$0(4);
        }
        if (this.myLayoutType.equals((Object)layoutType)) {
            return;
        }
        NlPaletteModel paletteModel = NlPaletteModel.get(facet);
        this.myPalette = paletteModel.getPalette(layoutType);
        this.myLayoutType = layoutType;
        this.myDependencyManager.setPalette(this.myPalette, facet.getModule());
        this.update();
    }

    public void setFilterPattern(@NotNull String pattern) {
        if (pattern == null) {
            DataModel.$$$reportNull$$$0(5);
        }
        if (this.myItemFilter.getPattern().equals(pattern)) {
            return;
        }
        this.myItemFilter.setPattern(pattern);
        this.update();
    }

    @NotNull
    public String getFilterPattern() {
        String string = this.myItemFilter.getPattern();
        if (string == null) {
            DataModel.$$$reportNull$$$0(6);
        }
        return string;
    }

    public int getMatchCount() {
        return this.myListModel.getMatchCountAt(0);
    }

    public void categorySelectionChanged(@NotNull Palette.Group selectedGroup) {
        if (selectedGroup == null) {
            DataModel.$$$reportNull$$$0(7);
        }
        if (this.myItemFilter.getPattern().isEmpty()) {
            this.createUnFilteredItems(selectedGroup);
        } else {
            this.createFilteredItems(selectedGroup);
        }
        this.myCurrentSelectedGroup = selectedGroup;
    }

    public boolean isFavoriteItem(@NotNull Palette.Item item) {
        if (item == null) {
            DataModel.$$$reportNull$$$0(8);
        }
        return this.myFavoriteItems.contains(item.getId());
    }

    public void addFavoriteItem(@NotNull Palette.Item item) {
        if (item == null) {
            DataModel.$$$reportNull$$$0(9);
        }
        if (this.myFavoriteItems.contains(item.getId())) {
            return;
        }
        this.myFavoriteItems.add(item.getId());
        PropertiesComponent.getInstance().setValues(FAVORITE_ITEMS, ArrayUtil.toStringArray(this.myFavoriteItems));
        this.update();
    }

    public void removeFavoriteItem(@NotNull Palette.Item item) {
        if (item == null) {
            DataModel.$$$reportNull$$$0(10);
        }
        if (!this.myFavoriteItems.contains(item.getId())) {
            return;
        }
        this.myFavoriteItems.remove(item.getId());
        PropertiesComponent.getInstance().setValues(FAVORITE_ITEMS, ArrayUtil.toStringArray(this.myFavoriteItems));
        this.update();
        if (this.myCurrentSelectedGroup == COMMON) {
            this.createUnFilteredItems(COMMON);
        }
    }

    @NotNull
    Palette getPalette() {
        Palette palette = this.myPalette;
        if (palette == null) {
            DataModel.$$$reportNull$$$0(11);
        }
        return palette;
    }

    @NotNull
    private static List<String> readFavoriteItems() {
        Object[] favorites = PropertiesComponent.getInstance().getValues(FAVORITE_ITEMS);
        if (favorites == null) {
            favorites = new String[]{"TextView", "Button", "ImageView", "android.support.v7.widget.RecyclerView", "fragment", "ScrollView", "Switch"};
        }
        ArrayList arrayList = Lists.newArrayList((Object[])favorites);
        if (arrayList == null) {
            DataModel.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    private void update() {
        if (this.myItemFilter.getPattern().isEmpty()) {
            this.createUnFilteredGroups();
        } else {
            this.createFilteredGroups();
        }
    }

    private void createUnFilteredGroups() {
        final ArrayList<Palette.Group> groups = new ArrayList<Palette.Group>();
        groups.add(COMMON);
        this.myPalette.accept(new Palette.Visitor(){

            @Override
            public void visit(@NotNull Palette.Item item) {
                if (item == null) {
                    1.$$$reportNull$$$0(0);
                }
            }

            @Override
            public void visit(@NotNull Palette.Group group) {
                if (group == null) {
                    1.$$$reportNull$$$0(1);
                }
                groups.add(group);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "item";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "group";
                        break;
                    }
                }
                objectArray[1] = "com/android/tools/idea/uibuilder/palette2/DataModel$1";
                objectArray[2] = "visit";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.updateCategoryModel(groups, Collections.emptyList());
    }

    private void createFilteredGroups() {
        final ArrayList<Palette.Group> groups = new ArrayList<Palette.Group>();
        final ArrayList<Integer> matchCounts = new ArrayList<Integer>();
        groups.add(RESULTS);
        matchCounts.add(0);
        this.myPalette.accept(new Palette.Visitor(){
            private Palette.Group currentGroup = RESULTS;
            private int matchCount;

            @Override
            public void visit(@NotNull Palette.Group group) {
                if (group == null) {
                    2.$$$reportNull$$$0(0);
                }
                this.currentGroup = group;
                this.matchCount = 0;
            }

            @Override
            public void visit(@NotNull Palette.Item item) {
                if (item == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (this.currentGroup.equals(item.getParent()) && DataModel.this.myItemFilter.value(item)) {
                    ++this.matchCount;
                }
            }

            @Override
            public void visitAfter(@NotNull Palette.Group group) {
                if (group == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (this.matchCount > 0) {
                    groups.add(group);
                    matchCounts.add(this.matchCount);
                    matchCounts.set(0, (Integer)matchCounts.get(0) + this.matchCount);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "group";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "item";
                        break;
                    }
                }
                objectArray2[1] = "com/android/tools/idea/uibuilder/palette2/DataModel$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visit";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitAfter";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.updateCategoryModel(groups, matchCounts);
    }

    private void updateCategoryModel(@NotNull List<Palette.Group> groups, @NotNull List<Integer> matchCounts) {
        if (groups == null) {
            DataModel.$$$reportNull$$$0(13);
        }
        if (matchCounts == null) {
            DataModel.$$$reportNull$$$0(14);
        }
        UIUtil.invokeLaterIfNeeded(() -> {
            if (groups == null) {
                DataModel.$$$reportNull$$$0(19);
            }
            if (matchCounts == null) {
                DataModel.$$$reportNull$$$0(20);
            }
            this.myListModel.update(groups, matchCounts);
        });
    }

    private void createUnFilteredItems(@NotNull Palette.Group selectedGroup) {
        if (selectedGroup == null) {
            DataModel.$$$reportNull$$$0(15);
        }
        ArrayList<Palette.Item> items = new ArrayList<Palette.Item>();
        if (selectedGroup != COMMON && selectedGroup != RESULTS) {
            selectedGroup.accept(items::add);
        } else if (this.myListModel.getSize() <= 1) {
            this.myPalette.accept(items::add);
        } else {
            for (String id : this.myFavoriteItems) {
                Palette.Item item = this.myPalette.getItemById(id);
                if (item == null) continue;
                items.add(item);
            }
        }
        this.updateItemModel(items);
    }

    private void createFilteredItems(@NotNull Palette.Group selectedGroup) {
        if (selectedGroup == null) {
            DataModel.$$$reportNull$$$0(16);
        }
        ArrayList<Palette.Item> items = new ArrayList<Palette.Item>();
        Palette.Visitor visitor = item -> {
            if (this.myItemFilter.value(item)) {
                items.add(item);
            }
        };
        if (selectedGroup != COMMON && selectedGroup != RESULTS) {
            selectedGroup.accept(visitor);
        } else {
            this.myPalette.accept(visitor);
        }
        this.updateItemModel(items);
    }

    private void updateItemModel(@NotNull List<Palette.Item> items) {
        if (items == null) {
            DataModel.$$$reportNull$$$0(17);
        }
        UIUtil.invokeLaterIfNeeded(() -> {
            if (items == null) {
                DataModel.$$$reportNull$$$0(18);
            }
            this.myItemModel.update(items);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencyManager";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/palette2/DataModel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layoutType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 7: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedGroup";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 13: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groups";
                break;
            }
            case 14: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchCounts";
                break;
            }
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/palette2/DataModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCategoryListModel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getItemListModel";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilterPattern";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getPalette";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "readFavoriteItems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 11: 
            case 12: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setLayoutType";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setFilterPattern";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "categorySelectionChanged";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isFavoriteItem";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addFavoriteItem";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "removeFavoriteItem";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "updateCategoryModel";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createUnFilteredItems";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createFilteredItems";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "updateItemModel";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "lambda$updateItemModel$2";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "lambda$updateCategoryModel$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

