/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.relative;

import com.android.tools.idea.uibuilder.handlers.relative.ConstraintType;
import com.android.tools.idea.uibuilder.model.Segment;
import com.android.tools.idea.uibuilder.model.TextDirection;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import java.awt.Color;
import org.jetbrains.annotations.Nullable;

class Match {
    public final Segment with;
    public final Segment edge;
    public final int delta;
    public final ConstraintType type;
    public boolean cycle;
    private static final SimpleTextAttributes SNAP_ATTRIBUTES = new SimpleTextAttributes(1, new Color(60, 139, 186));

    Match(Segment edge, Segment with2, ConstraintType type, int delta) {
        this.edge = edge;
        this.with = with2;
        this.type = type;
        this.delta = delta;
    }

    public String getConstraint(boolean generateId) {
        if (this.type.targetParent) {
            return this.type.name + '=' + "true";
        }
        String id = this.edge.id;
        if (id == null || id.length() == -1) {
            if (!generateId) {
                id = "<generated>";
            } else if (this.edge.component != null) {
                id = this.edge.component.ensureId();
            }
        }
        return this.type.name + '=' + "@+id/" + id;
    }

    public String toString() {
        return "Match [type=" + (Object)((Object)this.type) + ", delta=" + this.delta + ", edge=" + this.edge + "]";
    }

    public void describe(SimpleColoredComponent renderer, int margin, String marginAttribute) {
        String constraint = this.getConstraint(false);
        String description = constraint.replace("@+id/", "").replace("@id/", "");
        description = StringUtil.trimStart((String)description, (String)"layout_");
        description = StringUtil.trimEnd((String)description, (String)"=true");
        renderer.append(description, SNAP_ATTRIBUTES);
        if (margin > 0) {
            renderer.append(String.format(", margin=%1$d dp", margin));
        }
    }

    @Nullable
    public String getRtlConstraint(TextDirection textDirection, boolean generateId) {
        switch (this.type) {
            case ALIGN_LEFT: {
                return Match.replaceAttribute(this.getConstraint(generateId), "layout_alignLeft", textDirection.getAttrLeft());
            }
            case LAYOUT_LEFT_OF: {
                return Match.replaceAttribute(this.getConstraint(generateId), "layout_toLeftOf", textDirection.getAttrLeftOf());
            }
            case ALIGN_RIGHT: {
                return Match.replaceAttribute(this.getConstraint(generateId), "layout_alignRight", textDirection.getAttrRight());
            }
            case LAYOUT_RIGHT_OF: {
                return Match.replaceAttribute(this.getConstraint(generateId), "layout_toRightOf", textDirection.getAttrRightOf());
            }
            case ALIGN_PARENT_LEFT: {
                return Match.replaceAttribute(this.getConstraint(generateId), "layout_alignParentLeft", textDirection.getAttrAlignParentLeft());
            }
            case ALIGN_PARENT_RIGHT: {
                return Match.replaceAttribute(this.getConstraint(generateId), "layout_alignParentRight", textDirection.getAttrAlignParentRight());
            }
        }
        return null;
    }

    private static String replaceAttribute(String s, String oldName, String newName2) {
        assert (s.startsWith(oldName)) : s;
        return newName2 + s.substring(oldName.length());
    }
}

