/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint.drawing.decorator;

import com.android.tools.idea.uibuilder.handlers.constraint.drawing.ViewTransform;
import com.android.tools.idea.uibuilder.handlers.constraint.drawing.decorator.TextWidget;
import com.android.tools.idea.uibuilder.handlers.constraint.model.ConstraintWidget;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Stroke;

public class CheckboxWidget
extends TextWidget {
    int[] xp = new int[3];
    int[] yp = new int[3];

    public CheckboxWidget(ConstraintWidget widget, String text) {
        super(widget, text);
        this.mAlignmentY = 4;
        this.mWidget.setMinWidth(32);
        this.mWidget.setMinHeight(32);
    }

    @Override
    protected void wrapContent() {
        if (this.mWidget == null) {
            return;
        }
        if (!TextWidget.DO_WRAP) {
            return;
        }
        super.wrapContent();
        int extra = this.mWidget.getMinHeight() + 2 * this.mHorizontalPadding;
        this.mWidget.setMinWidth(this.mWidget.getMinWidth() + extra);
        this.mWidget.setMinHeight(this.mWidget.getMinHeight());
        this.mWidget.setDimension(0, 0);
    }

    @Override
    public void onPaintBackground(ViewTransform transform2, Graphics2D g) {
        super.onPaintBackground(transform2, g);
        if (this.mColorSet.drawBackground()) {
            int x = transform2.getSwingX(this.mWidget.getDrawX());
            int y = transform2.getSwingY(this.mWidget.getDrawY());
            int h = transform2.getSwingDimension(this.mWidget.getDrawHeight());
            this.drawGraphic(g, x, y, h, transform2);
        }
    }

    public void drawGraphic(Graphics2D g, int x, int y, int h, ViewTransform transform2) {
        Stroke stroke = g.getStroke();
        int strokeWidth = transform2.getSwingDimension(3);
        g.setStroke(new BasicStroke(strokeWidth));
        g.setColor(this.mTextColor.getColor());
        int margin = transform2.getSwingDimension(7);
        g.drawRoundRect(x += margin, y += margin, h -= margin * 2, h, 4, 4);
        margin = transform2.getSwingDimension(6);
        this.xp[0] = x += margin;
        this.xp[1] = x + (h -= margin * 2) / 3;
        this.xp[2] = x + h;
        this.yp[0] = (y += margin) + h / 2;
        this.yp[1] = y + h;
        this.yp[2] = y;
        g.drawPolyline(this.xp, this.yp, 3);
        g.setStroke(stroke);
    }

    @Override
    protected void drawText(ViewTransform transform2, Graphics2D g, int x, int y) {
        int h = this.mWidget.getDrawHeight();
        super.drawText(transform2, g, x + h, y);
    }
}

