/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint;

import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;

public class MarginPopup
extends JPanel {
    private JBTextField myTextField = new JBTextField();
    private JButton[] myHistoryButtons = new JButton[4];
    private int[] myDefaultValues = new int[]{0, 8, 16, 24};
    private int[] myHistoryValues = new int[]{-1, -1, -1, -1};
    ActionListener myListener;
    private int myValue = 8;
    private ActionListener myDefaultListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            JButton b = (JButton)e.getSource();
            String s = b.getText();
            try {
                MarginPopup.this.myValue = Integer.parseInt(s);
            }
            catch (NumberFormatException e1) {
                MarginPopup.this.myValue = 0;
                s = "0";
            }
            if (!s.isEmpty()) {
                MarginPopup.this.myTextField.setText(s);
            }
            if (MarginPopup.this.myListener != null) {
                MarginPopup.this.myListener.actionPerformed(e);
            }
            SwingUtilities.getWindowAncestor(MarginPopup.this).setVisible(false);
        }
    };
    private ActionListener mTextListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            MarginPopup.this.saveNewValue(e);
            SwingUtilities.getWindowAncestor(MarginPopup.this).setVisible(false);
        }
    };

    public int getValue() {
        return this.myValue;
    }

    private boolean isADefault(int value) {
        for (int i = 0; i < this.myDefaultValues.length; ++i) {
            if (this.myDefaultValues[i] != value) continue;
            return true;
        }
        return false;
    }

    public void setActionListener(ActionListener actionListener) {
        this.myListener = actionListener;
    }

    void saveNewValue(ActionEvent e) {
        try {
            int value = this.myValue = Integer.parseInt(this.myTextField.getText());
            if (!this.isADefault(value)) {
                for (int i = 0; i < this.myHistoryValues.length; ++i) {
                    int old = this.myHistoryValues[i];
                    this.myHistoryValues[i] = value;
                    if (value > 0) {
                        this.myHistoryButtons[i].setText(Integer.toString(value));
                    }
                    value = old;
                }
            }
        }
        catch (NumberFormatException e1) {
            e1.printStackTrace();
        }
        if (this.myListener != null) {
            this.myListener.actionPerformed(e);
        }
    }

    public MarginPopup() {
        super(new GridBagLayout());
        int i;
        this.setBackground(JBColor.background());
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = 0;
        gc.gridy = 0;
        gc.gridwidth = 3;
        gc.insets = JBUI.insets((int)10, (int)5, (int)5, (int)0);
        gc.fill = 1;
        this.myTextField.setHorizontalAlignment(4);
        this.myTextField.setText(Integer.toString(this.myValue));
        this.add((Component)this.myTextField, gc);
        gc.gridx = 3;
        gc.gridwidth = 1;
        gc.insets.bottom = JBUI.scale((int)0);
        gc.insets.left = JBUI.scale((int)2);
        gc.insets.right = JBUI.scale((int)5);
        gc.insets.top = JBUI.scale((int)2);
        this.add((Component)new JBLabel("dp"), gc);
        gc.gridwidth = 1;
        gc.gridy = 1;
        gc.insets.bottom = JBUI.scale((int)0);
        gc.insets.left = JBUI.scale((int)0);
        gc.insets.right = JBUI.scale((int)0);
        gc.insets.top = JBUI.scale((int)0);
        ((AbstractDocument)this.myTextField.getDocument()).setDocumentFilter(new DocumentFilter(){

            @Override
            public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
                for (int i = 0; i < text.length(); ++i) {
                    if (Character.isDigit(text.charAt(i))) continue;
                    return;
                }
                super.replace(fb, offset, length, text, attrs);
            }
        });
        gc.fill = 2;
        this.myTextField.addActionListener(this.mTextListener);
        Insets margin = new Insets(0, 0, 0, 0);
        for (i = 0; i < 4; ++i) {
            JButton b = new JButton("" + this.myDefaultValues[i]);
            b.setMargin(margin);
            b.addActionListener(this.myDefaultListener);
            gc.gridx = i;
            gc.insets.left = JBUI.scale((int)(i == 0 ? 5 : 0));
            gc.insets.right = JBUI.scale((int)(i == 3 ? 5 : 0));
            this.add((Component)b, gc);
        }
        gc.gridy = 2;
        gc.insets.bottom = JBUI.scale((int)7);
        for (i = 0; i < this.myHistoryButtons.length; ++i) {
            this.myHistoryButtons[i] = new JButton("XXX");
            this.myHistoryButtons[i].setPreferredSize(this.myHistoryButtons[i].getPreferredSize());
            this.myHistoryButtons[i].setMargin(margin);
            if (this.myHistoryValues[i] > 0) {
                this.myHistoryButtons[i].setText(Integer.toString(this.myHistoryValues[i]));
            } else {
                this.myHistoryButtons[i].setText("");
            }
            this.myHistoryButtons[i].addActionListener(this.myDefaultListener);
            gc.gridx = i;
            gc.insets.left = JBUI.scale((int)(i == 0 ? 5 : 0));
            gc.insets.right = JBUI.scale((int)(i == 3 ? 5 : 0));
            this.add((Component)this.myHistoryButtons[i], gc);
        }
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                MarginPopup.this.saveNewValue(null);
            }
        });
    }

    public JComponent getTextField() {
        return this.myTextField;
    }
}

