/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcechooser;

import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceFile;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.openapi.util.Pair;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class ResourceChooserItem {
    static final String DEFAULT_FOLDER_NAME = "Default";
    @NotNull
    protected final ResourceType myType;
    @NotNull
    protected final String myName;
    private final HashMap<Integer, Icon> myIcons;

    ResourceChooserItem(@NotNull ResourceType type, @NotNull String name) {
        if (type == null) {
            ResourceChooserItem.$$$reportNull$$$0(0);
        }
        if (name == null) {
            ResourceChooserItem.$$$reportNull$$$0(1);
        }
        this.myIcons = Maps.newHashMapWithExpectedSize((int)2);
        this.myType = type;
        this.myName = name;
    }

    @NotNull
    public List<String> getQualifiers() {
        List<String> list = Collections.singletonList(DEFAULT_FOLDER_NAME);
        if (list == null) {
            ResourceChooserItem.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    public ResourceType getType() {
        ResourceType resourceType = this.myType;
        if (resourceType == null) {
            ResourceChooserItem.$$$reportNull$$$0(3);
        }
        return resourceType;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            ResourceChooserItem.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String getQualifiedName() {
        String string = this.isFramework() ? "android:" + this.getName() : this.getName();
        if (string == null) {
            ResourceChooserItem.$$$reportNull$$$0(5);
        }
        return string;
    }

    public File getFile() {
        return null;
    }

    @Nullable
    public String getPath() {
        return null;
    }

    @Nullable
    public String getFileForQualifiers(String qualifiers) {
        return null;
    }

    @NotNull
    public abstract String getResourceUrl();

    @NotNull
    public ResourceValue getResourceValue() {
        ResourceValue resourceValue = new ResourceValue(ResourceUrl.create((ResourceType)this.getType(), (String)this.getName(), (boolean)this.isFramework()), this.getResourceUrl(), null);
        if (resourceValue == null) {
            ResourceChooserItem.$$$reportNull$$$0(6);
        }
        return resourceValue;
    }

    public String toString() {
        return this.getName();
    }

    @Nullable
    public Icon getIcon(int iconSize) {
        return this.myIcons.get(iconSize);
    }

    public void setIcon(@NotNull Icon icon) {
        if (icon == null) {
            ResourceChooserItem.$$$reportNull$$$0(7);
        }
        assert (icon.getIconWidth() == icon.getIconHeight());
        this.myIcons.put(icon.getIconWidth(), icon);
    }

    public abstract boolean isFramework();

    public boolean isAttr() {
        return false;
    }

    public boolean isReference() {
        String s = this.getDefaultValue();
        if (s != null) {
            return s.startsWith("@") || s.startsWith("?");
        }
        return false;
    }

    @Nullable
    public abstract String getDefaultValue();

    @NotNull
    public List<Pair<FolderConfiguration, String>> getQualifiersAndValues() {
        List<Pair<FolderConfiguration, String>> list = Collections.emptyList();
        if (list == null) {
            ResourceChooserItem.$$$reportNull$$$0(8);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/ui/resourcechooser/ResourceChooserItem";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/ui/resourcechooser/ResourceChooserItem";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiers";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceValue";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiersAndValues";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setIcon";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class AttrItem
    extends ResourceChooserItem {
        private boolean myFramework;

        public AttrItem(@NotNull ResourceType type, boolean framework, @NotNull String name) {
            if (type == null) {
                AttrItem.$$$reportNull$$$0(0);
            }
            if (name == null) {
                AttrItem.$$$reportNull$$$0(1);
            }
            super(type, name);
            this.myFramework = framework;
        }

        @Override
        public boolean isAttr() {
            return true;
        }

        @Override
        public boolean isFramework() {
            return this.myFramework;
        }

        @Override
        @NotNull
        public String getResourceUrl() {
            if (this.isFramework()) {
                String string = "?android:" + ResourceType.ATTR.getName() + '/' + this.myName;
                if (string == null) {
                    AttrItem.$$$reportNull$$$0(2);
                }
                return string;
            }
            String string = "?" + ResourceType.ATTR.getName() + '/' + this.myName;
            if (string == null) {
                AttrItem.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        public String toString() {
            return this.getQualifiedName();
        }

        @Override
        public boolean isReference() {
            return true;
        }

        @Override
        public String getDefaultValue() {
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/ui/resourcechooser/ResourceChooserItem$AttrItem";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/ui/resourcechooser/ResourceChooserItem$AttrItem";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getResourceUrl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class ProjectItem
    extends ResourceChooserItem {
        @NotNull
        private final List<com.android.ide.common.res2.ResourceItem> myProjectItems;

        public ProjectItem(@NotNull ResourceType type, @NotNull String name, @NotNull List<com.android.ide.common.res2.ResourceItem> projectItems) {
            if (type == null) {
                ProjectItem.$$$reportNull$$$0(0);
            }
            if (name == null) {
                ProjectItem.$$$reportNull$$$0(1);
            }
            if (projectItems == null) {
                ProjectItem.$$$reportNull$$$0(2);
            }
            super(type, name);
            this.myProjectItems = projectItems;
        }

        @Override
        public boolean isFramework() {
            return false;
        }

        @Override
        public File getFile() {
            return this.myProjectItems.get(0).getFile();
        }

        @Override
        @Nullable
        public String getPath() {
            return this.myProjectItems.get(0).getFile().getPath();
        }

        @Override
        @Nullable
        public String getFileForQualifiers(String qualifiers) {
            for (com.android.ide.common.res2.ResourceItem item : this.myProjectItems) {
                if (!qualifiers.equals(item.getQualifiers())) continue;
                return item.getFile().getPath();
            }
            return null;
        }

        @Override
        @NotNull
        public String getResourceUrl() {
            String string = "@" + this.myType.getName() + '/' + this.myName;
            if (string == null) {
                ProjectItem.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        @NotNull
        public List<String> getQualifiers() {
            HashSet set = Sets.newHashSet();
            for (com.android.ide.common.res2.ResourceItem item : this.myProjectItems) {
                String q = item.getQualifiers();
                if (!q.isEmpty()) {
                    set.add(q);
                    continue;
                }
                set.add(ResourceChooserItem.DEFAULT_FOLDER_NAME);
            }
            ArrayList<String> qualifiers = new ArrayList<String>(set);
            Collections.sort(qualifiers);
            ArrayList<String> arrayList = qualifiers;
            if (arrayList == null) {
                ProjectItem.$$$reportNull$$$0(4);
            }
            return arrayList;
        }

        @Override
        public String getDefaultValue() {
            com.android.ide.common.res2.ResourceItem first = this.myProjectItems.get(0);
            ResourceValue value = first.getResourceValue(false);
            if (value != null) {
                return value.getValue();
            }
            return null;
        }

        @Override
        @NotNull
        public List<Pair<FolderConfiguration, String>> getQualifiersAndValues() {
            ArrayList pairs = Lists.newArrayListWithCapacity((int)this.myProjectItems.size());
            for (com.android.ide.common.res2.ResourceItem item : this.myProjectItems) {
                ResourceValue resourceValue = item.getResourceValue(false);
                FolderConfiguration configuration = item.getConfiguration();
                pairs.add(Pair.create((Object)configuration, (Object)(resourceValue != null ? resourceValue.getValue() : null)));
            }
            ArrayList arrayList = pairs;
            if (arrayList == null) {
                ProjectItem.$$$reportNull$$$0(5);
            }
            return arrayList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "projectItems";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/ui/resourcechooser/ResourceChooserItem$ProjectItem";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/ui/resourcechooser/ResourceChooserItem$ProjectItem";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getResourceUrl";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getQualifiers";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getQualifiersAndValues";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class FrameworkItem
    extends ResourceChooserItem {
        @NotNull
        private final ResourceItem myFrameworkItem;

        public FrameworkItem(@NotNull ResourceType type, @NotNull String name, @NotNull ResourceItem frameworkItem) {
            if (type == null) {
                FrameworkItem.$$$reportNull$$$0(0);
            }
            if (name == null) {
                FrameworkItem.$$$reportNull$$$0(1);
            }
            if (frameworkItem == null) {
                FrameworkItem.$$$reportNull$$$0(2);
            }
            super(type, name);
            this.myFrameworkItem = frameworkItem;
        }

        @Override
        public boolean isFramework() {
            return true;
        }

        @Override
        public File getFile() {
            return new File(((ResourceFile)this.myFrameworkItem.getSourceFileList().get(0)).getFile().getPath());
        }

        @Override
        @Nullable
        public String getPath() {
            return ((ResourceFile)this.myFrameworkItem.getSourceFileList().get(0)).getFile().getPath();
        }

        @Override
        @Nullable
        public String getFileForQualifiers(String qualifiers) {
            for (ResourceFile resourceFile : this.myFrameworkItem.getSourceFileList()) {
                String name = resourceFile.getFolder().getFolder().getName();
                if (!name.endsWith(qualifiers) || !qualifiers.equals(name.substring(name.indexOf(45) + 1))) continue;
                return resourceFile.getFile().getPath();
            }
            return null;
        }

        @Override
        @NotNull
        public String getResourceUrl() {
            String string = "@android:" + this.myType.getName() + '/' + this.myName;
            if (string == null) {
                FrameworkItem.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        @NotNull
        public List<String> getQualifiers() {
            HashSet set = Sets.newHashSet();
            for (ResourceFile resourceFile : this.myFrameworkItem.getSourceFileList()) {
                String folder = resourceFile.getFolder().getFolder().getName();
                int index = folder.indexOf(45);
                if (index == -1) {
                    set.add(ResourceChooserItem.DEFAULT_FOLDER_NAME);
                    continue;
                }
                set.add(folder.substring(index + 1));
            }
            ArrayList<String> qualifiers = new ArrayList<String>(set);
            Collections.sort(qualifiers);
            ArrayList<String> arrayList = qualifiers;
            if (arrayList == null) {
                FrameworkItem.$$$reportNull$$$0(4);
            }
            return arrayList;
        }

        @Override
        public String getDefaultValue() {
            ResourceValue value;
            ResourceFile file = null;
            for (ResourceFile resourceFile : this.myFrameworkItem.getSourceFileList()) {
                FolderConfiguration configuration = resourceFile.getConfiguration();
                if (!configuration.isDefault()) continue;
                file = resourceFile;
                break;
            }
            if (file == null) {
                file = (ResourceFile)this.myFrameworkItem.getSourceFileList().get(0);
            }
            if ((value = file.getValue(this.getType(), this.getName())) != null) {
                return value.getValue();
            }
            return null;
        }

        @Override
        @NotNull
        public List<Pair<FolderConfiguration, String>> getQualifiersAndValues() {
            List sourceFileList = this.myFrameworkItem.getSourceFileList();
            ArrayList pairs = Lists.newArrayListWithCapacity((int)sourceFileList.size());
            ResourceType type = this.getType();
            String name = this.getName();
            for (ResourceFile resourceFile : sourceFileList) {
                ResourceValue resourceValue = resourceFile.getValue(type, name);
                FolderConfiguration configuration = resourceFile.getConfiguration();
                pairs.add(Pair.create((Object)configuration, (Object)(resourceValue != null ? resourceValue.getValue() : null)));
            }
            ArrayList arrayList = pairs;
            if (arrayList == null) {
                FrameworkItem.$$$reportNull$$$0(5);
            }
            return arrayList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "frameworkItem";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/ui/resourcechooser/ResourceChooserItem$FrameworkItem";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/ui/resourcechooser/ResourceChooserItem$FrameworkItem";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getResourceUrl";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getQualifiers";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getQualifiersAndValues";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

