/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.structure.services;

import com.android.tools.idea.structure.services.BuildSystemOperationsLookup;
import com.android.tools.idea.structure.services.DeveloperService;
import com.android.tools.idea.structure.services.DeveloperServiceCreator;
import com.android.tools.idea.structure.services.DeveloperServiceCreators;
import com.android.tools.idea.structure.services.ServiceCategory;
import com.google.common.base.Predicate;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.util.messages.MessageBusConnection;
import org.jetbrains.annotations.NotNull;

public final class DeveloperServices {
    private static final Logger LOG = Logger.getInstance(DeveloperService.class);
    private static Multimap<Module, DeveloperService> ourServices = ArrayListMultimap.create();

    public static Iterable<DeveloperService> getAll(@NotNull Module module) {
        if (module == null) {
            DeveloperServices.$$$reportNull$$$0(0);
        }
        DeveloperServices.initializeFor(module);
        return ourServices.get((Object)module);
    }

    @NotNull
    public static Iterable<DeveloperService> getFor(@NotNull Module module, final ServiceCategory category) {
        if (module == null) {
            DeveloperServices.$$$reportNull$$$0(1);
        }
        Iterable iterable = Iterables.filter(DeveloperServices.getAll(module), (Predicate)new Predicate<DeveloperService>(){

            public boolean apply(DeveloperService service) {
                return service.getCategory() == category;
            }
        });
        if (iterable == null) {
            DeveloperServices.$$$reportNull$$$0(2);
        }
        return iterable;
    }

    private static void initializeFor(final @NotNull Module module) {
        if (module == null) {
            DeveloperServices.$$$reportNull$$$0(3);
        }
        if (ourServices.containsKey((Object)module)) {
            return;
        }
        for (DeveloperServiceCreators creators : (DeveloperServiceCreators[])DeveloperServiceCreators.EP_NAME.getExtensions()) {
            try {
                for (DeveloperServiceCreator developerServiceCreator : creators.getCreators()) {
                    DeveloperService service = developerServiceCreator.createService(module);
                    if (service == null) continue;
                    ourServices.put((Object)module, (Object)service);
                }
            }
            catch (Exception e) {
                LOG.warn("Caught exception while initializing services", (Throwable)e);
            }
        }
        BuildSystemOperationsLookup.getBuildSystemOperations(module.getProject()).initializeServices(module, new Runnable(){

            @Override
            public void run() {
                for (DeveloperService service : ourServices.get((Object)module)) {
                    service.updateInstalledState();
                }
            }
        });
        MessageBusConnection connection2 = module.getMessageBus().connect((Disposable)module);
        connection2.subscribe(ProjectTopics.MODULES, (Object)new ModuleListener(){

            public void moduleRemoved(@NotNull Project project, @NotNull Module moduleRemoved) {
                if (project == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (moduleRemoved == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (module == moduleRemoved) {
                    ourServices.removeAll((Object)module);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "moduleRemoved";
                        break;
                    }
                }
                objectArray[1] = "com/android/tools/idea/structure/services/DeveloperServices$3";
                objectArray[2] = "moduleRemoved";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/structure/services/DeveloperServices";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/structure/services/DeveloperServices";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAll";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getFor";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "initializeFor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

