/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.stats;

import com.android.ddmlib.IDevice;
import com.android.tools.analytics.CommonMetricsData;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.stats.AnonymizerUtil;
import com.google.common.base.Strings;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.DeviceInfo;
import com.google.wireless.android.sdk.stats.ProductDetails;
import com.google.wireless.android.sdk.stats.StudioProjectChange;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.impl.ProjectLifecycleListener;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.util.messages.MessageBusConnection;
import java.io.File;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class AndroidStudioUsageTracker {
    public static void setup(ScheduledExecutorService scheduler) {
        scheduler.scheduleWithFixedDelay(AndroidStudioUsageTracker::runDailyReports, 0L, 1L, TimeUnit.DAYS);
        scheduler.scheduleWithFixedDelay(AndroidStudioUsageTracker::runHourlyReports, 0L, 1L, TimeUnit.HOURS);
        AndroidStudioUsageTracker.subscribeToEvents();
    }

    private static void subscribeToEvents() {
        Application app = ApplicationManager.getApplication();
        MessageBusConnection connection2 = app.getMessageBus().connect();
        connection2.subscribe(ProjectLifecycleListener.TOPIC, (Object)new ProjectLifecycleTracker());
    }

    private static void runDailyReports() {
        ApplicationInfo application = ApplicationInfo.getInstance();
        UsageTracker.getInstance().log(AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.PING).setKind(AndroidStudioEvent.EventKind.STUDIO_PING).setProductDetails(ProductDetails.newBuilder().setProduct(ProductDetails.ProductKind.STUDIO).setBuild(application.getBuild().asString()).setVersion(application.getStrictVersion()).setOsArchitecture(CommonMetricsData.getOsArchitecture()).setChannel(AndroidStudioUsageTracker.lifecycleChannelFromUpdateSettings())).setMachineDetails(CommonMetricsData.getMachineDetails((File)new File(PathManager.getHomePath()))).setJvmDetails(CommonMetricsData.getJvmDetails()));
    }

    private static void runHourlyReports() {
        UsageTracker.getInstance().log(AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.SYSTEM).setKind(AndroidStudioEvent.EventKind.STUDIO_PROCESS_STATS).setJavaProcessStats(CommonMetricsData.getJavaProcessStats()));
    }

    @Deprecated
    @NotNull
    public static String anonymizeUtf8(@NotNull String value) {
        if (value == null) {
            AndroidStudioUsageTracker.$$$reportNull$$$0(0);
        }
        String string = AnonymizerUtil.anonymizeUtf8((String)value);
        if (string == null) {
            AndroidStudioUsageTracker.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public static DeviceInfo deviceToDeviceInfo(@NotNull IDevice device) {
        if (device == null) {
            AndroidStudioUsageTracker.$$$reportNull$$$0(2);
        }
        DeviceInfo deviceInfo = DeviceInfo.newBuilder().setAnonymizedSerialNumber(AnonymizerUtil.anonymizeUtf8((String)device.getSerialNumber())).setBuildTags(Strings.nullToEmpty((String)device.getProperty("ro.build.tags"))).setBuildType(Strings.nullToEmpty((String)device.getProperty("ro.build.type"))).setBuildVersionRelease(Strings.nullToEmpty((String)device.getProperty("ro.build.version.release"))).setBuildApiLevelFull(Strings.nullToEmpty((String)device.getProperty("ro.build.version.sdk"))).setCpuAbi(CommonMetricsData.applicationBinaryInterfaceFromString((String)device.getProperty("ro.product.cpu.abi"))).setManufacturer(Strings.nullToEmpty((String)device.getProperty("ro.product.manufacturer"))).setDeviceType(device.isEmulator() ? DeviceInfo.DeviceType.LOCAL_EMULATOR : DeviceInfo.DeviceType.LOCAL_PHYSICAL).setModel(Strings.nullToEmpty((String)device.getProperty("ro.product.model"))).build();
        if (deviceInfo == null) {
            AndroidStudioUsageTracker.$$$reportNull$$$0(3);
        }
        return deviceInfo;
    }

    @NotNull
    public static DeviceInfo deviceToDeviceInfoApilLevelOnly(@NotNull IDevice device) {
        if (device == null) {
            AndroidStudioUsageTracker.$$$reportNull$$$0(4);
        }
        DeviceInfo deviceInfo = DeviceInfo.newBuilder().setBuildApiLevelFull(Strings.nullToEmpty((String)device.getProperty("ro.build.version.sdk"))).build();
        if (deviceInfo == null) {
            AndroidStudioUsageTracker.$$$reportNull$$$0(5);
        }
        return deviceInfo;
    }

    private static ProductDetails.SoftwareLifeCycleChannel lifecycleChannelFromUpdateSettings() {
        switch (UpdateSettings.getInstance().getSelectedChannelStatus()) {
            case EAP: {
                return ProductDetails.SoftwareLifeCycleChannel.CANARY;
            }
            case MILESTONE: {
                return ProductDetails.SoftwareLifeCycleChannel.DEV;
            }
            case BETA: {
                return ProductDetails.SoftwareLifeCycleChannel.BETA;
            }
            case RELEASE: {
                return ProductDetails.SoftwareLifeCycleChannel.STABLE;
            }
        }
        return ProductDetails.SoftwareLifeCycleChannel.UNKNOWN_LIFE_CYCLE_CHANNEL;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/stats/AndroidStudioUsageTracker";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/stats/AndroidStudioUsageTracker";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "anonymizeUtf8";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "deviceToDeviceInfo";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "deviceToDeviceInfoApilLevelOnly";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "anonymizeUtf8";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "deviceToDeviceInfo";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "deviceToDeviceInfoApilLevelOnly";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ProjectLifecycleTracker
    implements ProjectLifecycleListener {
        private ProjectLifecycleTracker() {
        }

        public void beforeProjectLoaded(@NotNull Project project) {
            if (project == null) {
                ProjectLifecycleTracker.$$$reportNull$$$0(0);
            }
            int projectsOpen = ProjectManager.getInstance().getOpenProjects().length;
            UsageTracker.getInstance().log(AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.STUDIO_PROJECT_OPENED).setStudioProjectChange(StudioProjectChange.newBuilder().setProjectsOpen(projectsOpen)));
        }

        public void afterProjectClosed(@NotNull Project project) {
            if (project == null) {
                ProjectLifecycleTracker.$$$reportNull$$$0(1);
            }
            int projectsOpen = ProjectManager.getInstance().getOpenProjects().length;
            UsageTracker.getInstance().log(AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.STUDIO_PROJECT_CLOSED).setStudioProjectChange(StudioProjectChange.newBuilder().setProjectsOpen(projectsOpen)));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "project";
            objectArray2[1] = "com/android/tools/idea/stats/AndroidStudioUsageTracker$ProjectLifecycleTracker";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeProjectLoaded";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "afterProjectClosed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

