/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.editor;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.plugin.AndroidPluginGeneration;
import com.android.tools.idea.gradle.plugin.AndroidPluginVersionUpdater;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.projectsystem.ProjectSystemSyncManager;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.run.editor.ProfilerState;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.SettableFuture;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.concurrent.Future;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class AndroidProfilersPanel
implements HyperlinkListener {
    private static final String MINIMUM_GRADLE_PLUGIN_VERSION_STRING = "2.4.0";
    private static final GradleVersion MINIMUM_GRADLE_PLUGIN_VERSION = GradleVersion.parse((String)"2.4.0");
    private final Project myProject;
    private JPanel myDescription;
    private JCheckBox myAdvancedProfilingCheckBox;
    private HyperlinkLabel myHyperlinkLabel;
    private JTextPane myAdvancedProfilingDescription;
    private JLabel mySyncStatusMessage;

    public JComponent getComponent() {
        return this.myDescription;
    }

    AndroidProfilersPanel(Project project, ProfilerState state) {
        this.myProject = project;
        this.$$$setupUI$$$();
        this.updateHyperlink("");
        this.resetFrom(state);
    }

    void resetFrom(ProfilerState state) {
        boolean enabled = this.myAdvancedProfilingCheckBox.isEnabled();
        this.myAdvancedProfilingDescription.setBackground(this.myDescription.getBackground());
        this.myAdvancedProfilingCheckBox.setSelected(enabled && state.ADVANCED_PROFILING_ENABLED);
    }

    void applyTo(ProfilerState state) {
        state.ADVANCED_PROFILING_ENABLED = (Boolean)StudioFlags.PROFILER_ENABLED.get() != false && this.myAdvancedProfilingCheckBox.isSelected();
    }

    private void createUIComponents() {
        this.myHyperlinkLabel = new HyperlinkLabel();
        this.myHyperlinkLabel.addHyperlinkListener((HyperlinkListener)this);
    }

    private void updateHyperlink(String message) {
        boolean supported = true;
        for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            AndroidModuleModel model = AndroidModuleModel.get(module);
            if (model == null) continue;
            GradleVersion modelVersion = model.getModelVersion();
            boolean bl = supported = modelVersion != null && modelVersion.compareIgnoringQualifiers(MINIMUM_GRADLE_PLUGIN_VERSION) >= 0;
            if (!supported) break;
        }
        this.myHyperlinkLabel.setHyperlinkText("This feature can only be enabled with a gradle plugin version of 2.4 or greater. ", "Update project", "");
        this.myHyperlinkLabel.setVisible(!supported);
        this.mySyncStatusMessage.setText(message);
        this.myHyperlinkLabel.setVisible(!supported);
        this.myDescription.setEnabled(supported);
        this.myAdvancedProfilingCheckBox.setEnabled(supported);
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        GradleVersion gradleVersion = GradleVersion.parse((String)"4.4");
        GradleVersion pluginVersion = GradleVersion.parse((String)AndroidPluginGeneration.ORIGINAL.getLatestKnownVersion());
        if (MINIMUM_GRADLE_PLUGIN_VERSION.compareIgnoringQualifiers(pluginVersion) > 0) {
            this.updateHyperlink("(No matching gradle version found)");
            return;
        }
        AndroidPluginVersionUpdater updater = AndroidPluginVersionUpdater.getInstance(this.myProject);
        AndroidPluginVersionUpdater.UpdateResult result = updater.updatePluginVersion(pluginVersion, gradleVersion);
        if (result.isPluginVersionUpdated() && result.versionUpdateSuccess()) {
            this.requestSync();
        } else {
            this.updateHyperlink("(Update failed)");
        }
    }

    private void requestSync() {
        SettableFuture syncResult = SettableFuture.create();
        ApplicationManager.getApplication().invokeLater(() -> {
            this.updateHyperlink("(Syncing...)");
            syncResult.setFuture(ProjectSystemUtil.getProjectSystem(this.myProject).getSyncManager().syncProject(ProjectSystemSyncManager.SyncReason.PROJECT_MODIFIED, true));
        });
        if (((ProjectSystemSyncManager.SyncResult)((Object)Futures.getUnchecked((Future)syncResult))).isSuccessful()) {
            this.updateHyperlink("");
        } else {
            this.updateHyperlink("(Sync failed)");
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JTextPane jTextPane;
        JCheckBox jCheckBox;
        JPanel jPanel;
        this.createUIComponents();
        this.myDescription = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(10, 10, 10, 10), -1, -1, false, false));
        this.myAdvancedProfilingCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Enable advanced profiling (required for API level < 26 only)");
        jPanel.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myAdvancedProfilingDescription = jTextPane = new JTextPane();
        jTextPane.setEditable(false);
        jTextPane.setText("Allows the profilers to track data such as network payloads, application events and object counts, but it might have a minor performance impact on your build speeds. ");
        jPanel.add((Component)jTextPane, new GridConstraints(1, 0, 1, 1, 0, 3, 6, 2, null, new Dimension(150, 50), null));
        HyperlinkLabel hyperlinkLabel = this.myHyperlinkLabel;
        jPanel.add((Component)hyperlinkLabel, new GridConstraints(2, 0, 1, 1, 9, 0, 7, 3, null, new Dimension(150, 20), null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.mySyncStatusMessage = jLabel = new JLabel();
        jLabel.setText("Label");
        jPanel.add((Component)jLabel, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myDescription;
    }
}

