/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.build.OutputFile;
import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidArtifactOutput;
import com.android.builder.model.InstantAppProjectBuildOutput;
import com.android.builder.model.InstantAppVariantBuildOutput;
import com.android.builder.model.ProjectBuildOutput;
import com.android.builder.model.TestVariantBuildOutput;
import com.android.builder.model.TestedTargetVariant;
import com.android.builder.model.Variant;
import com.android.builder.model.VariantBuildOutput;
import com.android.ddmlib.IDevice;
import com.android.ide.common.gradle.model.IdeAndroidArtifact;
import com.android.ide.common.gradle.model.IdeVariant;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.apk.analyzer.AaptInvoker;
import com.android.tools.apk.analyzer.AndroidApplicationInfo;
import com.android.tools.apk.analyzer.Archive;
import com.android.tools.apk.analyzer.Archives;
import com.android.tools.idea.apk.viewer.ApkParser;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.run.PostBuildModel;
import com.android.tools.idea.gradle.run.PostBuildModelProvider;
import com.android.tools.idea.gradle.structure.editors.AndroidProjectSettingsService;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.log.LogWrapper;
import com.android.tools.idea.run.ApkInfo;
import com.android.tools.idea.run.ApkProvider;
import com.android.tools.idea.run.ApkProviderUtil;
import com.android.tools.idea.run.ApkProvisionException;
import com.android.tools.idea.run.ApplicationIdProvider;
import com.android.tools.idea.run.BestOutputFinder;
import com.android.tools.idea.run.ValidationError;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.utils.ILogger;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public class GradleApkProvider
implements ApkProvider {
    @NotNull
    private final AndroidFacet myFacet;
    @NotNull
    private final ApplicationIdProvider myApplicationIdProvider;
    @NotNull
    private final PostBuildModelProvider myOutputModelProvider;
    @NotNull
    private final BestOutputFinder myBestOutputFinder;
    private final boolean myTest;

    public GradleApkProvider(@NotNull AndroidFacet facet, @NotNull ApplicationIdProvider applicationIdProvider, boolean test) {
        if (facet == null) {
            GradleApkProvider.$$$reportNull$$$0(0);
        }
        if (applicationIdProvider == null) {
            GradleApkProvider.$$$reportNull$$$0(1);
        }
        this(facet, applicationIdProvider, () -> null, test);
    }

    public GradleApkProvider(@NotNull AndroidFacet facet, @NotNull ApplicationIdProvider applicationIdProvider, @NotNull PostBuildModelProvider outputModelProvider, boolean test) {
        if (facet == null) {
            GradleApkProvider.$$$reportNull$$$0(2);
        }
        if (applicationIdProvider == null) {
            GradleApkProvider.$$$reportNull$$$0(3);
        }
        if (outputModelProvider == null) {
            GradleApkProvider.$$$reportNull$$$0(4);
        }
        this(facet, applicationIdProvider, outputModelProvider, new BestOutputFinder(), test);
    }

    @VisibleForTesting
    GradleApkProvider(@NotNull AndroidFacet facet, @NotNull ApplicationIdProvider applicationIdProvider, @NotNull PostBuildModelProvider outputModelProvider, @NotNull BestOutputFinder bestOutputFinder, boolean test) {
        if (facet == null) {
            GradleApkProvider.$$$reportNull$$$0(5);
        }
        if (applicationIdProvider == null) {
            GradleApkProvider.$$$reportNull$$$0(6);
        }
        if (outputModelProvider == null) {
            GradleApkProvider.$$$reportNull$$$0(7);
        }
        if (bestOutputFinder == null) {
            GradleApkProvider.$$$reportNull$$$0(8);
        }
        this.myFacet = facet;
        this.myApplicationIdProvider = applicationIdProvider;
        this.myOutputModelProvider = outputModelProvider;
        this.myBestOutputFinder = bestOutputFinder;
        this.myTest = test;
    }

    @Override
    @NotNull
    public Collection<ApkInfo> getApks(@NotNull IDevice device) throws ApkProvisionException {
        AndroidModuleModel androidModel;
        if (device == null) {
            GradleApkProvider.$$$reportNull$$$0(9);
        }
        if ((androidModel = AndroidModuleModel.get(this.myFacet)) == null) {
            GradleApkProvider.getLogger().warn("Android model is null. Sync might have failed");
            List<ApkInfo> list = Collections.emptyList();
            if (list == null) {
                GradleApkProvider.$$$reportNull$$$0(10);
            }
            return list;
        }
        IdeVariant selectedVariant = androidModel.getSelectedVariant();
        ArrayList<ApkInfo> apkList = new ArrayList<ApkInfo>();
        int projectType = androidModel.getAndroidProject().getProjectType();
        if (projectType == 0 || projectType == 4 || projectType == 2) {
            File apk = this.getApk(selectedVariant, device, this.myFacet, false);
            String pkgName = projectType == 2 ? this.myApplicationIdProvider.getTestPackageName() : this.myApplicationIdProvider.getPackageName();
            apkList.add(new ApkInfo(apk, pkgName));
        }
        apkList.addAll(GradleApkProvider.getAdditionalApks((AndroidArtifact)selectedVariant.getMainArtifact()));
        if (this.myTest) {
            if (projectType == 2) {
                if (androidModel.getFeatures().isTestedTargetVariantsSupported()) {
                    apkList.addAll(0, this.getTargetedApks(selectedVariant, device));
                }
            } else {
                IdeAndroidArtifact testArtifactInfo = androidModel.getSelectedVariant().getAndroidTestArtifact();
                if (testArtifactInfo != null) {
                    File testApk = this.getApk(androidModel.getSelectedVariant(), device, this.myFacet, true);
                    String testPackageName = this.myApplicationIdProvider.getTestPackageName();
                    assert (testPackageName != null);
                    apkList.add(new ApkInfo(testApk, testPackageName));
                    apkList.addAll(GradleApkProvider.getAdditionalApks((AndroidArtifact)testArtifactInfo));
                }
            }
        }
        ArrayList<ApkInfo> arrayList = apkList;
        if (arrayList == null) {
            GradleApkProvider.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    @NotNull
    private static List<ApkInfo> getAdditionalApks(@NotNull AndroidArtifact testArtifactInfo) {
        if (testArtifactInfo == null) {
            GradleApkProvider.$$$reportNull$$$0(12);
        }
        ArrayList<ApkInfo> result = new ArrayList<ApkInfo>();
        for (File fileApk : testArtifactInfo.getAdditionalRuntimeApks()) {
            try {
                String packageId = GradleApkProvider.getPackageId(fileApk);
                result.add(new ApkInfo(fileApk, packageId));
            }
            catch (ApkProvisionException e) {
                GradleApkProvider.getLogger().error("Failed to get the package name from the given file. Therefore, we are not be able to install it. Please install it manually: " + fileApk.getName() + " error: " + e.getMessage(), (Throwable)e);
            }
        }
        ArrayList<ApkInfo> arrayList = result;
        if (arrayList == null) {
            GradleApkProvider.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    private static Path getPathToAapt() {
        AndroidSdkHandler handler = AndroidSdks.getInstance().tryToChooseSdkHandler();
        return AaptInvoker.getPathToAapt((AndroidSdkHandler)handler, (ILogger)new LogWrapper(GradleApkProvider.class));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getPackageId(@NotNull File fileApk) throws ApkProvisionException {
        if (fileApk == null) {
            GradleApkProvider.$$$reportNull$$$0(14);
        }
        try (Archive archive = Archives.open((Path)fileApk.toPath());){
            AndroidApplicationInfo applicationInfo = ApkParser.getAppInfo(GradleApkProvider.getPathToAapt(), archive);
            if (applicationInfo == AndroidApplicationInfo.UNKNOWN) {
                throw new ApkProvisionException("Could not determine manifest package for apk: " + fileApk.getName());
            }
            String string = applicationInfo.packageId;
            return string;
        }
        catch (IOException e) {
            throw new ApkProvisionException("Could not determine manifest package for apk: " + fileApk.getName(), e.getCause());
        }
    }

    @VisibleForTesting
    @NotNull
    File getApk(@NotNull IdeVariant variant, @NotNull IDevice device, @NotNull AndroidFacet facet, boolean fromTestArtifact) throws ApkProvisionException {
        if (variant == null) {
            GradleApkProvider.$$$reportNull$$$0(15);
        }
        if (device == null) {
            GradleApkProvider.$$$reportNull$$$0(16);
        }
        if (facet == null) {
            GradleApkProvider.$$$reportNull$$$0(17);
        }
        AndroidModuleModel androidModel = AndroidModuleModel.get(facet);
        assert (androidModel != null);
        if (androidModel.getFeatures().isPostBuildSyncSupported()) {
            File file = this.getApkFromPostBuildSync(variant, device, facet, fromTestArtifact);
            if (file == null) {
                GradleApkProvider.$$$reportNull$$$0(18);
            }
            return file;
        }
        File file = this.getApkFromPreBuildSync(variant, device, fromTestArtifact);
        if (file == null) {
            GradleApkProvider.$$$reportNull$$$0(19);
        }
        return file;
    }

    @NotNull
    @VisibleForTesting
    File getApkFromPreBuildSync(@NotNull IdeVariant variant, @NotNull IDevice device, boolean fromTestArtifact) throws ApkProvisionException {
        IdeAndroidArtifact artifact;
        if (variant == null) {
            GradleApkProvider.$$$reportNull$$$0(20);
        }
        if (device == null) {
            GradleApkProvider.$$$reportNull$$$0(21);
        }
        IdeAndroidArtifact ideAndroidArtifact = artifact = fromTestArtifact ? variant.getAndroidTestArtifact() : variant.getMainArtifact();
        assert (artifact != null);
        ArrayList outputs = new ArrayList(artifact.getOutputs());
        File file = this.getBestOutput(variant, device, outputs);
        if (file == null) {
            GradleApkProvider.$$$reportNull$$$0(22);
        }
        return file;
    }

    @NotNull
    @VisibleForTesting
    File getApkFromPostBuildSync(@NotNull IdeVariant variant, @NotNull IDevice device, @NotNull AndroidFacet facet, boolean fromTestArtifact) throws ApkProvisionException {
        if (variant == null) {
            GradleApkProvider.$$$reportNull$$$0(23);
        }
        if (device == null) {
            GradleApkProvider.$$$reportNull$$$0(24);
        }
        if (facet == null) {
            GradleApkProvider.$$$reportNull$$$0(25);
        }
        ArrayList<OutputFile> outputs = new ArrayList<OutputFile>();
        PostBuildModel outputModels = this.myOutputModelProvider.getPostBuildModel();
        if (outputModels == null) {
            File file = this.getApkFromPreBuildSync(variant, device, fromTestArtifact);
            if (file == null) {
                GradleApkProvider.$$$reportNull$$$0(26);
            }
            return file;
        }
        if (facet.getProjectType() == 4) {
            InstantAppProjectBuildOutput outputModel = outputModels.findInstantAppProjectBuildOutput(facet);
            if (outputModel == null) {
                throw new ApkProvisionException("Couldn't get post build model for Instant Apps. Please, make sure to use plugin 3.0.0-alpha10 or later.");
            }
            for (InstantAppVariantBuildOutput instantAppVariantBuildOutput : outputModel.getInstantAppVariantsBuildOutput()) {
                if (!instantAppVariantBuildOutput.getName().equals(variant.getName())) continue;
                outputs.add(instantAppVariantBuildOutput.getOutput());
            }
        } else {
            ProjectBuildOutput outputModel = outputModels.findProjectBuildOutput(facet);
            if (outputModel == null) {
                File file = this.getApkFromPreBuildSync(variant, device, fromTestArtifact);
                if (file == null) {
                    GradleApkProvider.$$$reportNull$$$0(27);
                }
                return file;
            }
            for (VariantBuildOutput variantBuildOutput : outputModel.getVariantsBuildOutput()) {
                if (!variantBuildOutput.getName().equals(variant.getName())) continue;
                if (fromTestArtifact) {
                    for (TestVariantBuildOutput testVariantBuildOutput : variantBuildOutput.getTestingVariants()) {
                        if (!testVariantBuildOutput.getType().equals(TestVariantBuildOutput.ANDROID_TEST)) continue;
                        outputs.addAll(testVariantBuildOutput.getOutputs());
                    }
                    continue;
                }
                outputs.addAll(variantBuildOutput.getOutputs());
            }
        }
        File file = outputs.isEmpty() ? this.getApkFromPreBuildSync(variant, device, fromTestArtifact) : this.getBestOutput(variant, device, outputs);
        if (file == null) {
            GradleApkProvider.$$$reportNull$$$0(28);
        }
        return file;
    }

    @NotNull
    private File getBestOutput(@NotNull IdeVariant variant, @NotNull IDevice device, @NotNull List<? extends OutputFile> outputs) throws ApkProvisionException {
        if (variant == null) {
            GradleApkProvider.$$$reportNull$$$0(29);
        }
        if (device == null) {
            GradleApkProvider.$$$reportNull$$$0(30);
        }
        if (outputs == null) {
            GradleApkProvider.$$$reportNull$$$0(31);
        }
        if (outputs.isEmpty()) {
            throw new ApkProvisionException("No outputs for the main artifact of variant: " + variant.getDisplayName());
        }
        List<OutputFile> apkFiles = this.myBestOutputFinder.findBestOutput((Variant)variant, device, outputs);
        File file = apkFiles.get(0).getOutputFile();
        if (file == null) {
            GradleApkProvider.$$$reportNull$$$0(32);
        }
        return file;
    }

    @NotNull
    private List<ApkInfo> getTargetedApks(@NotNull IdeVariant selectedVariant, @NotNull IDevice device) throws ApkProvisionException {
        if (selectedVariant == null) {
            GradleApkProvider.$$$reportNull$$$0(33);
        }
        if (device == null) {
            GradleApkProvider.$$$reportNull$$$0(34);
        }
        ArrayList<ApkInfo> targetedApks = new ArrayList<ApkInfo>();
        for (TestedTargetVariant testedVariant : selectedVariant.getTestedTargetVariants()) {
            String targetGradlePath = testedVariant.getTargetProjectPath();
            Module targetModule = (Module)ApplicationManager.getApplication().runReadAction(() -> {
                Project project = this.myFacet.getModule().getProject();
                return GradleUtil.findModuleByGradlePath(project, targetGradlePath);
            });
            if (targetModule == null) {
                GradleApkProvider.getLogger().warn(String.format("Module not found for gradle path %s. Please install tested apk manually.", targetGradlePath));
                continue;
            }
            AndroidFacet targetFacet = AndroidFacet.getInstance(targetModule);
            if (targetFacet == null) {
                GradleApkProvider.getLogger().warn("Android facet for tested module is null. Please install tested apk manually.");
                continue;
            }
            AndroidModuleModel targetAndroidModel = AndroidModuleModel.get(targetModule);
            if (targetAndroidModel == null) {
                GradleApkProvider.getLogger().warn("Android model for tested module is null. Sync might have failed.");
                continue;
            }
            IdeVariant targetVariant = (IdeVariant)targetAndroidModel.findVariantByName(testedVariant.getTargetVariant());
            if (targetVariant == null) {
                GradleApkProvider.getLogger().warn("Tested variant not found. Sync might have failed.");
                continue;
            }
            File targetApk = this.getApk(targetVariant, device, targetFacet, false);
            String applicationId2 = targetVariant.getMergedFlavor().getApplicationId();
            if (applicationId2 == null) {
                applicationId2 = ApkProviderUtil.computePackageName(targetFacet);
            }
            targetedApks.add(new ApkInfo(targetApk, applicationId2));
        }
        ArrayList<ApkInfo> arrayList = targetedApks;
        if (arrayList == null) {
            GradleApkProvider.$$$reportNull$$$0(35);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public List<ValidationError> validate() {
        AndroidModuleModel androidModuleModel = AndroidModuleModel.get(this.myFacet);
        assert (androidModuleModel != null);
        if (androidModuleModel.getAndroidProject().getProjectType() == 4 || androidModuleModel.getMainArtifact().isSigned()) {
            ImmutableList immutableList = ImmutableList.of();
            if (immutableList == null) {
                GradleApkProvider.$$$reportNull$$$0(36);
            }
            return immutableList;
        }
        AndroidArtifactOutput output = GradleUtil.getOutput((AndroidArtifact)androidModuleModel.getMainArtifact());
        String message = AndroidBundle.message("run.error.apk.not.signed", output.getMainOutputFile().getOutputFile().getName(), androidModuleModel.getSelectedVariant().getDisplayName());
        Runnable quickFix = () -> {
            Module module = this.myFacet.getModule();
            ProjectSettingsService service = ProjectSettingsService.getInstance((Project)module.getProject());
            if (service instanceof AndroidProjectSettingsService) {
                ((AndroidProjectSettingsService)service).openSigningConfiguration(module);
            } else {
                service.openModuleSettings(module);
            }
        };
        ImmutableList immutableList = ImmutableList.of((Object)ValidationError.fatal(message, quickFix));
        if (immutableList == null) {
            GradleApkProvider.$$$reportNull$$$0(37);
        }
        return immutableList;
    }

    @NotNull
    private static Logger getLogger() {
        Logger logger = Logger.getInstance(GradleApkProvider.class);
        if (logger == null) {
            GradleApkProvider.$$$reportNull$$$0(38);
        }
        return logger;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: 
            case 13: 
            case 18: 
            case 19: 
            case 22: 
            case 26: 
            case 27: 
            case 28: 
            case 32: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: 
            case 13: 
            case 18: 
            case 19: 
            case 22: 
            case 26: 
            case 27: 
            case 28: 
            case 32: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicationIdProvider";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputModelProvider";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bestOutputFinder";
                break;
            }
            case 9: 
            case 16: 
            case 21: 
            case 24: 
            case 30: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 10: 
            case 11: 
            case 13: 
            case 18: 
            case 19: 
            case 22: 
            case 26: 
            case 27: 
            case 28: 
            case 32: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/run/GradleApkProvider";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testArtifactInfo";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileApk";
                break;
            }
            case 15: 
            case 20: 
            case 23: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variant";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputs";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedVariant";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/run/GradleApkProvider";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getApks";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalApks";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getApk";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getApkFromPreBuildSync";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getApkFromPostBuildSync";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getBestOutput";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetedApks";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "validate";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getApks";
                break;
            }
            case 10: 
            case 11: 
            case 13: 
            case 18: 
            case 19: 
            case 22: 
            case 26: 
            case 27: 
            case 28: 
            case 32: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalApks";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getPackageId";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getApk";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getApkFromPreBuildSync";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getApkFromPostBuildSync";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getBestOutput";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getTargetedApks";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 11: 
            case 13: 
            case 18: 
            case 19: 
            case 22: 
            case 26: 
            case 27: 
            case 28: 
            case 32: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

