/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.IDevice;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.fd.InstantRunBuildAnalyzer;
import com.android.tools.idea.fd.InstantRunManager;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.run.AndroidLaunchTaskContributor;
import com.android.tools.idea.run.AndroidRunConfigurationBase;
import com.android.tools.idea.run.ApkProvider;
import com.android.tools.idea.run.ApkProvisionException;
import com.android.tools.idea.run.ApplicationIdProvider;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.LaunchOptions;
import com.android.tools.idea.run.editor.AndroidDebugger;
import com.android.tools.idea.run.editor.AndroidDebuggerContext;
import com.android.tools.idea.run.tasks.ClearLogcatTask;
import com.android.tools.idea.run.tasks.DebugConnectorTask;
import com.android.tools.idea.run.tasks.DeployApkTask;
import com.android.tools.idea.run.tasks.DeployInstantAppTask;
import com.android.tools.idea.run.tasks.DismissKeyguardTask;
import com.android.tools.idea.run.tasks.LaunchTask;
import com.android.tools.idea.run.tasks.LaunchTasksProvider;
import com.android.tools.idea.run.tasks.ShowLogcatTask;
import com.android.tools.idea.run.tasks.UninstallIotLauncherAppsTask;
import com.android.tools.idea.run.util.LaunchStatus;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidLaunchTasksProvider
implements LaunchTasksProvider {
    private final AndroidRunConfigurationBase myRunConfig;
    private final ExecutionEnvironment myEnv;
    private final AndroidFacet myFacet;
    private final InstantRunBuildAnalyzer myInstantRunBuildAnalyzer;
    private final ApplicationIdProvider myApplicationIdProvider;
    private final ApkProvider myApkProvider;
    private final LaunchOptions myLaunchOptions;
    private final Project myProject;

    public AndroidLaunchTasksProvider(@NotNull AndroidRunConfigurationBase runConfig, @NotNull ExecutionEnvironment env, @NotNull AndroidFacet facet, @Nullable InstantRunBuildAnalyzer instantRunBuildAnalyzer, @NotNull ApplicationIdProvider applicationIdProvider, @NotNull ApkProvider apkProvider, @NotNull LaunchOptions launchOptions) {
        if (runConfig == null) {
            AndroidLaunchTasksProvider.$$$reportNull$$$0(0);
        }
        if (env == null) {
            AndroidLaunchTasksProvider.$$$reportNull$$$0(1);
        }
        if (facet == null) {
            AndroidLaunchTasksProvider.$$$reportNull$$$0(2);
        }
        if (applicationIdProvider == null) {
            AndroidLaunchTasksProvider.$$$reportNull$$$0(3);
        }
        if (apkProvider == null) {
            AndroidLaunchTasksProvider.$$$reportNull$$$0(4);
        }
        if (launchOptions == null) {
            AndroidLaunchTasksProvider.$$$reportNull$$$0(5);
        }
        this.myRunConfig = runConfig;
        this.myEnv = env;
        this.myProject = facet.getModule().getProject();
        this.myFacet = facet;
        this.myInstantRunBuildAnalyzer = instantRunBuildAnalyzer;
        this.myApplicationIdProvider = applicationIdProvider;
        this.myApkProvider = apkProvider;
        this.myLaunchOptions = launchOptions;
    }

    @Override
    @NotNull
    public List<LaunchTask> getTasks(@NotNull IDevice device, @NotNull LaunchStatus launchStatus, @NotNull ConsolePrinter consolePrinter) throws ExecutionException {
        String packageName;
        if (device == null) {
            AndroidLaunchTasksProvider.$$$reportNull$$$0(6);
        }
        if (launchStatus == null) {
            AndroidLaunchTasksProvider.$$$reportNull$$$0(7);
        }
        if (consolePrinter == null) {
            AndroidLaunchTasksProvider.$$$reportNull$$$0(8);
        }
        ArrayList launchTasks = Lists.newArrayList();
        if (this.myLaunchOptions.isClearLogcatBeforeStart()) {
            launchTasks.add(new ClearLogcatTask(this.myProject));
        }
        launchTasks.add(new DismissKeyguardTask());
        try {
            packageName = this.myApplicationIdProvider.getPackageName();
            launchTasks.addAll(this.getDeployTasks(device, packageName));
            for (AndroidLaunchTaskContributor taskContributor : (AndroidLaunchTaskContributor[])AndroidLaunchTaskContributor.EP_NAME.getExtensions()) {
                LaunchTask task = taskContributor.getTask(this.myFacet.getModule(), packageName);
                if (task == null) continue;
                launchTasks.add(task);
            }
            LaunchTask appLaunchTask = this.myRunConfig.getApplicationLaunchTask(this.myApplicationIdProvider, this.myFacet, this.myLaunchOptions.isDebug(), launchStatus);
            if (appLaunchTask != null) {
                launchTasks.add(appLaunchTask);
            }
        }
        catch (ApkProvisionException e) {
            Logger.getInstance(AndroidLaunchTasksProvider.class).error((Throwable)e);
            launchStatus.terminateLaunch("Unable to determine application id: " + e);
            List<LaunchTask> list = Collections.emptyList();
            if (list == null) {
                AndroidLaunchTasksProvider.$$$reportNull$$$0(9);
            }
            return list;
        }
        catch (IllegalStateException e) {
            Logger.getInstance(AndroidLaunchTasksProvider.class).error((Throwable)e);
            launchStatus.terminateLaunch(e.getMessage());
            List<LaunchTask> list = Collections.emptyList();
            if (list == null) {
                AndroidLaunchTasksProvider.$$$reportNull$$$0(10);
            }
            return list;
        }
        if (!this.myLaunchOptions.isDebug() && this.myLaunchOptions.isOpenLogcatAutomatically()) {
            launchTasks.add(new ShowLogcatTask(this.myProject, packageName));
        }
        if (this.myInstantRunBuildAnalyzer != null) {
            launchTasks.add(this.myInstantRunBuildAnalyzer.getNotificationTask());
        }
        ArrayList arrayList = launchTasks;
        if (arrayList == null) {
            AndroidLaunchTasksProvider.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    @NotNull
    List<LaunchTask> getDeployTasks(@NotNull IDevice device, @NotNull String packageName) throws ApkProvisionException, ExecutionException {
        if (device == null) {
            AndroidLaunchTasksProvider.$$$reportNull$$$0(12);
        }
        if (packageName == null) {
            AndroidLaunchTasksProvider.$$$reportNull$$$0(13);
        }
        if (this.myInstantRunBuildAnalyzer != null) {
            List<LaunchTask> list = this.myInstantRunBuildAnalyzer.getDeployTasks(device, this.myLaunchOptions);
            if (list == null) {
                AndroidLaunchTasksProvider.$$$reportNull$$$0(14);
            }
            return list;
        }
        if (!this.myLaunchOptions.isDeploy()) {
            List<LaunchTask> list = Collections.emptyList();
            if (list == null) {
                AndroidLaunchTasksProvider.$$$reportNull$$$0(15);
            }
            return list;
        }
        ArrayList<LaunchTask> tasks = new ArrayList<LaunchTask>();
        if (((Boolean)StudioFlags.UNINSTALL_LAUNCHER_APPS_ENABLED.get()).booleanValue() && device.supportsFeature(IDevice.HardwareFeature.EMBEDDED)) {
            tasks.add(new UninstallIotLauncherAppsTask(this.myProject, packageName));
        }
        if (this.myFacet.getProjectType() == 4) {
            tasks.add(new DeployInstantAppTask(this.myApkProvider.getApks(device)));
        } else {
            InstantRunManager.LOG.info("Using legacy/main APK deploy task");
            tasks.add(new DeployApkTask(this.myProject, this.myLaunchOptions, this.myApkProvider.getApks(device)));
        }
        ImmutableList immutableList = ImmutableList.copyOf(tasks);
        if (immutableList == null) {
            AndroidLaunchTasksProvider.$$$reportNull$$$0(16);
        }
        return immutableList;
    }

    @Override
    @Nullable
    public DebugConnectorTask getConnectDebuggerTask(@NotNull LaunchStatus launchStatus, @Nullable AndroidVersion version) {
        String packageName;
        if (launchStatus == null) {
            AndroidLaunchTasksProvider.$$$reportNull$$$0(17);
        }
        if (!this.myLaunchOptions.isDebug()) {
            return null;
        }
        Logger logger = Logger.getInstance(AndroidLaunchTasksProvider.class);
        HashSet packageIds = Sets.newHashSet();
        try {
            packageName = this.myApplicationIdProvider.getPackageName();
            packageIds.add(packageName);
        }
        catch (ApkProvisionException e) {
            logger.error((Throwable)e);
        }
        try {
            packageName = this.myApplicationIdProvider.getTestPackageName();
            if (packageName != null) {
                packageIds.add(packageName);
            }
        }
        catch (ApkProvisionException e) {
            logger.warn("Unable to obtain test package name, will not connect debugger if tests don't instantiate main application");
        }
        AndroidDebuggerContext androidDebuggerContext = this.myRunConfig.getAndroidDebuggerContext();
        AndroidDebugger debugger = androidDebuggerContext.getAndroidDebugger();
        if (debugger == null) {
            logger.warn("Unable to determine debugger to use for this launch");
            return null;
        }
        logger.info("Using debugger: " + debugger.getId());
        Object androidDebuggerState = androidDebuggerContext.getAndroidDebuggerState();
        if (androidDebuggerState != null) {
            return debugger.getConnectDebuggerTask(this.myEnv, version, packageIds, this.myFacet, androidDebuggerState, this.myRunConfig.getType().getId(), this.monitorRemoteProcess());
        }
        return null;
    }

    @Override
    public boolean createsNewProcess() {
        return true;
    }

    @Override
    public boolean monitorRemoteProcess() {
        return this.myRunConfig.monitorRemoteProcess();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfig";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicationIdProvider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "apkProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launchOptions";
                break;
            }
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 7: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launchStatus";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consolePrinter";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/run/AndroidLaunchTasksProvider";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/run/AndroidLaunchTasksProvider";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTasks";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeployTasks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getTasks";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getDeployTasks";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getConnectDebuggerTask";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

