/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.resourceExplorer.viewmodel;

import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.ResourceQualifier;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ModuleResourceRepository;
import com.android.tools.idea.resourceExplorer.model.DesignAsset;
import com.android.tools.idea.resourceExplorer.viewmodel.ResourceBrowserViewModelKt;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ThrowableRunnable;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001:\u0001\nJ \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH&\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/idea/resourceExplorer/viewmodel/ResourceFileHelper;", "", "copyInProjectResources", "", "asset", "Lcom/android/tools/idea/resourceExplorer/model/DesignAsset;", "resourceName", "", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "ResourceFileHelperImpl", "intellij.android"})
public interface ResourceFileHelper {
    public void copyInProjectResources(@NotNull DesignAsset var1, @NotNull String var2, @NotNull AndroidFacet var3);

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u000b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J \u0010\u000f\u001a\n \u0010*\u0004\u0018\u00010\u00060\u00062\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J.\u0010\u0012\u001a\n \u0010*\u0004\u0018\u00010\u00060\u00062\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u00142\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u0015\u001a\u0004\u0018\u00010\u00062\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u00142\u0006\u0010\u0011\u001a\u00020\bH\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u0018\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u0019\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u001a"}, d2={"Lcom/android/tools/idea/resourceExplorer/viewmodel/ResourceFileHelper$ResourceFileHelperImpl;", "Lcom/android/tools/idea/resourceExplorer/viewmodel/ResourceFileHelper;", "()V", "copyIfNotExisting", "", "folder", "Lcom/intellij/openapi/vfs/VirtualFile;", "fileName", "", "asset", "Lcom/android/tools/idea/resourceExplorer/model/DesignAsset;", "copyInProjectResources", "resourceName", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "createResSubDir", "kotlin.jvm.PlatformType", "folderName", "findOrCreateResourceFolder", "resourceSubdirs", "", "findResourceSubdir", "getFolderConfiguration", "Lcom/android/ide/common/resources/configuration/FolderConfiguration;", "getNewFileName", "getResourceFolderForAsset", "intellij.android"})
    public static final class ResourceFileHelperImpl
    implements ResourceFileHelper {
        @Override
        public void copyInProjectResources(@NotNull DesignAsset asset, @NotNull String resourceName, @NotNull AndroidFacet facet) {
            Intrinsics.checkParameterIsNotNull((Object)asset, (String)"asset");
            Intrinsics.checkParameterIsNotNull((Object)resourceName, (String)"resourceName");
            Intrinsics.checkParameterIsNotNull((Object)((Object)facet), (String)"facet");
            VirtualFile folder = this.getResourceFolderForAsset(asset, facet);
            String fileName = this.getNewFileName(resourceName, asset);
            this.copyIfNotExisting(folder, fileName, asset);
        }

        private final String getNewFileName(String resourceName, DesignAsset asset) {
            return resourceName + (asset.getFile().getExtension() != null ? "." + asset.getFile().getExtension() : "");
        }

        private final VirtualFile getResourceFolderForAsset(DesignAsset asset, AndroidFacet facet) {
            String folderName;
            LocalResourceRepository localResourceRepository = ModuleResourceRepository.getOrCreateInstance(facet);
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)localResourceRepository), (String)"ModuleResourceRepository\u2026etOrCreateInstance(facet)");
            Set<VirtualFile> set = localResourceRepository.getResourceDirs();
            Intrinsics.checkExpressionValueIsNotNull(set, (String)"ModuleResourceRepository\u2026tance(facet).resourceDirs");
            Set<VirtualFile> resourceDirs = set;
            if (resourceDirs.isEmpty()) {
                StringBuilder stringBuilder = new StringBuilder().append("No resource directory found in this module (");
                Module module = facet.getModule();
                Intrinsics.checkExpressionValueIsNotNull((Object)module, (String)"facet.module");
                throw (Throwable)new IOException(stringBuilder.append(module.getName()).append(')').toString());
            }
            List<VirtualFile> list = AndroidResourceUtil.getResourceSubdirs(asset.getType(), (Collection<VirtualFile>)resourceDirs);
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"AndroidResourceUtil.getR\u2026asset.type, resourceDirs)");
            List<VirtualFile> resourceSubdirs = list;
            String string = folderName = this.getFolderConfiguration(asset).getFolderName(asset.getType());
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"folderName");
            VirtualFile virtualFile = this.findOrCreateResourceFolder(resourceSubdirs, string, facet);
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"findOrCreateResourceFold\u2026bdirs, folderName, facet)");
            return virtualFile;
        }

        /*
         * WARNING - void declaration
         */
        private final FolderConfiguration getFolderConfiguration(DesignAsset asset) {
            void $receiver$iv;
            FolderConfiguration folderConfiguration = new FolderConfiguration();
            Iterable iterable = asset.getQualifiers();
            FolderConfiguration folderConfiguration2 = folderConfiguration;
            for (Object element$iv : $receiver$iv) {
                ResourceQualifier p1 = (ResourceQualifier)element$iv;
                folderConfiguration2.addQualifier(p1);
            }
            return folderConfiguration;
        }

        private final VirtualFile findOrCreateResourceFolder(List<? extends VirtualFile> resourceSubdirs, String folderName, AndroidFacet facet) {
            VirtualFile virtualFile = this.findResourceSubdir(resourceSubdirs, folderName);
            if (virtualFile == null) {
                virtualFile = this.createResSubDir(folderName, facet);
            }
            return virtualFile;
        }

        private final VirtualFile createResSubDir(String folderName, AndroidFacet facet) {
            return (VirtualFile)WriteAction.compute((ThrowableComputable)new ThrowableComputable<T, E>(this, facet, folderName){
                final /* synthetic */ ResourceFileHelperImpl this$0;
                final /* synthetic */ AndroidFacet $facet;
                final /* synthetic */ String $folderName;

                @NotNull
                public final VirtualFile compute() {
                    return this.$facet.getAllResourceDirectories().get(0).createChildDirectory((Object)this.this$0, this.$folderName);
                }
                {
                    this.this$0 = resourceFileHelperImpl;
                    this.$facet = androidFacet;
                    this.$folderName = string;
                }
            });
        }

        private final VirtualFile findResourceSubdir(List<? extends VirtualFile> resourceSubdirs, String folderName) {
            Object v0;
            block1: {
                Iterable $receiver$iv = resourceSubdirs;
                for (Object element$iv : $receiver$iv) {
                    VirtualFile dir = (VirtualFile)element$iv;
                    if (!Intrinsics.areEqual((Object)dir.getName(), (Object)folderName)) continue;
                    v0 = element$iv;
                    break block1;
                }
                v0 = null;
            }
            return v0;
        }

        private final void copyIfNotExisting(VirtualFile folder, String fileName, DesignAsset asset) {
            if (folder.findChild(fileName) == null) {
                WriteAction.run((ThrowableRunnable)new ThrowableRunnable<E>(this, asset, folder, fileName){
                    final /* synthetic */ ResourceFileHelperImpl this$0;
                    final /* synthetic */ DesignAsset $asset;
                    final /* synthetic */ VirtualFile $folder;
                    final /* synthetic */ String $fileName;

                    public final void run() {
                        this.$asset.getFile().copy((Object)this.this$0, this.$folder, this.$fileName);
                    }
                    {
                        this.this$0 = resourceFileHelperImpl;
                        this.$asset = designAsset;
                        this.$folder = virtualFile;
                        this.$fileName = string;
                    }
                });
                ResourceBrowserViewModelKt.getLOGGER().info(fileName + " copied into " + folder.getPath());
            } else {
                ResourceBrowserViewModelKt.getLOGGER().info(fileName + " already exist in " + folder.getPath());
            }
        }
    }
}

