/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.resourceExplorer.viewmodel;

import com.android.tools.idea.resourceExplorer.importer.ImporterKt;
import com.android.tools.idea.resourceExplorer.importer.ImportersProvider;
import com.android.tools.idea.resourceExplorer.model.DesignAsset;
import com.android.tools.idea.resourceExplorer.model.DesignAssetListModel;
import com.android.tools.idea.resourceExplorer.model.DesignAssetSet;
import com.android.tools.idea.resourceExplorer.plugin.ResourceImporter;
import com.android.tools.idea.resourceExplorer.viewmodel.ResourceBrowserViewModelKt;
import com.android.tools.idea.resourceExplorer.viewmodel.ResourceFileHelper;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Image;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/android/tools/idea/resourceExplorer/viewmodel/ResourceBrowserViewModel;", "", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "fileHelper", "Lcom/android/tools/idea/resourceExplorer/viewmodel/ResourceFileHelper;", "importersProvider", "Lcom/android/tools/idea/resourceExplorer/importer/ImportersProvider;", "(Lorg/jetbrains/android/facet/AndroidFacet;Lcom/android/tools/idea/resourceExplorer/viewmodel/ResourceFileHelper;Lcom/android/tools/idea/resourceExplorer/importer/ImportersProvider;)V", "designAssetListModel", "Lcom/android/tools/idea/resourceExplorer/model/DesignAssetListModel;", "getDesignAssetListModel", "()Lcom/android/tools/idea/resourceExplorer/model/DesignAssetListModel;", "getFacet", "()Lorg/jetbrains/android/facet/AndroidFacet;", "getSourcePreview", "Ljava/awt/Image;", "asset", "Lcom/android/tools/idea/resourceExplorer/model/DesignAsset;", "importDesignAssetSet", "", "selectedValue", "Lcom/android/tools/idea/resourceExplorer/model/DesignAssetSet;", "setDirectory", "directory", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.android"})
public final class ResourceBrowserViewModel {
    @NotNull
    private final DesignAssetListModel designAssetListModel;
    @NotNull
    private final AndroidFacet facet;
    private final ResourceFileHelper fileHelper;
    private final ImportersProvider importersProvider;

    @NotNull
    public final DesignAssetListModel getDesignAssetListModel() {
        return this.designAssetListModel;
    }

    /*
     * WARNING - void declaration
     */
    public final void setDirectory(@NotNull VirtualFile directory) {
        Intrinsics.checkParameterIsNotNull((Object)directory, (String)"directory");
        if (directory.isValid() && directory.isDirectory()) {
            void $receiver$iv;
            Iterable iterable = ImporterKt.getAssetSets(directory, this.importersProvider.getSupportedFileTypes());
            DesignAssetListModel designAssetListModel = this.designAssetListModel;
            void var3_4 = $receiver$iv;
            Comparator comparator = new Comparator<T>(){

                public final int compare(T a, T b) {
                    DesignAssetSet $name_$_$ = (DesignAssetSet)a;
                    String name = $name_$_$.component1();
                    $name_$_$ = (DesignAssetSet)b;
                    Comparable comparable = (Comparable)((Object)name);
                    String string = name = $name_$_$.component1();
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)string)));
                }
            };
            List list = CollectionsKt.sortedWith((Iterable)var3_4, (Comparator)comparator);
            designAssetListModel.setAssets(list);
        } else {
            ResourceBrowserViewModelKt.getLOGGER().error(directory.getPath() + " is not a valid directory");
        }
    }

    public final void importDesignAssetSet(@NotNull DesignAssetSet selectedValue) {
        Intrinsics.checkParameterIsNotNull((Object)selectedValue, (String)"selectedValue");
        Iterable $receiver$iv = selectedValue.getDesignAssets();
        for (Object element$iv : $receiver$iv) {
            DesignAsset asset = (DesignAsset)element$iv;
            this.fileHelper.copyInProjectResources(asset, selectedValue.getName(), this.facet);
        }
    }

    @NotNull
    public final Image getSourcePreview(@NotNull DesignAsset asset) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)asset, (String)"asset");
        String extension = asset.getFile().getExtension();
        CharSequence charSequence = extension;
        if (!(charSequence == null || charSequence.length() == 0)) {
            String string = extension;
            if (string == null) {
                Intrinsics.throwNpe();
            }
            if ((object = (ResourceImporter)CollectionsKt.firstOrNull(this.importersProvider.getImportersForExtension(string))) == null || (object = object.getSourcePreview(asset)) == null) {
                object = ResourceBrowserViewModelKt.getEMPTY_IMAGE();
            }
        } else {
            object = ResourceBrowserViewModelKt.getEMPTY_IMAGE();
        }
        return object;
    }

    @NotNull
    public final AndroidFacet getFacet() {
        return this.facet;
    }

    public ResourceBrowserViewModel(@NotNull AndroidFacet facet, @NotNull ResourceFileHelper fileHelper, @NotNull ImportersProvider importersProvider) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)facet), (String)"facet");
        Intrinsics.checkParameterIsNotNull((Object)fileHelper, (String)"fileHelper");
        Intrinsics.checkParameterIsNotNull((Object)importersProvider, (String)"importersProvider");
        this.facet = facet;
        this.fileHelper = fileHelper;
        this.importersProvider = importersProvider;
        this.designAssetListModel = new DesignAssetListModel();
    }

    public /* synthetic */ ResourceBrowserViewModel(AndroidFacet androidFacet, ResourceFileHelper resourceFileHelper, ImportersProvider importersProvider, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            resourceFileHelper = new ResourceFileHelper.ResourceFileHelperImpl();
        }
        if ((n & 4) != 0) {
            importersProvider = new ImportersProvider(null, 1, null);
        }
        this(androidFacet, resourceFileHelper, importersProvider);
    }
}

