/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.resources.ResourceFolderType;
import com.android.tools.idea.fileTypes.FontFileType;
import com.android.tools.idea.gradle.project.sync.GradleFiles;
import com.android.tools.idea.res.ResourceFolderRepository;
import com.google.common.collect.Maps;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.ui.EditorNotifications;
import java.util.Map;
import org.intellij.images.fileTypes.ImageFileTypeManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiProjectListener
implements PsiTreeChangeListener {
    @NotNull
    private final Map<VirtualFile, ResourceFolderRepository> myListeners;
    @NotNull
    private final Project myProject;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addRoot(@NotNull Project project, @NotNull VirtualFile root, @NotNull ResourceFolderRepository repository) {
        if (project == null) {
            PsiProjectListener.$$$reportNull$$$0(0);
        }
        if (root == null) {
            PsiProjectListener.$$$reportNull$$$0(1);
        }
        if (repository == null) {
            PsiProjectListener.$$$reportNull$$$0(2);
        }
        Class<PsiProjectListener> clazz = PsiProjectListener.class;
        synchronized (PsiProjectListener.class) {
            PsiProjectListener.getInstance(project).addRoot(root, repository);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeRoot(@NotNull Project project, @NotNull VirtualFile root, @NotNull ResourceFolderRepository repository) {
        if (project == null) {
            PsiProjectListener.$$$reportNull$$$0(3);
        }
        if (root == null) {
            PsiProjectListener.$$$reportNull$$$0(4);
        }
        if (repository == null) {
            PsiProjectListener.$$$reportNull$$$0(5);
        }
        Class<PsiProjectListener> clazz = PsiProjectListener.class;
        synchronized (PsiProjectListener.class) {
            PsiProjectListener.getInstance(project).removeRoot(root, repository);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    @NotNull
    public static PsiProjectListener getInstance(@NotNull Project project) {
        if (project == null) {
            PsiProjectListener.$$$reportNull$$$0(6);
        }
        PsiProjectListener psiProjectListener = (PsiProjectListener)project.getComponent(PsiProjectListener.class);
        if (psiProjectListener == null) {
            PsiProjectListener.$$$reportNull$$$0(7);
        }
        return psiProjectListener;
    }

    public PsiProjectListener(@NotNull Project project) {
        if (project == null) {
            PsiProjectListener.$$$reportNull$$$0(8);
        }
        this.myListeners = Maps.newHashMap();
        this.myProject = project;
        PsiManager.getInstance((Project)project).addPsiTreeChangeListener((PsiTreeChangeListener)this);
    }

    private void addRoot(@NotNull VirtualFile root, @NotNull ResourceFolderRepository repository) {
        if (root == null) {
            PsiProjectListener.$$$reportNull$$$0(9);
        }
        if (repository == null) {
            PsiProjectListener.$$$reportNull$$$0(10);
        }
        assert (this.myListeners.get(root) == null);
        this.myListeners.put(root, repository);
    }

    private void removeRoot(@NotNull VirtualFile root, @NotNull ResourceFolderRepository repository) {
        if (root == null) {
            PsiProjectListener.$$$reportNull$$$0(11);
        }
        if (repository == null) {
            PsiProjectListener.$$$reportNull$$$0(12);
        }
        assert (this.myListeners.get(root) == repository) : repository;
        this.myListeners.remove(root);
    }

    static boolean isRelevantFileType(@NotNull FileType fileType) {
        if (fileType == null) {
            PsiProjectListener.$$$reportNull$$$0(13);
        }
        if (fileType == StdFileTypes.JAVA) {
            return false;
        }
        if (fileType == StdFileTypes.XML) {
            return true;
        }
        if (fileType.isBinary()) {
            return fileType == ImageFileTypeManager.getInstance().getImageFileType() || fileType == FontFileType.INSTANCE;
        }
        return false;
    }

    static boolean isRelevantFile(@NotNull VirtualFile file) {
        String parentName;
        FileType fileType;
        if (file == null) {
            PsiProjectListener.$$$reportNull$$$0(14);
        }
        if ((fileType = file.getFileType()) == StdFileTypes.JAVA) {
            return false;
        }
        if (PsiProjectListener.isRelevantFileType(fileType)) {
            return true;
        }
        VirtualFile parent = file.getParent();
        return parent != null && (parentName = parent.getName()).startsWith("raw");
    }

    static boolean isRelevantFile(@NotNull PsiFile file) {
        String parentName;
        FileType fileType;
        if (file == null) {
            PsiProjectListener.$$$reportNull$$$0(15);
        }
        if ((fileType = file.getFileType()) == StdFileTypes.JAVA) {
            return false;
        }
        if (PsiProjectListener.isRelevantFileType(fileType)) {
            return true;
        }
        PsiDirectory parent = file.getParent();
        return parent != null && (parentName = parent.getName()).startsWith("raw");
    }

    @Nullable
    private ResourceFolderRepository findRepository(@Nullable VirtualFile file) {
        if (file == null) {
            return null;
        }
        while (file != null) {
            ResourceFolderRepository repository = this.myListeners.get(file);
            if (repository != null) {
                return repository;
            }
            file = file.getParent();
        }
        return null;
    }

    public void beforeChildAddition(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            PsiProjectListener.$$$reportNull$$$0(16);
        }
    }

    public void childAdded(@NotNull PsiTreeChangeEvent event) {
        PsiFile psiFile;
        if (event == null) {
            PsiProjectListener.$$$reportNull$$$0(17);
        }
        if ((psiFile = event.getFile()) == null) {
            PsiElement child = event.getChild();
            if (child instanceof PsiFile) {
                VirtualFile file = ((PsiFile)child).getVirtualFile();
                if (file != null && PsiProjectListener.isRelevantFile(file)) {
                    this.dispatchChildAdded(event, file);
                }
            } else if (child instanceof PsiDirectory) {
                PsiDirectory directory = (PsiDirectory)child;
                this.dispatchChildAdded(event, directory.getVirtualFile());
            }
        } else if (PsiProjectListener.isRelevantFile(psiFile)) {
            this.dispatchChildAdded(event, psiFile.getVirtualFile());
        } else if (this.isGradleFileEdit(psiFile)) {
            PsiProjectListener.notifyGradleEdit(psiFile);
        }
    }

    private void dispatchChildAdded(@NotNull PsiTreeChangeEvent event, @Nullable VirtualFile virtualFile) {
        ResourceFolderRepository repository;
        if (event == null) {
            PsiProjectListener.$$$reportNull$$$0(18);
        }
        if ((repository = this.findRepository(virtualFile)) != null) {
            repository.getPsiListener().childAdded(event);
        }
    }

    public void beforeChildRemoval(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            PsiProjectListener.$$$reportNull$$$0(19);
        }
    }

    public void childRemoved(@NotNull PsiTreeChangeEvent event) {
        PsiFile psiFile;
        if (event == null) {
            PsiProjectListener.$$$reportNull$$$0(20);
        }
        if ((psiFile = event.getFile()) == null) {
            PsiDirectory directory;
            PsiElement child = event.getChild();
            if (child instanceof PsiFile) {
                VirtualFile file = ((PsiFile)child).getVirtualFile();
                if (file != null && PsiProjectListener.isRelevantFile(file)) {
                    this.dispatchChildRemoved(event, file);
                }
            } else if (child instanceof PsiDirectory && ResourceFolderType.getFolderType((String)(directory = (PsiDirectory)child).getName()) != null) {
                VirtualFile file = directory.getVirtualFile();
                this.dispatchChildRemoved(event, file);
            }
        } else if (PsiProjectListener.isRelevantFile(psiFile)) {
            VirtualFile file = psiFile.getVirtualFile();
            this.dispatchChildRemoved(event, file);
        } else if (this.isGradleFileEdit(psiFile)) {
            PsiProjectListener.notifyGradleEdit(psiFile);
        }
    }

    private void dispatchChildRemoved(@NotNull PsiTreeChangeEvent event, @Nullable VirtualFile virtualFile) {
        ResourceFolderRepository repository;
        if (event == null) {
            PsiProjectListener.$$$reportNull$$$0(21);
        }
        if ((repository = this.findRepository(virtualFile)) != null) {
            repository.getPsiListener().childRemoved(event);
        }
    }

    public void beforeChildReplacement(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            PsiProjectListener.$$$reportNull$$$0(22);
        }
    }

    public void childReplaced(@NotNull PsiTreeChangeEvent event) {
        PsiFile psiFile;
        if (event == null) {
            PsiProjectListener.$$$reportNull$$$0(23);
        }
        if ((psiFile = event.getFile()) != null) {
            if (PsiProjectListener.isRelevantFile(psiFile)) {
                this.dispatchChildReplaced(event, psiFile.getVirtualFile());
            } else if (this.isGradleFileEdit(psiFile)) {
                PsiProjectListener.notifyGradleEdit(psiFile);
            }
        } else {
            PsiElement parent = event.getParent();
            if (parent instanceof PsiDirectory) {
                PsiDirectory directory = (PsiDirectory)parent;
                this.dispatchChildReplaced(event, directory.getVirtualFile());
            }
        }
    }

    private void dispatchChildReplaced(@NotNull PsiTreeChangeEvent event, @Nullable VirtualFile virtualFile) {
        ResourceFolderRepository repository;
        if (event == null) {
            PsiProjectListener.$$$reportNull$$$0(24);
        }
        if ((repository = this.findRepository(virtualFile)) != null) {
            repository.getPsiListener().childReplaced(event);
        }
    }

    private boolean isGradleFileEdit(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            PsiProjectListener.$$$reportNull$$$0(25);
        }
        return GradleFiles.getInstance(this.myProject).isGradleFile(psiFile);
    }

    private static void notifyGradleEdit(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            PsiProjectListener.$$$reportNull$$$0(26);
        }
        EditorNotifications.getInstance((Project)psiFile.getProject()).updateAllNotifications();
    }

    public void beforeChildrenChange(@NotNull PsiTreeChangeEvent event) {
        PsiFile psiFile;
        if (event == null) {
            PsiProjectListener.$$$reportNull$$$0(27);
        }
        if ((psiFile = event.getFile()) != null && PsiProjectListener.isRelevantFile(psiFile)) {
            VirtualFile file = psiFile.getVirtualFile();
            this.dispatchBeforeChildrenChange(event, file);
        }
    }

    private void dispatchBeforeChildrenChange(@NotNull PsiTreeChangeEvent event, @Nullable VirtualFile virtualFile) {
        ResourceFolderRepository repository;
        if (event == null) {
            PsiProjectListener.$$$reportNull$$$0(28);
        }
        if ((repository = this.findRepository(virtualFile)) != null) {
            repository.getPsiListener().beforeChildrenChange(event);
        }
    }

    public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
        PsiFile psiFile;
        if (event == null) {
            PsiProjectListener.$$$reportNull$$$0(29);
        }
        if ((psiFile = event.getFile()) != null && PsiProjectListener.isRelevantFile(psiFile)) {
            VirtualFile file = psiFile.getVirtualFile();
            this.dispatchChildrenChanged(event, file);
        }
    }

    private void dispatchChildrenChanged(@NotNull PsiTreeChangeEvent event, @Nullable VirtualFile virtualFile) {
        ResourceFolderRepository repository;
        if (event == null) {
            PsiProjectListener.$$$reportNull$$$0(30);
        }
        if ((repository = this.findRepository(virtualFile)) != null) {
            repository.getPsiListener().childrenChanged(event);
        }
    }

    public void beforeChildMovement(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            PsiProjectListener.$$$reportNull$$$0(31);
        }
    }

    private void dispatchBeforeChildMovement(@NotNull PsiTreeChangeEvent event, @Nullable VirtualFile virtualFile) {
        ResourceFolderRepository repository;
        if (event == null) {
            PsiProjectListener.$$$reportNull$$$0(32);
        }
        if ((repository = this.findRepository(virtualFile)) != null) {
            repository.getPsiListener().beforeChildrenChange(event);
        }
    }

    public void childMoved(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            PsiProjectListener.$$$reportNull$$$0(33);
        }
        PsiElement child = event.getChild();
        PsiFile psiFile = event.getFile();
        if (psiFile == null) {
            if (child instanceof PsiFile && PsiProjectListener.isRelevantFile((PsiFile)child)) {
                VirtualFile file = ((PsiFile)child).getVirtualFile();
                if (file != null) {
                    this.dispatchChildMoved(event, file);
                    return;
                }
                PsiElement oldParent = event.getOldParent();
                if (oldParent instanceof PsiDirectory) {
                    PsiDirectory directory = (PsiDirectory)oldParent;
                    VirtualFile dir = directory.getVirtualFile();
                    this.dispatchChildMoved(event, dir);
                }
            }
        } else {
            VirtualFile file = psiFile.getVirtualFile();
            if (file != null && PsiProjectListener.isRelevantFile(file)) {
                this.dispatchChildMoved(event, file);
            }
        }
    }

    private void dispatchChildMoved(@NotNull PsiTreeChangeEvent event, @Nullable VirtualFile virtualFile) {
        PsiDirectory sourceDir;
        ResourceFolderRepository targetRepository;
        PsiElement oldParent;
        ResourceFolderRepository repository;
        if (event == null) {
            PsiProjectListener.$$$reportNull$$$0(34);
        }
        if ((repository = this.findRepository(virtualFile)) != null) {
            repository.getPsiListener().childMoved(event);
        }
        if (event.getFile() == null && (oldParent = event.getOldParent()) instanceof PsiDirectory && (targetRepository = this.findRepository((sourceDir = (PsiDirectory)oldParent).getVirtualFile())) != null && targetRepository != repository) {
            targetRepository.getPsiListener().childMoved(event);
        }
    }

    public void beforePropertyChange(@NotNull PsiTreeChangeEvent event) {
        PsiFile psiFile;
        PsiElement child;
        if (event == null) {
            PsiProjectListener.$$$reportNull$$$0(35);
        }
        if ("fileName" == event.getPropertyName() && (child = event.getChild()) instanceof PsiFile && PsiProjectListener.isRelevantFile(psiFile = (PsiFile)child)) {
            VirtualFile file = psiFile.getVirtualFile();
            this.dispatchBeforePropertyChange(event, file);
        }
    }

    private void dispatchBeforePropertyChange(@NotNull PsiTreeChangeEvent event, @Nullable VirtualFile virtualFile) {
        ResourceFolderRepository repository;
        if (event == null) {
            PsiProjectListener.$$$reportNull$$$0(36);
        }
        if ((repository = this.findRepository(virtualFile)) != null) {
            repository.getPsiListener().beforePropertyChange(event);
        }
    }

    public void propertyChanged(@NotNull PsiTreeChangeEvent event) {
        PsiFile psiFile;
        PsiElement child;
        if (event == null) {
            PsiProjectListener.$$$reportNull$$$0(37);
        }
        if ("fileName" == event.getPropertyName() && (child = event.getElement()) instanceof PsiFile && PsiProjectListener.isRelevantFile(psiFile = (PsiFile)child)) {
            VirtualFile file = psiFile.getVirtualFile();
            this.dispatchPropertyChange(event, file);
        }
    }

    private void dispatchPropertyChange(@NotNull PsiTreeChangeEvent event, @Nullable VirtualFile virtualFile) {
        ResourceFolderRepository repository;
        if (event == null) {
            PsiProjectListener.$$$reportNull$$$0(38);
        }
        if ((repository = this.findRepository(virtualFile)) != null) {
            repository.getPsiListener().propertyChanged(event);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: 
            case 5: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/res/PsiProjectListener";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/res/PsiProjectListener";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addRoot";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "removeRoot";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isRelevantFileType";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isRelevantFile";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "beforeChildAddition";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "childAdded";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "dispatchChildAdded";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "beforeChildRemoval";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "childRemoved";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "dispatchChildRemoved";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "beforeChildReplacement";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "childReplaced";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "dispatchChildReplaced";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isGradleFileEdit";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "notifyGradleEdit";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "beforeChildrenChange";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "dispatchBeforeChildrenChange";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "childrenChanged";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "dispatchChildrenChanged";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "beforeChildMovement";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "dispatchBeforeChildMovement";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "childMoved";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "dispatchChildMoved";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "beforePropertyChange";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "dispatchBeforePropertyChange";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "propertyChanged";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "dispatchPropertyChange";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

