/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.ide.common.rendering.api.ILayoutPullParser;
import com.android.tools.idea.rendering.ActionBarHandler;
import com.android.tools.idea.rendering.DomPullParser;
import com.android.tools.idea.rendering.LayoutPullParsers;
import com.android.tools.idea.rendering.RenderTask;
import com.android.tools.idea.res.ResourceHelper;
import com.android.utils.XmlUtils;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import java.util.Collections;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;

public class MenuLayoutParserFactory {
    @NotNull
    private static final String FRAME_LAYOUT_XML = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<FrameLayout\n    xmlns:android=\"http://schemas.android.com/apk/res/android\"\n    android:layout_width=\"match_parent\"\n    android:layout_height=\"match_parent\" />\n";
    @NotNull
    private final RenderTask myRenderTask;

    public MenuLayoutParserFactory(@NotNull RenderTask renderTask) {
        if (renderTask == null) {
            MenuLayoutParserFactory.$$$reportNull$$$0(0);
        }
        assert (renderTask.supportsCapability(12)) : "Action Bar not supported.";
        this.myRenderTask = renderTask;
    }

    @NotNull
    public ILayoutPullParser render() {
        Document frameLayoutDocument = XmlUtils.parseDocumentSilently((String)FRAME_LAYOUT_XML, (boolean)true);
        if (frameLayoutDocument == null) {
            ILayoutPullParser iLayoutPullParser = LayoutPullParsers.createEmptyParser();
            if (iLayoutPullParser == null) {
                MenuLayoutParserFactory.$$$reportNull$$$0(1);
            }
            return iLayoutPullParser;
        }
        XmlFile psiFile = this.myRenderTask.getPsiFile();
        if (psiFile == null) {
            throw new IllegalStateException("RenderTask should have PsiFile to render menu files");
        }
        String resourceName = ResourceHelper.getResourceName((PsiFile)psiFile);
        ActionBarHandler actionBarHandler = this.myRenderTask.getLayoutlibCallback().getActionBarHandler();
        if (actionBarHandler != null) {
            actionBarHandler.setMenuIdNames(Collections.singletonList(resourceName));
        }
        HashMap viewCookies = new HashMap();
        DomPullParser domPullParser = new DomPullParser(frameLayoutDocument.getDocumentElement()).setViewCookies(viewCookies);
        if (domPullParser == null) {
            MenuLayoutParserFactory.$$$reportNull$$$0(2);
        }
        return domPullParser;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderTask";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/rendering/MenuLayoutParserFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/rendering/MenuLayoutParserFactory";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "render";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

