/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.refactoring.modularize;

import com.android.ide.common.res2.ResourceItem;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.refactoring.modularize.AndroidCodeAndResourcesGraph;
import com.android.tools.idea.refactoring.modularize.AndroidModularizeDialog;
import com.android.tools.idea.refactoring.modularize.AndroidModularizeProcessor;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ModuleResourceRepository;
import com.android.tools.idea.res.ResourceHelper;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.XmlRecursiveElementWalkingVisitor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.actions.BaseRefactoringAction;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidModularizeHandler
implements RefactoringActionHandler {
    private static final Logger LOGGER = Logger.getInstance(AndroidModularizeHandler.class);
    private static final int RESOURCE_SET_INITIAL_SIZE = 100;

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            AndroidModularizeHandler.$$$reportNull$$$0(0);
        }
        this.invoke(project, BaseRefactoringAction.getPsiElementArray((DataContext)dataContext), dataContext);
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            AndroidModularizeHandler.$$$reportNull$$$0(1);
        }
        if (elements == null) {
            AndroidModularizeHandler.$$$reportNull$$$0(2);
        }
        AndroidModularizeProcessor processor = this.createProcessor(project, elements);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            Module targetModule = (Module)LangDataKeys.TARGET_MODULE.getData(dataContext);
            if (targetModule != null) {
                processor.setTargetModule(targetModule);
            }
            processor.run();
        } else {
            ArrayList<Module> suitableModules = new ArrayList<Module>();
            for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
                AndroidFacet facet = AndroidFacet.getInstance(module);
                if (facet == null || IdeaSourceProvider.getCurrentSourceProviders(facet).isEmpty() || facet.getAllResourceDirectories().isEmpty()) continue;
                suitableModules.add(module);
            }
            for (Module module : elements) {
                Module sourceModule = ModuleUtilCore.findModuleForPsiElement((PsiElement)module);
                if (sourceModule == null) continue;
                suitableModules.remove(sourceModule);
            }
            AndroidModularizeDialog dialog = new AndroidModularizeDialog(project, suitableModules, processor);
            dialog.show();
        }
    }

    AndroidModularizeProcessor createProcessor(@NotNull Project project, @NotNull PsiElement[] elements) {
        if (project == null) {
            AndroidModularizeHandler.$$$reportNull$$$0(3);
        }
        if (elements == null) {
            AndroidModularizeHandler.$$$reportNull$$$0(4);
        }
        CodeAndResourcesReferenceCollector scanner = new CodeAndResourcesReferenceCollector(project);
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            if (elements == null) {
                AndroidModularizeHandler.$$$reportNull$$$0(5);
            }
            ApplicationManager.getApplication().runReadAction(() -> {
                if (elements == null) {
                    AndroidModularizeHandler.$$$reportNull$$$0(6);
                }
                scanner.accumulate(elements);
            });
        }, "Computing References", false, project);
        return new AndroidModularizeProcessor(project, elements, scanner.getClassReferences(), scanner.getResourceReferences(), scanner.getManifestReferences(), scanner.getReferenceGraph());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/refactoring/modularize/AndroidModularizeHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createProcessor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$createProcessor$1";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$null$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class CodeAndResourcesReferenceCollector {
        private final Project myProject;
        private final Set<PsiClass> myClassRefSet;
        private final Set<ResourceItem> myResourceRefSet;
        private final Set<PsiElement> myManifestRefSet;
        private final Queue<PsiElement> myVisitQueue;
        private final AndroidCodeAndResourcesGraph.Builder myGraphBuilder;

        CodeAndResourcesReferenceCollector(@NotNull Project project) {
            if (project == null) {
                CodeAndResourcesReferenceCollector.$$$reportNull$$$0(0);
            }
            this.myClassRefSet = new LinkedHashSet<PsiClass>();
            this.myResourceRefSet = new LinkedHashSet<ResourceItem>(100);
            this.myManifestRefSet = new HashSet<PsiElement>();
            this.myVisitQueue = new ArrayDeque<PsiElement>();
            this.myGraphBuilder = new AndroidCodeAndResourcesGraph.Builder();
            this.myProject = project;
        }

        public void accumulate(PsiElement ... roots) {
            this.myVisitQueue.clear();
            for (PsiElement element : roots) {
                PsiClass ownerClass;
                PsiClass psiClass = ownerClass = element instanceof PsiClass ? (PsiClass)element : (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
                if (ownerClass == null || !this.myClassRefSet.add(ownerClass)) continue;
                this.myVisitQueue.add((PsiElement)ownerClass);
                this.myGraphBuilder.addRoot((PsiElement)ownerClass);
            }
            HashSet<Object> facetSet = new HashSet<Object>();
            HashSet<VirtualFile> fileScope = new HashSet<VirtualFile>();
            HashSet<PsiElement> elementScope = new HashSet<PsiElement>();
            ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            int numVisited = 0;
            while (!this.myVisitQueue.isEmpty()) {
                PsiElement element = this.myVisitQueue.poll();
                ++numVisited;
                Object facet = AndroidFacet.getInstance(element);
                if (facet == null) continue;
                facetSet.add(facet);
                if (indicator != null) {
                    indicator.setText(String.format("Scanning definition %1$d of %2$d", numVisited, numVisited + this.myVisitQueue.size()));
                    indicator.setFraction((double)numVisited / (double)(numVisited + this.myVisitQueue.size()));
                }
                if (element instanceof PsiClass) {
                    element.accept((PsiElementVisitor)new JavaReferenceVisitor((AndroidFacet)((Object)facet), element));
                    GlobalSearchScope manifestScope = GlobalSearchScope.filesScope((Project)this.myProject, IdeaSourceProvider.getManifestFiles((AndroidFacet)((Object)facet)));
                    ReferencesSearch.search((PsiElement)element, (SearchScope)manifestScope).forEach(reference -> {
                        PsiElement tag = reference.getElement();
                        if ((tag = PsiTreeUtil.getParentOfType((PsiElement)tag, XmlTag.class)) != null) {
                            if (this.myManifestRefSet.add(tag)) {
                                this.myVisitQueue.offer(tag);
                            }
                            this.myGraphBuilder.markReference(element, tag);
                        }
                    });
                    if (((PsiClass)element).getContainingClass() == null) {
                        fileScope.add(element.getContainingFile().getVirtualFile());
                        continue;
                    }
                    elementScope.add(element);
                    continue;
                }
                if (element instanceof PsiFile) {
                    fileScope.add(((PsiFile)element).getVirtualFile());
                } else {
                    elementScope.add(element);
                }
                element.accept((PsiElementVisitor)new XmlResourceReferenceVisitor((AndroidFacet)((Object)facet), element));
            }
            GlobalSearchScope globalSearchScope = GlobalSearchScope.EMPTY_SCOPE;
            for (Object facet : facetSet) {
                globalSearchScope = globalSearchScope.union((SearchScope)facet.getModule().getModuleScope(false));
            }
            GlobalSearchScope visitedScope = GlobalSearchScope.filesScope((Project)this.myProject, fileScope).union(new LocalSearchScope(elementScope.toArray(PsiElement.EMPTY_ARRAY)));
            globalSearchScope = globalSearchScope.intersectWith(GlobalSearchScope.notScope((GlobalSearchScope)visitedScope));
            for (PsiClass clazz : this.myClassRefSet) {
                ReferencesSearch.search((PsiElement)clazz, (SearchScope)globalSearchScope).forEach(reference -> {
                    this.myGraphBuilder.markReferencedOutsideScope((PsiElement)clazz);
                    LOGGER.debug(clazz + " referenced from " + reference.getElement().getContainingFile());
                });
            }
            HashSet<ResourceUrl> seenResourceUrls = new HashSet<ResourceUrl>(this.myResourceRefSet.size());
            for (ResourceItem item : this.myResourceRefSet) {
                PsiField[] fields;
                ResourceUrl url = item.getResourceUrl(false);
                if (!seenResourceUrls.add(url)) continue;
                PsiElement elm = this.getResourceDefinition(item);
                if (elm instanceof PsiFile) {
                    fields = AndroidResourceUtil.findResourceFieldsForFileResource((PsiFile)elm, true);
                } else {
                    if (!(elm instanceof XmlTag)) continue;
                    fields = AndroidResourceUtil.findResourceFieldsForValueResource((XmlTag)elm, true);
                }
                for (PsiField pf : fields) {
                    ReferencesSearch.search((PsiElement)pf, (SearchScope)globalSearchScope).forEach(reference -> {
                        this.myGraphBuilder.markReferencedOutsideScope(elm);
                        LOGGER.debug(item + " referenced from " + reference.getElement().getContainingFile());
                    });
                }
            }
        }

        @NotNull
        public Set<PsiClass> getClassReferences() {
            Set<PsiClass> set = this.myClassRefSet;
            if (set == null) {
                CodeAndResourcesReferenceCollector.$$$reportNull$$$0(1);
            }
            return set;
        }

        @NotNull
        public Set<ResourceItem> getResourceReferences() {
            Set<ResourceItem> set = this.myResourceRefSet;
            if (set == null) {
                CodeAndResourcesReferenceCollector.$$$reportNull$$$0(2);
            }
            return set;
        }

        @NotNull
        public Set<PsiElement> getManifestReferences() {
            Set<PsiElement> set = this.myManifestRefSet;
            if (set == null) {
                CodeAndResourcesReferenceCollector.$$$reportNull$$$0(3);
            }
            return set;
        }

        @NotNull
        public AndroidCodeAndResourcesGraph getReferenceGraph() {
            AndroidCodeAndResourcesGraph androidCodeAndResourcesGraph = this.myGraphBuilder.build();
            if (androidCodeAndResourcesGraph == null) {
                CodeAndResourcesReferenceCollector.$$$reportNull$$$0(4);
            }
            return androidCodeAndResourcesGraph;
        }

        @Nullable
        private PsiElement getResourceDefinition(ResourceItem resource) {
            PsiFile psiFile = LocalResourceRepository.getItemPsiFile(this.myProject, resource);
            if (psiFile == null) {
                return null;
            }
            if (ResourceHelper.getFolderType(psiFile) == ResourceFolderType.VALUES) {
                return LocalResourceRepository.getItemTag(this.myProject, resource);
            }
            return psiFile;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/refactoring/modularize/AndroidModularizeHandler$CodeAndResourcesReferenceCollector";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/refactoring/modularize/AndroidModularizeHandler$CodeAndResourcesReferenceCollector";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getClassReferences";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getResourceReferences";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getManifestReferences";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReferenceGraph";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private class JavaReferenceVisitor
        extends JavaRecursiveElementWalkingVisitor {
            private final AndroidFacet myFacet;
            private final PsiElement mySource;
            private final LocalResourceRepository myResourceRepository;

            JavaReferenceVisitor(@NotNull AndroidFacet facet, PsiElement source) {
                if (facet == null) {
                    JavaReferenceVisitor.$$$reportNull$$$0(0);
                }
                if (source == null) {
                    JavaReferenceVisitor.$$$reportNull$$$0(1);
                }
                this.myFacet = facet;
                this.mySource = source;
                this.myResourceRepository = ModuleResourceRepository.getOrCreateInstance(facet);
            }

            public void visitReferenceExpression(PsiReferenceExpression expression) {
                AndroidPsiUtils.ResourceReferenceType referenceType;
                PsiElement element = expression.resolve();
                if (element instanceof PsiField && (referenceType = AndroidPsiUtils.getResourceReferenceType(expression)) == AndroidPsiUtils.ResourceReferenceType.APP) {
                    String name;
                    List matches;
                    ResourceType type = AndroidPsiUtils.getResourceType((PsiElement)expression);
                    if (type != null && type != ResourceType.ID && (matches = this.myResourceRepository.getResourceItem(type, name = AndroidPsiUtils.getResourceName((PsiElement)expression))) != null) {
                        for (ResourceItem match : matches) {
                            PsiElement target = CodeAndResourcesReferenceCollector.this.getResourceDefinition(match);
                            if (target == null) continue;
                            if (CodeAndResourcesReferenceCollector.this.myResourceRefSet.add(match)) {
                                CodeAndResourcesReferenceCollector.this.myVisitQueue.offer(target);
                            }
                            CodeAndResourcesReferenceCollector.this.myGraphBuilder.markReference(this.mySource, target);
                        }
                    }
                    return;
                }
                super.visitReferenceExpression(expression);
            }

            public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
                PsiElement target = reference.advancedResolve(false).getElement();
                if (target instanceof PsiClass && !(target instanceof PsiTypeParameter) && !(target instanceof SyntheticElement)) {
                    VirtualFile source = target.getContainingFile().getVirtualFile();
                    for (IdeaSourceProvider sourceProvider : IdeaSourceProvider.getCurrentSourceProviders(this.myFacet)) {
                        if (!sourceProvider.containsFile(source)) continue;
                        if (CodeAndResourcesReferenceCollector.this.myClassRefSet.add((PsiClass)target)) {
                            CodeAndResourcesReferenceCollector.this.myVisitQueue.add(target);
                        }
                        if (target != this.mySource) {
                            CodeAndResourcesReferenceCollector.this.myGraphBuilder.markReference(this.mySource, target);
                        }
                        return;
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "facet";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "source";
                        break;
                    }
                }
                objectArray[1] = "com/android/tools/idea/refactoring/modularize/AndroidModularizeHandler$CodeAndResourcesReferenceCollector$JavaReferenceVisitor";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }

        private class XmlResourceReferenceVisitor
        extends XmlRecursiveElementWalkingVisitor {
            private final AndroidFacet myFacet;
            private final PsiElement mySource;
            private final LocalResourceRepository myResourceRepository;

            XmlResourceReferenceVisitor(@NotNull AndroidFacet facet, PsiElement source) {
                if (facet == null) {
                    XmlResourceReferenceVisitor.$$$reportNull$$$0(0);
                }
                if (source == null) {
                    XmlResourceReferenceVisitor.$$$reportNull$$$0(1);
                }
                this.myFacet = facet;
                this.mySource = source;
                this.myResourceRepository = ModuleResourceRepository.getOrCreateInstance(facet);
            }

            public void visitXmlAttributeValue(XmlAttributeValue element) {
                this.processPotentialReference(element.getValue());
            }

            public void visitXmlToken(XmlToken token) {
                this.processPotentialReference(token.getText());
            }

            private void processPotentialReference(String text) {
                ResourceUrl url = ResourceUrl.parse((String)text);
                if (url != null) {
                    List matches;
                    if (!url.framework && !url.create && url.type != ResourceType.ID && (matches = this.myResourceRepository.getResourceItem(url.type, url.name)) != null) {
                        for (ResourceItem match : matches) {
                            PsiElement target = CodeAndResourcesReferenceCollector.this.getResourceDefinition(match);
                            if (target == null) continue;
                            if (CodeAndResourcesReferenceCollector.this.myResourceRefSet.add(match)) {
                                CodeAndResourcesReferenceCollector.this.myVisitQueue.offer(target);
                            }
                            CodeAndResourcesReferenceCollector.this.myGraphBuilder.markReference(this.mySource, target);
                        }
                    }
                } else {
                    PsiClass target = JavaPsiFacade.getInstance((Project)CodeAndResourcesReferenceCollector.this.myProject).findClass(text, this.myFacet.getModule().getModuleScope(false));
                    if (target != null) {
                        if (CodeAndResourcesReferenceCollector.this.myClassRefSet.add(target)) {
                            CodeAndResourcesReferenceCollector.this.myVisitQueue.offer(target);
                        }
                        CodeAndResourcesReferenceCollector.this.myGraphBuilder.markReference(this.mySource, (PsiElement)target);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "facet";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "source";
                        break;
                    }
                }
                objectArray[1] = "com/android/tools/idea/refactoring/modularize/AndroidModularizeHandler$CodeAndResourcesReferenceCollector$XmlResourceReferenceVisitor";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }
}

