/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.module;

import com.android.tools.adtui.ASGallery;
import com.android.tools.adtui.util.FormScalingUtil;
import com.android.tools.idea.npw.module.ModuleGalleryEntry;
import com.android.tools.idea.npw.module.ModuleTemplateGalleryEntry;
import com.android.tools.idea.npw.module.NewModuleModel;
import com.android.tools.idea.wizard.WizardConstants;
import com.android.tools.idea.wizard.model.ModelWizard;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.android.tools.idea.wizard.model.SkippableWizardStep;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.intellij.openapi.project.Project;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.IconUtil;
import com.intellij.util.containers.HashMap;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.ListModel;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChooseModuleTypeStep
extends ModelWizardStep.WithoutModel {
    private final List<ModuleGalleryEntry> myModuleGalleryEntryList;
    private final JComponent myRootPanel;
    private final Project myProject;
    private ASGallery<ModuleGalleryEntry> myFormFactorGallery;
    private Map<ModuleGalleryEntry, SkippableWizardStep> myModuleDescriptionToStepMap;

    public ChooseModuleTypeStep(@NotNull Project project, @NotNull List<ModuleGalleryEntry> moduleGalleryEntries) {
        if (project == null) {
            ChooseModuleTypeStep.$$$reportNull$$$0(0);
        }
        if (moduleGalleryEntries == null) {
            ChooseModuleTypeStep.$$$reportNull$$$0(1);
        }
        super(AndroidBundle.message("android.wizard.module.new.module.header", new Object[0]));
        this.myProject = project;
        this.myModuleGalleryEntryList = ChooseModuleTypeStep.sortModuleEntries(moduleGalleryEntries);
        this.myRootPanel = this.createGallery();
        FormScalingUtil.scaleComponentTree(this.getClass(), (JComponent)this.myRootPanel);
    }

    @Override
    @NotNull
    protected JComponent getComponent() {
        JComponent jComponent = this.myRootPanel;
        if (jComponent == null) {
            ChooseModuleTypeStep.$$$reportNull$$$0(2);
        }
        return jComponent;
    }

    @Override
    @NotNull
    public Collection<? extends ModelWizardStep> createDependentSteps() {
        ArrayList allSteps = Lists.newArrayList();
        this.myModuleDescriptionToStepMap = new HashMap();
        for (ModuleGalleryEntry moduleGalleryEntry : this.myModuleGalleryEntryList) {
            NewModuleModel model = new NewModuleModel(this.myProject);
            if (moduleGalleryEntry instanceof ModuleTemplateGalleryEntry) {
                ModuleTemplateGalleryEntry templateEntry = (ModuleTemplateGalleryEntry)moduleGalleryEntry;
                model.isLibrary().set(templateEntry.isLibrary());
                model.instantApp().set(templateEntry.isInstantApp());
                model.templateFile().setValue(templateEntry.getTemplateFile());
            }
            SkippableWizardStep step = moduleGalleryEntry.createStep(model);
            allSteps.add(step);
            this.myModuleDescriptionToStepMap.put(moduleGalleryEntry, step);
        }
        ArrayList arrayList = allSteps;
        if (arrayList == null) {
            ChooseModuleTypeStep.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @NotNull
    private JComponent createGallery() {
        this.myFormFactorGallery = new ASGallery<ModuleGalleryEntry>((ListModel)JBList.createDefaultListModel((Object[])new Object[0]), image -> image.getIcon() == null ? null : IconUtil.toImage((Icon)image.getIcon()), label -> label == null ? AndroidBundle.message("android.wizard.gallery.item.none", new Object[0]) : label.getName(), WizardConstants.DEFAULT_GALLERY_THUMBNAIL_SIZE, null){

            public Dimension getPreferredScrollableViewportSize() {
                Dimension cellSize = this.computeCellSize();
                int heightInsets = this.getInsets().top + this.getInsets().bottom;
                int widthInsets = this.getInsets().left + this.getInsets().right;
                return new Dimension(cellSize.width * 5 + widthInsets, (int)((double)cellSize.height * 2.2) + heightInsets);
            }
        };
        this.myFormFactorGallery.setBorder(BorderFactory.createLineBorder(JBColor.border()));
        AccessibleContext accessibleContext = this.myFormFactorGallery.getAccessibleContext();
        if (accessibleContext != null) {
            accessibleContext.setAccessibleDescription(this.getTitle());
        }
        JBScrollPane jBScrollPane = new JBScrollPane(this.myFormFactorGallery);
        if (jBScrollPane == null) {
            ChooseModuleTypeStep.$$$reportNull$$$0(4);
        }
        return jBScrollPane;
    }

    @Override
    protected void onWizardStarting(final @NotNull ModelWizard.Facade wizard) {
        if (wizard == null) {
            ChooseModuleTypeStep.$$$reportNull$$$0(5);
        }
        this.myFormFactorGallery.setModel((ListModel)JBList.createDefaultListModel((Object[])this.myModuleGalleryEntryList.toArray()));
        this.myFormFactorGallery.setDefaultAction((Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                wizard.goForward();
            }
        });
        this.myFormFactorGallery.setSelectedIndex(0);
    }

    @Override
    protected void onProceeding() {
        ModuleGalleryEntry selectedEntry = (ModuleGalleryEntry)this.myFormFactorGallery.getSelectedElement();
        this.myModuleDescriptionToStepMap.forEach((galleryEntry, step) -> step.setShouldShow(galleryEntry == selectedEntry));
    }

    @Override
    @Nullable
    protected JComponent getPreferredFocusComponent() {
        return this.myFormFactorGallery;
    }

    @VisibleForTesting
    @NotNull
    static List<ModuleGalleryEntry> sortModuleEntries(@NotNull List<ModuleGalleryEntry> moduleTypesProviders) {
        if (moduleTypesProviders == null) {
            ChooseModuleTypeStep.$$$reportNull$$$0(6);
        }
        String[] orderedNames = new String[]{"Phone & Tablet Module", "Android Library", "Instant App", "Feature Module", "Android Wear Module", "Android TV Module", "Android Things Module", "Import Gradle Project", "Import Eclipse ADT Project", "Import .JAR/.AAR Package", "Java Library", "Google Cloud Module"};
        Map<String, ModuleGalleryEntry> entryMap = moduleTypesProviders.stream().collect(Collectors.toMap(ModuleGalleryEntry::getName, c -> c));
        ArrayList<ModuleGalleryEntry> result = new ArrayList<ModuleGalleryEntry>();
        for (String name : orderedNames) {
            ModuleGalleryEntry entry = entryMap.remove(name);
            if (entry == null) continue;
            result.add(entry);
        }
        ArrayList<ModuleGalleryEntry> secondHalf = new ArrayList<ModuleGalleryEntry>(entryMap.values());
        Collections.sort(secondHalf, Comparator.comparing(ModuleGalleryEntry::getName));
        result.addAll(secondHalf);
        ArrayList<ModuleGalleryEntry> arrayList = result;
        if (arrayList == null) {
            ChooseModuleTypeStep.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleGalleryEntries";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/npw/module/ChooseModuleTypeStep";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wizard";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleTypesProviders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/npw/module/ChooseModuleTypeStep";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createDependentSteps";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createGallery";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "sortModuleEntries";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "onWizardStarting";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "sortModuleEntries";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

