/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.ndk.includes.utils;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.jetbrains.annotations.NotNull;

public class LexicalIncludePaths {
    @NotNull
    public static final ImmutableSet<String> HEADER_FILE_EXTENSIONS = ImmutableSet.of((Object)"", (Object)"h", (Object)"hpp", (Object)"hh", (Object)"h++", (Object)"hxx", (Object[])new String[]{"inl", "tcc", "pch"});
    @NotNull
    private static final String UNIX_SEPARATOR = "/";

    public static boolean hasHeaderExtension(@NotNull String filename) {
        if (filename == null) {
            LexicalIncludePaths.$$$reportNull$$$0(0);
        }
        String extension = FilenameUtils.getExtension((String)filename);
        return HEADER_FILE_EXTENSIONS.contains((Object)extension);
    }

    @NotNull
    public static String findCommonParentFolder(@NotNull Collection<String> folders) {
        if (folders == null) {
            LexicalIncludePaths.$$$reportNull$$$0(1);
        }
        if (folders.isEmpty()) {
            if ("" == null) {
                LexicalIncludePaths.$$$reportNull$$$0(2);
            }
            return "";
        }
        ArrayList<String[]> splits = new ArrayList<String[]>();
        int minSize = Integer.MAX_VALUE;
        for (String folder : folders) {
            String[] split = folder.split(UNIX_SEPARATOR);
            splits.add(split);
            minSize = Math.min(minSize, split.length);
        }
        StringBuilder buildUp = null;
        for (int i = 0; i < minSize; ++i) {
            String prior = null;
            for (String[] split : splits) {
                if (prior == null) {
                    prior = split[i];
                    continue;
                }
                if (prior.equals(split[i])) continue;
                String string = buildUp == null ? "" : buildUp.toString();
                if (string == null) {
                    LexicalIncludePaths.$$$reportNull$$$0(3);
                }
                return string;
            }
            if (buildUp != null) {
                buildUp.append(UNIX_SEPARATOR);
            }
            if (buildUp == null) {
                buildUp = new StringBuilder(prior == null ? "" : prior);
                continue;
            }
            buildUp.append(prior);
        }
        String string = buildUp == null ? "" : buildUp.toString();
        if (string == null) {
            LexicalIncludePaths.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public static String trimPathSeparators(@NotNull String path) {
        String result;
        if (path == null) {
            LexicalIncludePaths.$$$reportNull$$$0(5);
        }
        if ((result = path).endsWith(UNIX_SEPARATOR)) {
            result = result.substring(0, result.length() - 1);
        }
        if (result.startsWith(UNIX_SEPARATOR)) {
            result = result.substring(1);
        }
        String string = result;
        if (string == null) {
            LexicalIncludePaths.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public static Matcher matchFolderToRegex(@NotNull Pattern pattern, @NotNull File folder) {
        if (pattern == null) {
            LexicalIncludePaths.$$$reportNull$$$0(7);
        }
        if (folder == null) {
            LexicalIncludePaths.$$$reportNull$$$0(8);
        }
        Matcher matcher = pattern.matcher(FilenameUtils.separatorsToUnix((String)folder.getPath()) + UNIX_SEPARATOR);
        if (matcher == null) {
            LexicalIncludePaths.$$$reportNull$$$0(9);
        }
        return matcher;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filename";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folders";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/navigator/nodes/ndk/includes/utils/LexicalIncludePaths";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/navigator/nodes/ndk/includes/utils/LexicalIncludePaths";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findCommonParentFolder";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "trimPathSeparators";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "matchFolderToRegex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "hasHeaderExtension";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findCommonParentFolder";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 9: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "trimPathSeparators";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "matchFolderToRegex";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

