/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.ndk;

import com.android.builder.model.NativeArtifact;
import com.android.ide.common.gradle.model.IdeNativeAndroidProject;
import com.android.tools.idea.gradle.project.facet.ndk.NdkFacet;
import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.navigator.nodes.AndroidViewModuleNode;
import com.android.tools.idea.navigator.nodes.ndk.NdkLibraryNode;
import com.google.common.collect.HashMultimap;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NdkModuleNode
extends AndroidViewModuleNode {
    public NdkModuleNode(@NotNull Project project, @NotNull Module value, @NotNull ViewSettings settings) {
        if (project == null) {
            NdkModuleNode.$$$reportNull$$$0(0);
        }
        if (value == null) {
            NdkModuleNode.$$$reportNull$$$0(1);
        }
        if (settings == null) {
            NdkModuleNode.$$$reportNull$$$0(2);
        }
        super(project, value, settings);
    }

    @NotNull
    public Collection<AbstractTreeNode> getChildren() {
        Module module = (Module)this.getValue();
        if (module == null) {
            List<AbstractTreeNode> list = Collections.emptyList();
            if (list == null) {
                NdkModuleNode.$$$reportNull$$$0(3);
            }
            return list;
        }
        NdkFacet facet = NdkFacet.getInstance(module);
        if (facet == null || facet.getNdkModuleModel() == null) {
            List<AbstractTreeNode> list = Collections.emptyList();
            if (list == null) {
                NdkModuleNode.$$$reportNull$$$0(4);
            }
            return list;
        }
        assert (this.myProject != null);
        Collection<AbstractTreeNode> collection = NdkModuleNode.getNativeSourceNodes(this.myProject, facet.getNdkModuleModel(), this.getSettings());
        if (collection == null) {
            NdkModuleNode.$$$reportNull$$$0(5);
        }
        return collection;
    }

    @NotNull
    public static Collection<AbstractTreeNode> getNativeSourceNodes(@NotNull Project project, @NotNull NdkModuleModel ndkModel, @NotNull ViewSettings settings) {
        if (project == null) {
            NdkModuleNode.$$$reportNull$$$0(6);
        }
        if (ndkModel == null) {
            NdkModuleNode.$$$reportNull$$$0(7);
        }
        if (settings == null) {
            NdkModuleNode.$$$reportNull$$$0(8);
        }
        IdeNativeAndroidProject nativeAndroidProject = ndkModel.getAndroidProject();
        Set<String> sourceFileExtensions = nativeAndroidProject.getFileExtensions().keySet();
        NdkModuleModel.NdkVariant variant = ndkModel.getSelectedVariant();
        HashMultimap nativeLibraries = HashMultimap.create();
        for (NativeArtifact artifact : variant.getArtifacts()) {
            String artifactOutputFileName = artifact.getOutputFile().getName();
            nativeLibraries.put((Object)artifactOutputFileName, (Object)artifact);
        }
        if (nativeLibraries.keySet().size() == 1) {
            Collection<AbstractTreeNode> collection = NdkLibraryNode.getSourceFolderNodes(project, nativeLibraries.values(), settings, sourceFileExtensions);
            if (collection == null) {
                NdkModuleNode.$$$reportNull$$$0(9);
            }
            return collection;
        }
        ArrayList<AbstractTreeNode> children = new ArrayList<AbstractTreeNode>();
        for (String name : nativeLibraries.keySet()) {
            String nativeLibraryType = "";
            String nativeLibraryName = StringUtil.trimEnd((String)name, (String)".so");
            if (nativeLibraryName.length() < name.length()) {
                nativeLibraryType = "Shared Library";
            } else {
                nativeLibraryName = StringUtil.trimEnd((String)name, (String)".a");
                if (nativeLibraryName.length() < name.length()) {
                    nativeLibraryType = "Static Library";
                }
            }
            nativeLibraryName = StringUtil.trimStart((String)nativeLibraryName, (String)"lib");
            NdkLibraryNode node = new NdkLibraryNode(project, nativeLibraryName, nativeLibraryType, nativeLibraries.get((Object)name), settings, sourceFileExtensions);
            children.add((AbstractTreeNode)node);
        }
        ArrayList<AbstractTreeNode> arrayList = children;
        if (arrayList == null) {
            NdkModuleNode.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    @Nullable
    public Comparable getSortKey() {
        Module module = (Module)this.getValue();
        if (module == null) {
            return null;
        }
        return module.getName();
    }

    @Nullable
    public Comparable getTypeSortKey() {
        return this.getSortKey();
    }

    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        Module module = (Module)this.getValue();
        if (module == null) {
            return null;
        }
        return String.format("%1$s (Native-Android-Gradle)", ((Module)this.getValue()).getName());
    }

    public void update(@NotNull PresentationData presentation) {
        if (presentation == null) {
            NdkModuleNode.$$$reportNull$$$0(11);
        }
        super.update(presentation);
        Module module = (Module)this.getValue();
        if (module != null) {
            presentation.setIcon(GradleUtil.getModuleIcon(module));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/navigator/nodes/ndk/NdkModuleNode";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ndkModel";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/navigator/nodes/ndk/NdkModuleNode";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getNativeSourceNodes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getNativeSourceNodes";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

