/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.apk.java;

import com.android.tools.idea.apk.debugging.ApkPackage;
import com.android.tools.idea.apk.dex.DexFiles;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;
import org.jf.dexlib2.dexbacked.DexBackedClassDef;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.dexbacked.reference.DexBackedMethodReference;

class DexFileStructure {
    @NotNull
    private final Future<DexBackedDexFile> myDexFileFuture;
    @NotNull
    private final ApkPackages myPackages;
    private boolean myPackagesComputed;

    DexFileStructure(@NotNull VirtualFile dexFile) {
        if (dexFile == null) {
            DexFileStructure.$$$reportNull$$$0(0);
        }
        this.myPackages = new ApkPackages();
        ListeningExecutorService executor = MoreExecutors.listeningDecorator((ExecutorService)PooledThreadExecutor.INSTANCE);
        this.myDexFileFuture = executor.submit(() -> {
            if (dexFile == null) {
                DexFileStructure.$$$reportNull$$$0(2);
            }
            return DexFiles.getDexFile(dexFile);
        });
    }

    @NotNull
    Collection<ApkPackage> getPackages() throws ExecutionException, InterruptedException {
        if (!this.myPackagesComputed) {
            this.myPackagesComputed = true;
            this.computePackages();
        }
        Collection<ApkPackage> collection = this.myPackages.values();
        if (collection == null) {
            DexFileStructure.$$$reportNull$$$0(1);
        }
        return collection;
    }

    private void computePackages() throws ExecutionException, InterruptedException {
        DexBackedDexFile dexFile = this.myDexFileFuture.get();
        Set definitions = dexFile.getClasses().stream().map(DexBackedClassDef::getType).collect(Collectors.toSet());
        int m = dexFile.getMethodCount();
        for (int i = 0; i < m; ++i) {
            DexBackedMethodReference methodRef = new DexBackedMethodReference(dexFile, i);
            String className = DebuggerUtilsEx.signatureToName((String)methodRef.getDefiningClass());
            String definition = "L" + className.replace('.', '/') + ";";
            if (!definitions.contains(definition)) continue;
            this.myPackages.add(className);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dexFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/navigator/nodes/apk/java/DexFileStructure";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/navigator/nodes/apk/java/DexFileStructure";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "lambda$new$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @VisibleForTesting
    static class ApkPackages {
        @NotNull
        private final Map<String, ApkPackage> myPackagesByName = new HashMap<String, ApkPackage>();

        ApkPackages() {
        }

        void add(@NotNull String classFqn) {
            ApkPackage apkPackage;
            if (classFqn == null) {
                ApkPackages.$$$reportNull$$$0(0);
            }
            Pair<String, String> packageAndClassNames = ApkPackages.splitName(classFqn);
            String packageName = (String)packageAndClassNames.getFirst();
            List segments = Splitter.on((char)'.').omitEmptyStrings().splitToList((CharSequence)packageName);
            int segmentCount = segments.size();
            if (segmentCount == 0) {
                apkPackage = this.myPackagesByName.computeIfAbsent(packageName, s -> new ApkPackage("", null));
            } else {
                String first = (String)segments.get(0);
                ApkPackage existing = this.myPackagesByName.get(first);
                if (existing == null) {
                    ApkPackage newPackage = new ApkPackage(first, null);
                    this.myPackagesByName.put(first, newPackage);
                    apkPackage = segmentCount > 1 ? ApkPackages.addChildren(newPackage, segments, 1) : newPackage;
                } else {
                    apkPackage = ApkPackages.findOrCreateMatchingSubpackage(existing, segments);
                }
            }
            apkPackage.addClass((String)packageAndClassNames.getSecond());
        }

        @NotNull
        private static Pair<String, String> splitName(@NotNull String classFqn) {
            int lastDotIndex;
            if (classFqn == null) {
                ApkPackages.$$$reportNull$$$0(1);
            }
            if ((lastDotIndex = classFqn.lastIndexOf(46)) < 0) {
                Pair pair = Pair.create((Object)"", (Object)classFqn);
                if (pair == null) {
                    ApkPackages.$$$reportNull$$$0(2);
                }
                return pair;
            }
            Pair pair = Pair.create((Object)classFqn.substring(0, lastDotIndex), (Object)classFqn.substring(lastDotIndex + 1));
            if (pair == null) {
                ApkPackages.$$$reportNull$$$0(3);
            }
            return pair;
        }

        @NotNull
        private static ApkPackage findOrCreateMatchingSubpackage(@NotNull ApkPackage apkPackage, @NotNull List<String> segments) {
            if (apkPackage == null) {
                ApkPackages.$$$reportNull$$$0(4);
            }
            if (segments == null) {
                ApkPackages.$$$reportNull$$$0(5);
            }
            ApkPackage current = apkPackage;
            int segmentCount = segments.size();
            for (int i = 1; i < segmentCount; ++i) {
                String segment = segments.get(i);
                ApkPackage child = current.findSubpackage(segment);
                if (child == null) {
                    ApkPackage apkPackage2 = ApkPackages.addChildren(current, segments, i);
                    if (apkPackage2 == null) {
                        ApkPackages.$$$reportNull$$$0(6);
                    }
                    return apkPackage2;
                }
                current = child;
            }
            ApkPackage apkPackage3 = current;
            if (apkPackage3 == null) {
                ApkPackages.$$$reportNull$$$0(7);
            }
            return apkPackage3;
        }

        @NotNull
        private static ApkPackage addChildren(@NotNull ApkPackage apkPackage, @NotNull List<String> segments, int index) {
            if (apkPackage == null) {
                ApkPackages.$$$reportNull$$$0(8);
            }
            if (segments == null) {
                ApkPackages.$$$reportNull$$$0(9);
            }
            ApkPackage current = apkPackage;
            int segmentCount = segments.size();
            for (int i = index; i < segmentCount; ++i) {
                String segment = segments.get(i);
                current = current.addSubpackage(segment);
            }
            ApkPackage apkPackage2 = current;
            if (apkPackage2 == null) {
                ApkPackages.$$$reportNull$$$0(10);
            }
            return apkPackage2;
        }

        @NotNull
        Collection<ApkPackage> values() {
            Collection<ApkPackage> collection = this.myPackagesByName.values();
            if (collection == null) {
                ApkPackages.$$$reportNull$$$0(11);
            }
            return collection;
        }

        @Nullable
        ApkPackage findPackage(@NotNull String name) {
            if (name == null) {
                ApkPackages.$$$reportNull$$$0(12);
            }
            return this.myPackagesByName.get(name);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 6: 
                case 7: 
                case 10: 
                case 11: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 6: 
                case 7: 
                case 10: 
                case 11: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classFqn";
                    break;
                }
                case 2: 
                case 3: 
                case 6: 
                case 7: 
                case 10: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/navigator/nodes/apk/java/DexFileStructure$ApkPackages";
                    break;
                }
                case 4: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "apkPackage";
                    break;
                }
                case 5: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "segments";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/navigator/nodes/apk/java/DexFileStructure$ApkPackages";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "splitName";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findOrCreateMatchingSubpackage";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "addChildren";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "values";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "add";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "splitName";
                    break;
                }
                case 2: 
                case 3: 
                case 6: 
                case 7: 
                case 10: 
                case 11: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "findOrCreateMatchingSubpackage";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "addChildren";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "findPackage";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 6: 
                case 7: 
                case 10: 
                case 11: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

