/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.naveditor.scene.draw;

import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.draw.DrawCommandSerializationHelperKt;
import com.android.tools.idea.naveditor.scene.draw.NavBaseDrawCommand;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u0015\b\u0012\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0002\u0010\fB\u000f\b\u0016\u0012\u0006\u0010\r\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u000eB%\u0012\u0006\u0010\u000f\u001a\u00020\u0003\u0012\u0006\u0010\u0010\u001a\u00020\u0005\u0012\u0006\u0010\u0011\u001a\u00020\u0007\u0012\u0006\u0010\u0012\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u0013J\b\u0010\u0014\u001a\u00020\u0007H\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J\b\u0010\u001b\u001a\u00020\u000bH\u0016R\u000e\u0010\u0012\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/android/tools/idea/naveditor/scene/draw/DrawRectangle;", "Lcom/android/tools/idea/naveditor/scene/draw/NavBaseDrawCommand;", "myRectangle", "Ljava/awt/Rectangle;", "myColor", "Ljava/awt/Color;", "myBrushThickness", "", "(Ljava/awt/Rectangle;Ljava/awt/Color;I)V", "sp", "", "", "([Ljava/lang/String;)V", "s", "(Ljava/lang/String;)V", "rectangle", "color", "brushThickness", "arcSize", "(Ljava/awt/Rectangle;Ljava/awt/Color;II)V", "getLevel", "onPaint", "", "g", "Ljava/awt/Graphics2D;", "sceneContext", "Lcom/android/tools/idea/common/scene/SceneContext;", "serialize", "intellij.android.designer"})
public final class DrawRectangle
extends NavBaseDrawCommand {
    private final Rectangle rectangle;
    private final Color color;
    private final int brushThickness;
    private final int arcSize;

    @Override
    public int getLevel() {
        return 1;
    }

    @Override
    @NotNull
    public String serialize() {
        String string = this.getClass().getSimpleName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"javaClass.simpleName");
        return DrawCommandSerializationHelperKt.buildString(string, DrawCommandSerializationHelperKt.rectToString(this.rectangle), DrawCommandSerializationHelperKt.colorToString(this.color), this.brushThickness, this.arcSize);
    }

    @Override
    protected void onPaint(@NotNull Graphics2D g, @NotNull SceneContext sceneContext) {
        Intrinsics.checkParameterIsNotNull((Object)g, (String)"g");
        Intrinsics.checkParameterIsNotNull((Object)sceneContext, (String)"sceneContext");
        g.setColor(this.color);
        g.setStroke(new BasicStroke(this.brushThickness));
        g.drawRoundRect(this.rectangle.x, this.rectangle.y, this.rectangle.width, this.rectangle.height, this.arcSize, this.arcSize);
    }

    public DrawRectangle(@NotNull Rectangle rectangle, @NotNull Color color, int brushThickness, int arcSize) {
        Intrinsics.checkParameterIsNotNull((Object)rectangle, (String)"rectangle");
        Intrinsics.checkParameterIsNotNull((Object)color, (String)"color");
        this.rectangle = rectangle;
        this.color = color;
        this.brushThickness = brushThickness;
        this.arcSize = arcSize;
    }

    public DrawRectangle(@NotNull Rectangle myRectangle, @NotNull Color myColor, int myBrushThickness) {
        Intrinsics.checkParameterIsNotNull((Object)myRectangle, (String)"myRectangle");
        Intrinsics.checkParameterIsNotNull((Object)myColor, (String)"myColor");
        this(myRectangle, myColor, myBrushThickness, 0);
    }

    private DrawRectangle(String[] sp) {
        String string = sp[2];
        Color color = DrawCommandSerializationHelperKt.stringToColor(sp[1]);
        Rectangle rectangle = DrawCommandSerializationHelperKt.stringToRect(sp[0]);
        DrawRectangle drawRectangle = this;
        int n = Integer.parseInt(string);
        string = sp[3];
        int n2 = Integer.parseInt(string);
        drawRectangle(rectangle, color, n, n2);
    }

    public DrawRectangle(@NotNull String s) {
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        this(DrawCommandSerializationHelperKt.parse(s, 4));
    }
}

