/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.monitor.gpu.gfxinfohandlers;

import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.MultiLineReceiver;
import com.android.tools.adtui.TimelineData;
import com.android.tools.idea.monitor.gpu.GpuSampler;
import com.android.tools.idea.monitor.gpu.gfxinfohandlers.GfxinfoHandler;
import com.android.tools.idea.monitor.gpu.gfxinfohandlers.JHandler;
import com.intellij.util.ThreeState;
import gnu.trove.TFloatArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LHandler
implements GfxinfoHandler {
    public static final int MIN_API_LEVEL = 21;
    private ProcessStatReceiver myReceiver = new ProcessStatReceiver();
    private long myLastSampleTime;
    private boolean myDelimiterAdded = true;
    private boolean myIgnoreInitialSamples = true;

    @Override
    public boolean accept(@NotNull Client client) {
        if (client == null) {
            LHandler.$$$reportNull$$$0(0);
        }
        return GpuSampler.decodeApiLevel(client) >= 21;
    }

    @Override
    public void setClient(@Nullable Client client) {
        this.myLastSampleTime = System.currentTimeMillis();
        this.myReceiver.reset();
        this.myDelimiterAdded = true;
        this.myIgnoreInitialSamples = true;
    }

    @Override
    public void sample(@NotNull IDevice device, @NotNull ClientData data, @NotNull TimelineData timeline) throws Exception {
        if (device == null) {
            LHandler.$$$reportNull$$$0(1);
        }
        if (data == null) {
            LHandler.$$$reportNull$$$0(2);
        }
        if (timeline == null) {
            LHandler.$$$reportNull$$$0(3);
        }
        int pid = data.getPid();
        long currentTime = System.currentTimeMillis();
        this.myReceiver.resetSamples();
        device.executeShellCommand("dumpsys gfxinfo " + pid, (IShellOutputReceiver)this.myReceiver, 1L, TimeUnit.SECONDS);
        long timeDelta = currentTime - this.myLastSampleTime;
        if (this.myReceiver.getLogSize() > 0) {
            if (this.myDelimiterAdded) {
                timeline.add(this.myLastSampleTime, 1, new float[]{0.0f, 0.0f, 0.0f, 0.0f});
                this.myDelimiterAdded = false;
            }
            if (!this.myIgnoreInitialSamples) {
                for (int i = 0; i < this.myReceiver.getLogSize(); ++i) {
                    long time2 = timeDelta * (long)(i + 1) / (long)this.myReceiver.getLogSize() + this.myLastSampleTime;
                    timeline.add(time2, 1, new float[]{this.myReceiver.getDrawTime(i).floatValue(), this.myReceiver.getPrepareTime(i).floatValue(), this.myReceiver.getProcessTime(i).floatValue(), this.myReceiver.getExecuteTime(i).floatValue()});
                }
            }
            this.myIgnoreInitialSamples = false;
        } else {
            if (!this.myDelimiterAdded) {
                timeline.add(this.myLastSampleTime, 1, new float[]{0.0f, 0.0f, 0.0f, 0.0f});
                this.myDelimiterAdded = true;
            }
            timeline.add(currentTime, 1, new float[]{0.0f, 0.0f, 0.0f, 0.0f});
        }
        this.myLastSampleTime = currentTime;
    }

    @Override
    @NotNull
    public TimelineData createTimelineData() {
        TimelineData timelineData = new TimelineData(4, 8192);
        if (timelineData == null) {
            LHandler.$$$reportNull$$$0(4);
        }
        return timelineData;
    }

    @Override
    public ThreeState getIsEnabledOnDevice(@NotNull IDevice device) {
        if (device == null) {
            LHandler.$$$reportNull$$$0(5);
        }
        return JHandler.parseIsEnabledOnDevice(device);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timeline";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/monitor/gpu/gfxinfohandlers/LHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/monitor/gpu/gfxinfohandlers/LHandler";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createTimelineData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "sample";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getIsEnabledOnDevice";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class ProcessStatReceiver
    extends MultiLineReceiver {
        private List<String> myOutput = new ArrayList<String>();
        private TFloatArrayList myDrawTimes = new TFloatArrayList();
        private TFloatArrayList myPrepareTimes = new TFloatArrayList();
        private TFloatArrayList myProcessTimes = new TFloatArrayList();
        private TFloatArrayList myExecuteTimes = new TFloatArrayList();

        private ProcessStatReceiver() {
        }

        public void reset() {
            this.resetSamples();
        }

        public void resetSamples() {
            this.myOutput.clear();
            this.myDrawTimes.resetQuick();
            this.myPrepareTimes.resetQuick();
            this.myProcessTimes.resetQuick();
            this.myExecuteTimes.resetQuick();
        }

        public int getLogSize() {
            return this.myExecuteTimes.size();
        }

        @Nullable
        public Float getDrawTime(int index) {
            return Float.valueOf(this.myDrawTimes.get(index));
        }

        @Nullable
        public Float getPrepareTime(int index) {
            return Float.valueOf(this.myPrepareTimes.get(index));
        }

        @Nullable
        public Float getProcessTime(int index) {
            return Float.valueOf(this.myProcessTimes.get(index));
        }

        @Nullable
        public Float getExecuteTime(int index) {
            return Float.valueOf(this.myExecuteTimes.get(index));
        }

        public boolean isCancelled() {
            return false;
        }

        public void processNewLines(@NotNull String[] lines) {
            if (lines == null) {
                ProcessStatReceiver.$$$reportNull$$$0(0);
            }
            this.myOutput.addAll(Arrays.asList(lines));
        }

        public void done() {
            String line;
            super.done();
            block2: for (int profileSectionIndex = 0; profileSectionIndex < this.myOutput.size(); ++profileSectionIndex) {
                if (!this.myOutput.get(profileSectionIndex).startsWith("Profile data in ms:")) continue;
                ++profileSectionIndex;
                while (profileSectionIndex < this.myOutput.size()) {
                    String[] tokens = this.myOutput.get(profileSectionIndex).split("\\s+");
                    if (tokens.length == 4 && "Draw".equals(tokens[0]) && "Prepare".equals(tokens[1]) && "Process".equals(tokens[2]) && "Execute".equals(tokens[3])) {
                        ++profileSectionIndex;
                        break block2;
                    }
                    ++profileSectionIndex;
                }
                break;
            }
            for (int i = profileSectionIndex; i < this.myOutput.size() && !(line = this.myOutput.get(i)).startsWith("View hierarchy:"); ++i) {
                String[] timings = line.split("\\s+");
                if (timings.length != 4) continue;
                try {
                    this.myDrawTimes.add(Float.parseFloat(timings[0]));
                    this.myPrepareTimes.add(Float.parseFloat(timings[1]));
                    this.myProcessTimes.add(Float.parseFloat(timings[2]));
                    this.myExecuteTimes.add(Float.parseFloat(timings[3]));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lines", "com/android/tools/idea/monitor/gpu/gfxinfohandlers/LHandler$ProcessStatReceiver", "processNewLines"));
        }
    }
}

