/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.sdklib.SdkVersionInfo;
import com.intellij.codeInsight.generation.surroundWith.JavaWithIfSurrounder;
import com.intellij.codeInspection.JavaSuppressionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.inspections.lint.AndroidQuickfixContexts;
import org.jetbrains.annotations.NotNull;

public class AddTargetVersionCheckQuickFix
implements AndroidLintQuickFix {
    private int myApi;

    public AddTargetVersionCheckQuickFix(int api) {
        this.myApi = api;
    }

    @NotNull
    static String getVersionField(int myApi, boolean fullyQualified) {
        String codeName = SdkVersionInfo.getBuildCode((int)myApi);
        if (codeName == null) {
            String string = Integer.toString(myApi);
            if (string == null) {
                AddTargetVersionCheckQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }
        if (fullyQualified) {
            String string = "android.os.Build.VERSION_CODES." + codeName;
            if (string == null) {
                AddTargetVersionCheckQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = codeName;
        if (string == null) {
            AddTargetVersionCheckQuickFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    public String getName() {
        String string = "Surround with if (VERSION.SDK_INT >= VERSION_CODES." + AddTargetVersionCheckQuickFix.getVersionField(this.myApi, false) + ") { ... }";
        if (string == null) {
            AddTargetVersionCheckQuickFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
        if (startElement == null) {
            AddTargetVersionCheckQuickFix.$$$reportNull$$$0(4);
        }
        if (endElement == null) {
            AddTargetVersionCheckQuickFix.$$$reportNull$$$0(5);
        }
        if (contextType == null) {
            AddTargetVersionCheckQuickFix.$$$reportNull$$$0(6);
        }
        if (AndroidFacet.getInstance(endElement) == null) {
            return false;
        }
        PsiExpression expression = (PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)startElement, PsiExpression.class, (boolean)false);
        return expression != null;
    }

    @Override
    public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
        PsiExpression expression;
        if (startElement == null) {
            AddTargetVersionCheckQuickFix.$$$reportNull$$$0(7);
        }
        if (endElement == null) {
            AddTargetVersionCheckQuickFix.$$$reportNull$$$0(8);
        }
        if (context == null) {
            AddTargetVersionCheckQuickFix.$$$reportNull$$$0(9);
        }
        if ((expression = (PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)startElement, PsiExpression.class, (boolean)false)) == null) {
            return;
        }
        PsiStatement anchorStatement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiStatement.class);
        Editor editor = PsiUtilBase.findEditor((PsiElement)expression);
        if (editor == null) {
            return;
        }
        PsiModifierListOwner owner = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)startElement, PsiModifierListOwner.class, (boolean)false);
        PsiFile file = expression.getContainingFile();
        Project project = expression.getProject();
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        Document document = documentManager.getDocument(file);
        if (document == null) {
            return;
        }
        PsiElement[] elements = new PsiElement[]{anchorStatement};
        PsiElement prev = PsiTreeUtil.skipWhitespacesBackward((PsiElement)anchorStatement);
        if (prev instanceof PsiComment && JavaSuppressionUtil.getSuppressedInspectionIdsIn((PsiElement)prev) != null) {
            elements = new PsiElement[]{prev, anchorStatement};
        }
        try {
            TextRange textRange = new JavaWithIfSurrounder().surroundElements(project, editor, elements);
            if (textRange == null) {
                return;
            }
            String newText = "android.os.Build.VERSION.SDK_INT >= " + AddTargetVersionCheckQuickFix.getVersionField(this.myApi, true);
            document.replaceString(textRange.getStartOffset(), textRange.getEndOffset(), (CharSequence)newText);
            documentManager.commitDocument(document);
            editor.getCaretModel().moveToOffset(textRange.getEndOffset() + newText.length());
            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            if (owner != null && owner.isValid() && !ApplicationManager.getApplication().isUnitTestMode()) {
                JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)owner);
            }
        }
        catch (IncorrectOperationException e) {
            Logger.getInstance(AddTargetVersionCheckQuickFix.class).error((Throwable)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/lint/AddTargetVersionCheckQuickFix";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextType";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersionField";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/lint/AddTargetVersionCheckQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

